/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.api.laser.ILaserReceiver;
import pl.asie.charset.api.laser.LaserColor;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.scheduler.Scheduler;
import pl.asie.charset.module.laser.CharsetLaser;
import pl.asie.charset.module.laser.system.LaserBeam;
import pl.asie.charset.module.laser.system.LaserSource;

public class TileJar
extends TileBase {
    private final ILaserReceiver[] receivers = new ILaserReceiver[6];
    private LaserColor[] colors = new LaserColor[6];
    private LaserColor outputColor = LaserColor.NONE;
    private LaserSource source;
    private EnumFacing jarFacing;

    private void recalculateOutputColor() {
        LaserColor newOutputColor = LaserColor.NONE;
        boolean set = false;
        EnumFacing jarFacing = this.getJarFacing();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (facing.func_176740_k() == jarFacing.func_176740_k()) continue;
            newOutputColor = newOutputColor.union(this.colors[facing.ordinal()]);
            if (this.colors[facing.ordinal()] == LaserColor.NONE) continue;
            set = true;
        }
        newOutputColor = newOutputColor.difference(this.colors[jarFacing.func_176734_d().ordinal()]);
        if (this.colors[jarFacing.func_176734_d().ordinal()] != LaserColor.NONE) {
            set = true;
        }
        if (set && this.outputColor != newOutputColor) {
            this.outputColor = newOutputColor;
            this.markBlockForUpdate();
            CharsetLaser.laserStorage.markLaserForUpdate(this, this.getJarFacing());
        }
    }

    public TileJar() {
        for (int i = 0; i < 6; ++i) {
            int _i = i;
            this.colors[i] = LaserColor.NONE;
            this.receivers[i] = color -> {
                this.colors[_i] = color;
                this.recalculateOutputColor();
            };
        }
        this.source = new LaserSource(this){

            @Override
            public void updateBeam() {
                EnumFacing jarFacing = TileJar.this.getJarFacing();
                if (TileJar.this.outputColor == LaserColor.NONE) {
                    this.beam = null;
                } else if (this.beam == null || !this.beam.isValid() || !this.beam.getStart().equals((Object)TileJar.this.func_174877_v()) || this.beam.getColor() != TileJar.this.outputColor || this.beam.getDirection() != jarFacing) {
                    this.beam = new LaserBeam(TileJar.this, jarFacing, TileJar.this.outputColor);
                }
            }
        };
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int i = 0; i < 6; ++i) {
            this.colors[i] = LaserColor.NONE;
        }
    }

    public EnumFacing getJarFacing() {
        if (this.jarFacing == null) {
            this.jarFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)Properties.FACING);
        }
        return this.jarFacing;
    }

    public void updateRotations() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == CharsetLaser.blockJar) {
            this.jarFacing = null;
            this.recalculateOutputColor();
            CharsetLaser.laserStorage.markLaserForUpdate(this, this.getJarFacing());
        } else {
            Scheduler.INSTANCE.in(this.field_145850_b, 0, this::updateRotations);
        }
    }

    @Override
    public ItemStack getDroppedBlock(IBlockState state) {
        return new ItemStack(CharsetLaser.blockJar, 1, this.outputColor.ordinal());
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        this.outputColor = LaserColor.VALUES[stack.func_77952_i() & 7];
    }

    public void onLoad() {
        CharsetLaser.laserStorage.registerLaserSources(this.func_145831_w(), this.func_174877_v());
    }

    @Override
    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        this.outputColor = LaserColor.VALUES[compound.func_74771_c("color")];
        if (isClient) {
            this.markBlockForRenderUpdate();
        }
    }

    @Override
    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        compound.func_74774_a("color", (byte)this.outputColor.ordinal());
        return compound;
    }

    public LaserColor getColor() {
        return this.outputColor;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing != null) {
            EnumFacing jarFacing;
            if (capability == CharsetLaser.LASER_RECEIVER) {
                return true;
            }
            if (capability == CharsetLaser.LASER_SOURCE && facing == (jarFacing = this.getJarFacing())) {
                return true;
            }
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null) {
            EnumFacing jarFacing;
            if (capability == CharsetLaser.LASER_RECEIVER) {
                return (T)CharsetLaser.LASER_RECEIVER.cast((Object)this.receivers[facing.ordinal()]);
            }
            if (capability == CharsetLaser.LASER_SOURCE && facing == (jarFacing = this.getJarFacing())) {
                return (T)CharsetLaser.LASER_SOURCE.cast((Object)this.source);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.updateRotations();
    }
}

