/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser.blocks;

import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.api.laser.LaserColor;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.module.laser.CharsetLaser;
import pl.asie.charset.module.laser.system.LaserBeam;
import pl.asie.charset.module.laser.system.LaserSource;

public class TileLaserSourceBase
extends TileBase {
    protected final LaserColor[] colors = new LaserColor[6];
    private final LaserSource[] sources = new LaserSource[6];

    public TileLaserSourceBase() {
        for (int i = 0; i < 6; ++i) {
            this.colors[i] = LaserColor.NONE;
            this.sources[i] = this.createLaserSource(i);
        }
    }

    protected LaserSource createLaserSource(final int i) {
        return new LaserSource(this){

            @Override
            public void updateBeam() {
                if (TileLaserSourceBase.this.colors[i] == LaserColor.NONE) {
                    this.beam = null;
                } else if (this.beam == null || !this.beam.isValid() || !this.beam.getStart().equals((Object)TileLaserSourceBase.this.func_174877_v()) || this.beam.getColor() != TileLaserSourceBase.this.colors[i]) {
                    this.beam = new LaserBeam(TileLaserSourceBase.this, EnumFacing.func_82600_a((int)i), TileLaserSourceBase.this.colors[i]);
                }
            }
        };
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int i = 0; i < 6; ++i) {
            this.colors[i] = LaserColor.NONE;
        }
    }

    public void onLoad() {
        CharsetLaser.laserStorage.registerLaserSources(this.func_145831_w(), this.func_174877_v());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return facing != null && capability == CharsetLaser.LASER_SOURCE || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CharsetLaser.LASER_SOURCE) {
            return (T)CharsetLaser.LASER_SOURCE.cast((Object)this.sources[facing.ordinal()]);
        }
        return (T)super.getCapability(capability, facing);
    }
}

