/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser.system;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.laser.ILaserReceiver;
import pl.asie.charset.api.laser.LaserColor;
import pl.asie.charset.lib.utils.Utils;
import pl.asie.charset.module.laser.CharsetLaser;
import pl.asie.charset.module.laser.system.DummyLaserSource;
import pl.asie.charset.module.laser.system.ILaserEndpoint;
import pl.asie.charset.module.laser.system.LaserSource;
import pl.asie.charset.patchwork.CharsetPatchwork;

public final class LaserBeam
implements ILaserEndpoint {
    public static final int MAX_DISTANCE = 64;
    private static long ID_COUNTER = 1L;
    private final long id;
    @Nonnull
    private final LaserSource source;
    @Nonnull
    private final World world;
    @Nonnull
    private final BlockPos start;
    @Nonnull
    private final BlockPos end;
    @Nonnull
    private final LaserColor color;
    @Nonnull
    private final EnumFacing direction;
    private int length;
    private boolean isValidated;
    @SideOnly(value=Side.CLIENT)
    protected Vec3d vcstart;
    @SideOnly(value=Side.CLIENT)
    protected Vec3d vcend;
    @SideOnly(value=Side.CLIENT)
    protected float vcdist;

    public LaserBeam(@Nonnull TileEntity tile, @Nonnull EnumFacing facing, @Nonnull LaserColor color) {
        this((LaserSource)tile.getCapability(CharsetLaser.LASER_SOURCE, facing), tile.func_145831_w(), tile.func_174877_v(), facing, color);
    }

    public LaserBeam(@Nonnull LaserSource source, @Nonnull World world, @Nonnull BlockPos start, @Nonnull EnumFacing facing, @Nonnull LaserColor color) {
        this.id = ID_COUNTER++;
        this.source = source;
        this.world = world;
        this.start = start;
        this.direction = facing;
        this.color = color;
        this.end = this.calculateEnd();
        this.validate();
    }

    public LaserBeam(PacketBuffer buffer) throws IOException {
        this.id = buffer.readLong();
        this.world = Utils.getLocalWorld(buffer.readInt());
        this.start = buffer.func_179259_c();
        this.length = buffer.readUnsignedShort();
        short flags = buffer.readUnsignedByte();
        this.direction = EnumFacing.func_82600_a((int)(flags & 7));
        this.color = LaserColor.VALUES[flags >> 3 & 7];
        this.source = new DummyLaserSource(this.world != null ? this.world.func_175625_s(this.start) : null);
        this.end = this.start.func_177967_a(this.direction, this.length);
        this.validate();
    }

    public void writeData(PacketBuffer buf) {
        buf.writeLong(this.id);
        buf.writeInt(this.world.field_73011_w.getDimension());
        buf.func_179255_a(this.start);
        buf.writeShort(this.length);
        buf.writeByte(this.direction.ordinal() | this.color.ordinal() << 3);
    }

    public void validate() {
        this.isValidated = true;
    }

    public void invalidate() {
        this.isValidated = false;
    }

    public void onAdd(boolean updates) {
        if (updates && !this.start.equals((Object)this.end)) {
            TileEntity tile = this.world.func_175625_s(this.end);
            if (tile != null && tile.hasCapability(CharsetLaser.LASER_RECEIVER, this.direction.func_176734_d())) {
                ILaserReceiver receiver = (ILaserReceiver)tile.getCapability(CharsetLaser.LASER_RECEIVER, this.direction.func_176734_d());
                if (receiver != null) {
                    receiver.onLaserUpdate(this.color);
                }
            } else if (CharsetPatchwork.LASER_REDSTONE) {
                this.world.func_190524_a(this.end, Blocks.field_150350_a, this.end.func_177972_a(this.direction.func_176734_d()));
            }
        }
    }

    public void onRemove(boolean updates) {
        this.invalidate();
        if (updates && !this.start.equals((Object)this.end)) {
            TileEntity tile = this.world.func_175625_s(this.end);
            if (tile != null && tile.hasCapability(CharsetLaser.LASER_RECEIVER, this.direction.func_176734_d())) {
                ILaserReceiver receiver = (ILaserReceiver)tile.getCapability(CharsetLaser.LASER_RECEIVER, this.direction.func_176734_d());
                if (receiver != null) {
                    receiver.onLaserUpdate(LaserColor.NONE);
                }
            } else if (CharsetPatchwork.LASER_REDSTONE) {
                this.world.func_190524_a(this.end, Blocks.field_150350_a, this.end.func_177972_a(this.direction.func_176734_d()));
                this.world.func_175685_c(this.end, Blocks.field_150350_a, false);
            }
        }
    }

    protected final Vec3d calculateStartpoint() {
        return new Vec3d((double)this.start.func_177958_n() + 0.5, (double)this.start.func_177956_o() + 0.5, (double)this.start.func_177952_p() + 0.5);
    }

    protected final Vec3d calculateEndpoint() {
        BlockPos pos = this.end;
        Vec3d endPos = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        IBlockState state = this.world.func_180495_p(pos);
        if (state.func_185914_p()) {
            return endPos.func_72441_c((double)this.direction.func_176734_d().func_82601_c() * 0.5, (double)this.direction.func_176734_d().func_96559_d() * 0.5, (double)this.direction.func_176734_d().func_82599_e() * 0.5);
        }
        return endPos;
    }

    private final boolean isBlocker(Chunk chunk, BlockPos pos) {
        TileEntity tile;
        IBlockState state = chunk.func_177435_g(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)this.world, pos)) {
            return false;
        }
        if (state.func_185914_p()) {
            return true;
        }
        if (CharsetLaser.BLOCKING_BLOCKS.contains(state.func_177230_c())) {
            return true;
        }
        if (state.getLightOpacity((IBlockAccess)this.world, pos) >= 192) {
            if (state.func_185917_h()) {
                return true;
            }
            BlockFaceShape shapeA = state.func_193401_d((IBlockAccess)this.world, pos, this.direction);
            BlockFaceShape shapeB = state.func_193401_d((IBlockAccess)this.world, pos, this.direction.func_176734_d());
            if (shapeA != BlockFaceShape.BOWL && shapeA != BlockFaceShape.UNDEFINED || shapeB != BlockFaceShape.BOWL && shapeB != BlockFaceShape.UNDEFINED) {
                return true;
            }
            return true;
        }
        return state.func_177230_c().hasTileEntity(state) && (tile = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.IMMEDIATE)) != null && tile.hasCapability(CharsetLaser.LASER_RECEIVER, this.direction.func_176734_d());
    }

    private BlockPos calculateEnd() {
        int i;
        boolean foundEnd = false;
        BlockPos.MutableBlockPos endPos = new BlockPos.MutableBlockPos(this.start);
        Chunk chunk = this.world.func_175726_f((BlockPos)endPos);
        block7: for (i = 0; i < 64 && !foundEnd; ++i, foundEnd |= this.isBlocker(chunk, (BlockPos)endPos)) {
            endPos.func_189536_c(this.direction);
            switch (this.direction) {
                case UP: 
                case DOWN: {
                    continue block7;
                }
                case NORTH: {
                    if ((endPos.func_177952_p() & 0xF) != 15) continue block7;
                    chunk = this.world.func_175726_f((BlockPos)endPos);
                    continue block7;
                }
                case SOUTH: {
                    if ((endPos.func_177952_p() & 0xF) != 0) continue block7;
                    chunk = this.world.func_175726_f((BlockPos)endPos);
                    continue block7;
                }
                case WEST: {
                    if ((endPos.func_177958_n() & 0xF) != 15) continue block7;
                    chunk = this.world.func_175726_f((BlockPos)endPos);
                    continue block7;
                }
                case EAST: {
                    if ((endPos.func_177958_n() & 0xF) != 0) continue block7;
                    chunk = this.world.func_175726_f((BlockPos)endPos);
                }
            }
        }
        this.length = i;
        return endPos;
    }

    public boolean isValid() {
        Chunk chunk;
        if (!this.isValidated || !this.source.isCacheValid()) {
            return false;
        }
        Chunk endChunk = chunk = this.world.func_175726_f(this.start);
        if (this.direction.func_176740_k() != EnumFacing.Axis.Y && (this.start.func_177958_n() >> 4 != this.end.func_177958_n() >> 4 || this.start.func_177952_p() >> 4 != this.end.func_177952_p() >> 4)) {
            endChunk = this.world.func_175726_f(this.end);
        }
        if (this.length < 64 && !this.isBlocker(endChunk, this.end)) {
            return false;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.start);
        for (int i = 0; i < this.length - 1; ++i) {
            pos.func_189536_c(this.direction);
            switch (this.direction) {
                case UP: 
                case DOWN: {
                    break;
                }
                case NORTH: {
                    if ((pos.func_177952_p() & 0xF) != 15) break;
                    chunk = this.world.func_175726_f((BlockPos)pos);
                    break;
                }
                case SOUTH: {
                    if ((pos.func_177952_p() & 0xF) != 0) break;
                    chunk = this.world.func_175726_f((BlockPos)pos);
                    break;
                }
                case WEST: {
                    if ((pos.func_177958_n() & 0xF) != 15) break;
                    chunk = this.world.func_175726_f((BlockPos)pos);
                    break;
                }
                case EAST: {
                    if ((pos.func_177958_n() & 0xF) != 0) break;
                    chunk = this.world.func_175726_f((BlockPos)pos);
                }
            }
            if (!this.isBlocker(chunk, (BlockPos)pos)) continue;
            return false;
        }
        return true;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public BlockPos getPos() {
        return this.getEnd();
    }

    public BlockPos getStart() {
        return this.start;
    }

    public BlockPos getEnd() {
        return this.end;
    }

    public LaserColor getColor() {
        return this.color;
    }

    @Override
    public EnumFacing getDirection() {
        return this.direction;
    }

    public String toString() {
        return String.format("LaserBeam{%s-[%s]->%s, %s}", this.start.toString(), this.direction.name(), this.end.toString(), this.color.name());
    }

    public long getId() {
        return this.id;
    }
}

