/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser.system;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EnumFaceDirection;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.lib.utils.MathUtils;
import pl.asie.charset.module.laser.CharsetLaser;
import pl.asie.charset.module.laser.system.LaserBeam;
import pl.asie.charset.module.laser.system.SubCommandDebugLasersClient;

public class LaserRenderer {
    private static final float THICKNESS = 0.5f;
    private int renderedLasers;
    private int totalLasers;

    @SubscribeEvent
    public void onGameOverlayDebugRender(RenderGameOverlayEvent.Text event) {
        if (!Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        if (!SubCommandDebugLasersClient.enabled) {
            return;
        }
        event.getLeft().add("");
        event.getLeft().add("[CharsetLaser] L: " + this.renderedLasers + "/" + this.totalLasers);
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        Collection<LaserBeam> beams = CharsetLaser.laserStorage.getLaserBeams((World)world);
        this.renderedLasers = 0;
        this.totalLasers = beams.size();
        if (this.totalLasers == 0) {
            return;
        }
        Minecraft.func_71410_x().field_71424_I.func_76320_a("lasers");
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_187398_d((int)32774);
        GlStateManager.func_179141_d();
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double cameraX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double cameraY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double cameraZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        Frustum camera = new Frustum();
        camera.func_78547_a(cameraX, cameraY, cameraZ);
        Vec3d vp = new Vec3d(cameraX, cameraY, cameraZ);
        int maxDist = Minecraft.func_71410_x().field_71474_y.field_151451_c * 16 + 1;
        Collection<LaserBeam> beamsRender = beams;
        if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            ArrayList<LaserBeam> beamList = new ArrayList<LaserBeam>();
            for (LaserBeam beam : beams) {
                beam.vcstart = beam.calculateStartpoint();
                beam.vcend = beam.calculateEndpoint();
                beam.vcdist = MathUtils.linePointDistance(beam.vcstart, beam.vcend, vp);
                if (beam.vcdist > (float)maxDist || !camera.func_78546_a(new AxisAlignedBB(beam.vcstart.func_178786_a(0.03125, 0.03125, 0.03125), beam.vcend.func_72441_c(0.03125, 0.03125, 0.03125)))) continue;
                beamList.add(beam);
            }
            beamList.sort((first, second) -> Float.compare(second.vcdist, first.vcdist));
        }
        worldrenderer.func_178969_c(-cameraX, -cameraY, -cameraZ);
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (LaserBeam beam : beamsRender) {
            if (!Minecraft.func_71410_x().field_71474_y.field_74347_j) {
                beam.vcstart = beam.calculateStartpoint();
                beam.vcend = beam.calculateEndpoint();
                beam.vcdist = MathUtils.linePointDistance(beam.vcstart, beam.vcend, vp);
                if (beam.vcdist > (float)maxDist) continue;
            }
            Vec3d startVec = beam.vcstart;
            Vec3d endVec = beam.vcend;
            if (beam.getStart().func_177958_n() == beam.getEnd().func_177958_n()) {
                startVec = startVec.func_72441_c(-0.03125, 0.0, 0.0);
                endVec = endVec.func_72441_c(0.03125, 0.0, 0.0);
            }
            if (beam.getStart().func_177956_o() == beam.getEnd().func_177956_o()) {
                startVec = startVec.func_72441_c(0.0, -0.03125, 0.0);
                endVec = endVec.func_72441_c(0.0, 0.03125, 0.0);
            }
            if (beam.getStart().func_177952_p() == beam.getEnd().func_177952_p()) {
                startVec = startVec.func_72441_c(0.0, 0.0, -0.03125);
                endVec = endVec.func_72441_c(0.0, 0.0, 0.03125);
            }
            if (!Minecraft.func_71410_x().field_71474_y.field_74347_j && !camera.func_78546_a(new AxisAlignedBB(startVec, endVec))) continue;
            ++this.renderedLasers;
            int color = CharsetLaser.LASER_COLORS[beam.getColor().ordinal()];
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int a = color >> 24 & 0xFF;
            double[] data = new double[]{startVec.field_72448_b, endVec.field_72448_b, startVec.field_72449_c, endVec.field_72449_c, startVec.field_72450_a, endVec.field_72450_a};
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                for (int i = 0; i < 4; ++i) {
                    EnumFaceDirection.VertexInformation vi = EnumFaceDirection.func_179027_a((EnumFacing)facing).func_179025_a(i);
                    worldrenderer.func_181662_b(data[vi.field_179184_a], data[vi.field_179182_b], data[vi.field_179183_c]).func_181669_b(r, g, b, a).func_181675_d();
                }
            }
        }
        tessellator.func_78381_a();
        worldrenderer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_187398_d((int)32774);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }
}

