/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser.system;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import pl.asie.charset.module.laser.system.LaserBeam;
import pl.asie.charset.module.laser.system.LaserWorldStorage;
import pl.asie.charset.module.laser.system.LaserWorldStorageClient;
import pl.asie.charset.module.laser.system.LaserWorldStorageServer;

public class LaserStorage {
    private final Map<World, LaserWorldStorage> storageMap = new IdentityHashMap<World, LaserWorldStorage>();

    public Collection<LaserBeam> getLaserBeams(World world) {
        if (this.storageMap.containsKey(world)) {
            return this.storageMap.get(world).getLaserBeams();
        }
        return Collections.emptyList();
    }

    public void markLaserForUpdate(TileEntity tile, EnumFacing facing) {
        if (this.storageMap.containsKey(tile.func_145831_w())) {
            this.storageMap.get(tile.func_145831_w()).markLaserForUpdate(tile, facing);
        }
    }

    public void registerLaserSources(World world, BlockPos pos) {
        if (this.storageMap.containsKey(world)) {
            this.storageMap.get(world).registerLaserSources(pos);
        }
    }

    private LaserWorldStorage getOrCreateStorage(World world) {
        if (this.storageMap.containsKey(world)) {
            return this.storageMap.get(world);
        }
        LaserWorldStorage storage = world.field_72995_K ? new LaserWorldStorageClient(world) : new LaserWorldStorageServer(world);
        this.storageMap.put(world, storage);
        return storage;
    }

    @SubscribeEvent
    public void onStartWatching(ChunkWatchEvent.Watch event) {
        EntityPlayerMP player = event.getPlayer();
        if (this.storageMap.containsKey(event.getPlayer().func_71121_q())) {
            ((LaserWorldStorageServer)this.storageMap.get(event.getPlayer().func_71121_q())).onChunkWatchingStart(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.storageMap.containsKey(event.world)) {
            this.storageMap.get(event.world).onTick();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)this.getOrCreateStorage(event.getWorld()));
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.storageMap.remove(event.getWorld());
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (this.storageMap.containsKey(event.getWorld())) {
            this.storageMap.get(event.getWorld()).rescan(event.getWorld(), event.getPos());
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (this.storageMap.containsKey(event.getWorld())) {
            this.storageMap.get(event.getWorld()).rescan(event.getWorld(), event.getPos());
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        this.storageMap.get(event.getWorld()).removeAll(event.getChunk());
        this.storageMap.get(event.getWorld()).rescanAllAffectedChunks(event.getChunk().func_76632_l());
    }

    protected boolean isEndpointHit(World world, BlockPos pos, EnumFacing facing) {
        if (this.storageMap.containsKey(world)) {
            return this.storageMap.get(world).isEndpointHit(pos, facing);
        }
        return false;
    }

    protected void add(LaserBeam beam) {
        this.getOrCreateStorage(beam.getWorld()).add(beam);
    }

    protected void remove(World world, long id) {
        LaserWorldStorage storage = this.getOrCreateStorage(world);
        if (storage instanceof LaserWorldStorageClient) {
            ((LaserWorldStorageClient)storage).removeById(id);
        }
    }

    protected void remove(LaserBeam beam) {
        this.getOrCreateStorage(beam.getWorld()).remove(beam, false);
    }
}

