/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser.system;

import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkWatchEvent;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.scheduler.Scheduler;
import pl.asie.charset.module.laser.CharsetLaser;
import pl.asie.charset.module.laser.system.LaserBeam;
import pl.asie.charset.module.laser.system.LaserWorldStorage;
import pl.asie.charset.module.laser.system.PacketBeamAdd;
import pl.asie.charset.module.laser.system.PacketBeamRemove;

public class LaserWorldStorageServer
extends LaserWorldStorage {
    public static boolean IS_LAZY = false;
    public static int LAZY_LIGHT_DELAY = 1;

    public LaserWorldStorageServer(World world) {
        super(world, true);
    }

    @Override
    public boolean add(LaserBeam beam) {
        if (IS_LAZY) {
            Scheduler.INSTANCE.in(this.world, LAZY_LIGHT_DELAY, () -> {
                if (beam.isValid()) {
                    this.realAdd(beam);
                } else {
                    this.markLaserForUpdate(this.world.func_175625_s(beam.getStart()), beam.getDirection());
                }
            });
            return true;
        }
        return this.realAdd(beam);
    }

    private boolean realAdd(LaserBeam beam) {
        if (super.add(beam)) {
            this.sendPacket(new PacketBeamAdd(beam), beam);
            return true;
        }
        return false;
    }

    protected void onChunkWatchingStart(ChunkWatchEvent.Watch event) {
        EntityPlayerMP player = event.getPlayer();
        ChunkPos pos = event.getChunk();
        Set set = (Set)this.laserBeams.get(ChunkPos.func_77272_a((int)pos.field_77276_a, (int)pos.field_77275_b));
        if (set != null) {
            for (LaserBeam beam : set) {
                CharsetLaser.packet.sendTo(new PacketBeamAdd(beam), (EntityPlayer)player);
            }
        }
    }

    private void sendPacket(Packet packet, LaserBeam beam) {
        CharsetLaser.packet.sendToWatching(packet, beam.getWorld(), beam.getStart(), null);
    }

    @Override
    public boolean remove(LaserBeam beam, boolean alreadyRemoved) {
        if (IS_LAZY) {
            Scheduler.INSTANCE.in(this.world, LAZY_LIGHT_DELAY, () -> this.realRemove(beam, alreadyRemoved));
            return true;
        }
        return this.realRemove(beam, alreadyRemoved);
    }

    private boolean realRemove(LaserBeam beam, boolean alreadyRemoved) {
        if (super.remove(beam, alreadyRemoved)) {
            this.sendPacket(new PacketBeamRemove(beam), beam);
            return true;
        }
        return false;
    }
}

