/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.misc.scaffold;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import pl.asie.charset.lib.block.BlockBase;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.item.ISubItemProvider;
import pl.asie.charset.lib.item.SubItemProviderCache;
import pl.asie.charset.lib.item.SubItemProviderRecipes;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.module.misc.scaffold.CharsetMiscScaffold;
import pl.asie.charset.module.misc.scaffold.ScaffoldCacheInfo;
import pl.asie.charset.module.misc.scaffold.TileScaffold;

public class BlockScaffold
extends BlockBase
implements ITileEntityProvider {
    protected static final int MAX_OVERHANG = 8;
    private static final AxisAlignedBB COLLISION_BOX = new AxisAlignedBB(0.01, 0.0, 0.01, 0.99, 1.0, 0.99);
    private static final AxisAlignedBB COLLISION_BOX_HACKY_SIDES = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);
    private static final AxisAlignedBB COLLISION_BOX_HACKY_TOP = new AxisAlignedBB(-0.0625, 0.9375, -0.0625, 1.0625, 1.0, 1.0625);

    public BlockScaffold() {
        super(Material.field_151575_d);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("axe", 0);
        this.setOpaqueCube(false);
        this.setFullCube(false);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c("charset.scaffold");
    }

    public static ItemStack createStack(ItemMaterial plankMaterial, int stackSize) {
        ItemStack scaffold = new ItemStack((Block)CharsetMiscScaffold.scaffoldBlock, stackSize);
        scaffold.func_77982_d(new NBTTagCompound());
        scaffold.func_77978_p().func_74778_a("plank", plankMaterial.getId());
        return scaffold;
    }

    @Override
    protected ISubItemProvider createSubItemProvider() {
        return new SubItemProviderCache(new SubItemProviderRecipes(() -> CharsetMiscScaffold.scaffoldItem));
    }

    private boolean canStay(IBlockAccess world, BlockPos pos) {
        return this.canStay(world, pos, 0);
    }

    private boolean canStay(IBlockAccess world, BlockPos pos, int overhang) {
        if (overhang >= 8) {
            return false;
        }
        if (!world.func_175623_d(pos.func_177977_b())) {
            return true;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos pos1 = pos.func_177972_a(facing);
            if (world.func_180495_p(pos1).func_177230_c() != this || !this.canStay(world, pos1, overhang + 1)) continue;
            return true;
        }
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_184something) {
        if (ForgeModContainer.fullBoundingBoxLadders) {
            if (entityBox.func_72326_a(COLLISION_BOX.func_186670_a(pos))) {
                collidingBoxes.add(COLLISION_BOX.func_186670_a(pos));
            }
        } else {
            if (entityBox.func_72326_a(COLLISION_BOX_HACKY_SIDES.func_186670_a(pos))) {
                collidingBoxes.add(COLLISION_BOX_HACKY_SIDES.func_186670_a(pos));
            }
            if ((!(entityIn instanceof EntityLivingBase) || !((EntityLivingBase)entityIn).func_70617_f_()) && (double)pos.func_177956_o() + 0.9 <= entityBox.field_72338_b && entityBox.func_72326_a(COLLISION_BOX_HACKY_TOP.func_186670_a(pos))) {
                collidingBoxes.add(COLLISION_BOX_HACKY_TOP.func_186670_a(pos));
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canStay((IBlockAccess)worldIn, pos) && super.func_176196_c(worldIn, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canStay((IBlockAccess)worldIn, pos)) {
            ItemStack droppedStack = new ItemStack((Block)this);
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TileBase) {
                droppedStack = ((TileBase)tile).getDroppedBlock(state);
            }
            ItemUtils.spawnItemEntity(worldIn, new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), droppedStack, 0.1f, 0.1f, 0.1f, 1.0f);
            worldIn.func_175698_g(pos);
        }
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess access, IBlockState state, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (blockAccess.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            return false;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{TileScaffold.PROPERTY});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileScaffold scaffold = (TileScaffold)world.func_175625_s(pos);
        IExtendedBlockState extendedBS = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        if (scaffold != null) {
            return extendedBS.withProperty(TileScaffold.PROPERTY, (Object)ScaffoldCacheInfo.from(scaffold));
        }
        return extendedBS;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileScaffold();
    }
}

