/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.misc.scaffold;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.module.misc.scaffold.BlockScaffold;
import pl.asie.charset.module.misc.scaffold.ItemScaffold;
import pl.asie.charset.module.misc.scaffold.ModelScaffold;
import pl.asie.charset.module.misc.scaffold.TileScaffold;

@CharsetModule(name="misc.scaffold", description="Adds scaffolds you can build up and climb on.", profile=ModuleProfile.STABLE)
public class CharsetMiscScaffold {
    @CharsetModule.Instance
    public static CharsetMiscScaffold instance;
    public static BlockScaffold scaffoldBlock;
    public static ItemScaffold scaffoldItem;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (!ForgeModContainer.fullBoundingBoxLadders) {
            ModCharset.logger.warn("To make Charset scaffolds work better, we recommend enabling fullBoundingBoxLadders in forge.cfg.");
        }
        scaffoldBlock = new BlockScaffold();
        scaffoldItem = new ItemScaffold(scaffoldBlock);
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        RegistryUtils.registerModel((Item)scaffoldItem, 0, "charset:scaffold");
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistryUtils.register(event.getRegistry(), scaffoldBlock, "scaffold");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        RegistryUtils.register(event.getRegistry(), scaffoldItem, "scaffold");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (scaffoldBlock != null) {
            RegistryUtils.register(TileScaffold.class, "scaffold");
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void addCustomModels(TextureStitchEvent.Pre event) {
        ModelScaffold.scaffoldModel = RenderUtils.getModelWithTextures(new ResourceLocation("charset:block/scaffold"), event.getMap());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPostBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:scaffold", "normal"), (Object)ModelScaffold.INSTANCE);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:scaffold", "inventory"), (Object)ModelScaffold.INSTANCE);
    }

    @SubscribeEvent
    public void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        EnumHand hand = event.getHand();
        EnumFacing facing = event.getFace();
        EntityPlayer playerIn = event.getEntityPlayer();
        if (hand != EnumHand.MAIN_HAND) {
            return;
        }
        if (facing == null || facing.func_176740_k() == EnumFacing.Axis.Y) {
            return;
        }
        if (playerIn.func_70093_af()) {
            return;
        }
        World worldIn = event.getWorld();
        BlockPos pos = event.getPos();
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemScaffold && worldIn.func_180495_p(pos).func_177230_c() instanceof BlockScaffold) {
            event.setCanceled(true);
            for (int overhang = 1; overhang < 8; ++overhang) {
                BlockPos targetPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + overhang, pos.func_177952_p());
                if (worldIn.func_175701_a(targetPos) && stack.func_77973_b().func_180614_a(playerIn, worldIn, targetPos, hand, EnumFacing.DOWN, 0.5f, 0.0f, 0.5f) == EnumActionResult.SUCCESS) {
                    return;
                }
                if (!worldIn.func_175623_d(targetPos)) continue;
                return;
            }
        }
    }
}

