/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.misc.shards;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.module.misc.shards.ItemShard;

@CharsetModule(name="misc.shards", description="Adds glowstone-esque shards to glass", profile=ModuleProfile.STABLE)
public class CharsetMiscShards {
    public static ItemShard shardItem;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        shardItem = new ItemShard();
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        RegistryUtils.registerModel(shardItem, 0, "charset:shard");
        for (int i = 1; i <= 16; ++i) {
            RegistryUtils.registerModel(shardItem, i, "charset:shard#inventory_colored");
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        RegistryUtils.register(event.getRegistry(), shardItem, "shard");
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register(new ShapedOreRecipe(new ResourceLocation("charset:glassShard"), new ItemStack(Blocks.field_150359_w), new Object[]{"gg", "gg", Character.valueOf('g'), new ItemStack((Item)shardItem, 1, 0)}).setRegistryName(new ResourceLocation("charset:glassShard")));
        for (int i = 0; i < 16; ++i) {
            event.getRegistry().register(new ShapedOreRecipe(new ResourceLocation("charset:glassShard"), new ItemStack((Block)Blocks.field_150399_cn, 1, i), new Object[]{"gg", "gg", Character.valueOf('g'), new ItemStack((Item)shardItem, 1, i + 1)}).setRegistryName(new ResourceLocation("charset:glassShard_" + i)));
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ItemMaterialRegistry imr = ItemMaterialRegistry.INSTANCE;
        ItemStack shard = new ItemStack((Item)shardItem, 1, 0);
        OreDictionary.registerOre((String)"shardGlass", (ItemStack)new ItemStack((Item)shardItem, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"shardGlassColorless", (ItemStack)shard);
        imr.registerRelation(imr.getOrCreateMaterial(new ItemStack(Blocks.field_150359_w)), imr.getOrCreateMaterial(shard), "shard", "block");
        for (int i = 0; i < 16; ++i) {
            ItemStack shardColored = new ItemStack((Item)shardItem, 1, i + 1);
            imr.registerRelation(imr.getOrCreateMaterial(new ItemStack((Block)Blocks.field_150399_cn, 1, i)), imr.getOrCreateMaterial(shardColored), "shard", "block");
            OreDictionary.registerOre((String)ColorUtils.getOreDictEntry("shardGlass", EnumDyeColor.func_176764_b((int)i)), (ItemStack)shardColored);
        }
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemShard.Color(), new Item[]{shardItem});
    }

    @SubscribeEvent
    public void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.getState() == null) {
            return;
        }
        if (event.getDrops() == null) {
            ModCharset.logger.error("Block " + event.getState().func_177230_c().getRegistryName() + " provides a null getDrops() list, against Forge's original method behaviour! This is a bug in the mod providing it!");
            return;
        }
        if (event.getDrops().size() > 0) {
            return;
        }
        Block block = event.getState().func_177230_c();
        boolean isPane = false;
        int md = 0;
        if (block == Blocks.field_150359_w) {
            md = 0;
        } else if (block == Blocks.field_150399_cn) {
            md = 1 + block.func_176201_c(event.getState());
        } else if (block == Blocks.field_150410_aZ) {
            isPane = true;
        } else if (block == Blocks.field_150397_co) {
            isPane = true;
            md = 1 + block.func_176201_c(event.getState());
        } else {
            return;
        }
        if (event.getDropChance() <= 0.0f) {
            event.setDropChance(1.0f);
        }
        if (isPane) {
            float rand = event.getWorld().field_73012_v.nextFloat();
            if (rand >= 0.5f) {
                event.getDrops().add(new ItemStack((Item)shardItem, 1, md));
            }
        } else {
            int rand = event.getWorld().field_73012_v.nextInt(4) + 1;
            event.getDrops().add(new ItemStack((Item)shardItem, rand, md));
        }
    }
}

