/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.misc.shelf;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.lib.ui.ItemHandlerCharset;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.UnlistedPropertyGeneric;
import pl.asie.charset.module.misc.shelf.ShelfCacheInfo;

public class TileShelf
extends TileBase {
    public static final UnlistedPropertyGeneric<ShelfCacheInfo> PROPERTY = new UnlistedPropertyGeneric<ShelfCacheInfo>("tile", ShelfCacheInfo.class);
    protected ItemStackHandler handler = new ItemHandlerCharset(18);
    private ItemMaterial plank;

    public ItemMaterial getPlank() {
        if (this.plank == null) {
            this.plank = TileShelf.getPlankFromNBT(null);
        }
        return this.plank;
    }

    protected boolean isBook(ItemStack stack) {
        return stack.func_77973_b().func_77658_a().toLowerCase().contains("book");
    }

    private int toNonBookSlotId(int id) {
        return (int)Math.floor((float)id / 3.5f) + 14;
    }

    protected boolean onClicked(float hitX, float hitY, float hitZ, EntityPlayer player) {
        ItemStack stack;
        int slotId = this.getSlotId(hitX, hitY, hitZ);
        if (slotId < 0) {
            return false;
        }
        if (this.handler.getStackInSlot(slotId).func_190926_b()) {
            slotId = this.toNonBookSlotId(slotId);
        }
        if ((stack = this.handler.getStackInSlot(slotId)).func_190926_b()) {
            return false;
        }
        this.handler.setStackInSlot(slotId, ItemStack.field_190927_a);
        this.markBlockForUpdate();
        ItemUtils.giveOrSpawnItemEntity(player, this.func_145831_w(), new Vec3d((Vec3i)this.field_174879_c).func_72441_c((double)hitX, (double)hitY, (double)hitZ), stack, 0.0f, 0.0f, 0.0f, 0.0f);
        return true;
    }

    protected boolean onActivated(float hitX, float hitY, float hitZ, ItemStack stack, EntityPlayer player) {
        int slotId = this.getSlotId(hitX, hitY, hitZ);
        if (slotId < 0) {
            return false;
        }
        if (stack.func_190926_b()) {
            if (this.handler.getStackInSlot(slotId).func_190926_b()) {
                slotId = this.toNonBookSlotId(slotId);
            }
            if (!this.handler.getStackInSlot(slotId).func_190926_b()) {
                int sentSlotId = slotId;
                new Notice((Object)new Vec3d((Vec3i)this.field_174879_c).func_72441_c((double)hitX, (double)hitY, (double)hitZ), msg -> msg.withItem(this.handler.getStackInSlot(sentSlotId)).setMessage((ITextComponent)new TextComponentString("{ITEM_NAME}{ITEM_INFOS_NEWLINE}"))).sendTo(player);
                return true;
            }
            return false;
        }
        if (!this.isBook(stack)) {
            slotId = this.toNonBookSlotId(slotId);
        }
        if (this.isSlotTaken(slotId)) {
            return false;
        }
        stack = stack.func_77979_a(1);
        this.handler.setStackInSlot(slotId, stack);
        this.markBlockForUpdate();
        return true;
    }

    protected int getSlotId(float hitX, float hitY, float hitZ) {
        Vec3d placementVec = new Vec3d((double)(hitX - 0.5f), (double)(hitY - 0.5f), (double)(hitZ - 0.5f));
        placementVec = placementVec.func_178785_b(((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)Properties.FACING4)).func_185119_l() / 180.0f * (float)Math.PI);
        if (placementVec.field_72450_a >= -0.4375 && placementVec.field_72450_a <= 0.4375) {
            return (int)Math.floor((placementVec.field_72450_a + 0.4375) * 7.0) + (placementVec.field_72448_b > 0.0 ? 7 : 0);
        }
        return -1;
    }

    protected boolean isSlotTaken(int slotId) {
        if (!this.handler.getStackInSlot(slotId).func_190926_b()) {
            return true;
        }
        if (slotId < 14) {
            if (slotId >= 0 && slotId <= 3 && !this.handler.getStackInSlot(14).func_190926_b()) {
                return true;
            }
            if (slotId >= 3 && slotId <= 6 && !this.handler.getStackInSlot(15).func_190926_b()) {
                return true;
            }
            if (slotId >= 7 && slotId <= 10 && !this.handler.getStackInSlot(16).func_190926_b()) {
                return true;
            }
            if (slotId >= 10 && slotId <= 14 && !this.handler.getStackInSlot(17).func_190926_b()) {
                return true;
            }
        } else {
            int sSlot = (int)Math.floor((float)(slotId - 14) * 3.5f);
            for (int i = 0; i < 4; ++i) {
                if (this.handler.getStackInSlot(sSlot + i).func_190926_b()) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemMaterial getPlankFromNBT(NBTTagCompound compound) {
        return ItemMaterialRegistry.INSTANCE.getMaterial(compound, "plank", "plank");
    }

    @Override
    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        this.plank = TileShelf.getPlankFromNBT(compound);
        if (compound.func_150297_b("inv", 10)) {
            this.handler.deserializeNBT(compound.func_74775_l("inv"));
        }
    }

    @Override
    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        this.plank.writeToNBT(compound, "plank");
        compound.func_74782_a("inv", (NBTBase)this.handler.serializeNBT());
        return compound;
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        this.loadFromStack(stack);
    }

    public void loadFromStack(ItemStack stack) {
        this.plank = TileShelf.getPlankFromNBT(stack.func_77978_p());
    }

    @Override
    public ItemStack getDroppedBlock(IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c());
        stack.func_77982_d(this.writeNBTData(new NBTTagCompound(), false));
        return stack;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.handler);
        }
        return (T)super.getCapability(capability, facing);
    }
}

