/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.overhaul;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import pl.asie.charset.lib.item.ItemBlockBase;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.recipe.RecipeReplacement;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.module.overhaul.BlockOreQuartz;
import pl.asie.charset.module.overhaul.MapGenStrongholdNull;

@CharsetModule(name="overhaul.oneDimension", description="Removes the Nether and End, and adapts recipes for Nether/End items to either remove them or add new ways of crafting them.", dependencies={"tweak.remove.netherPortals"}, categories={"overhaul"}, profile=ModuleProfile.VERY_UNSTABLE)
public class CharsetOverhaulOneDimension {
    public static BlockOreQuartz quartzOreBlock;
    public static ItemBlockBase quartzOreItem;
    private static WorldGenerator quartzOreGenerator;

    public void generateQuartz(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        for (int i = 0; i < 5; ++i) {
            int x = (chunkX << 4) + random.nextInt(16);
            int y = 8 + random.nextInt(25);
            int z = (chunkZ << 4) + random.nextInt(16);
            quartzOreGenerator.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        quartzOreBlock = new BlockOreQuartz();
        quartzOreItem = new ItemBlockBase(quartzOreBlock);
        quartzOreGenerator = new WorldGenMinable(quartzOreBlock.func_176223_P(), 12, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistryUtils.register(event.getRegistry(), quartzOreBlock, "oreQuartz");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        Items.field_151128_bU.func_77655_b("charset.gemQuartz");
        RegistryUtils.register(event.getRegistry(), quartzOreItem, "oreQuartz");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        RegistryUtils.registerModel((Item)quartzOreItem, 0, "charset:oreQuartz");
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        RecipeReplacement.PRIMARY.add(Item.func_150898_a((Block)Blocks.field_150425_aM), Item.func_150898_a((Block)Blocks.field_150354_m));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        OreDictionary.registerOre((String)"oreQuartz", (Block)quartzOreBlock);
        GameRegistry.registerWorldGenerator(this::generateQuartz, (int)0);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ItemStack glowstoneStack = new ItemStack(Items.field_151114_aO, 1, 0);
        for (ItemStack stack : OreDictionary.getOres((String)"dustRedstone")) {
            FurnaceRecipes.func_77602_a().func_151394_a(stack, glowstoneStack, 0.2f);
        }
        DimensionManager.unregisterDimension((int)1);
        DimensionManager.unregisterDimension((int)-1);
    }

    @SubscribeEvent
    public void disableEndStrongholds(InitMapGenEvent event) {
        if (event.getOriginalGen() instanceof MapGenStronghold) {
            event.setNewGen((MapGenBase)new MapGenStrongholdNull());
        }
    }
}

