/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.barrels;

import com.google.gson.JsonObject;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.JsonContext;
import pl.asie.charset.lib.recipe.IOutputSupplier;
import pl.asie.charset.lib.recipe.IOutputSupplierFactory;
import pl.asie.charset.lib.recipe.IngredientMatcher;
import pl.asie.charset.lib.recipe.RecipeCharset;
import pl.asie.charset.module.storage.barrels.CharsetStorageBarrels;
import pl.asie.charset.module.storage.barrels.ItemDayBarrel;
import pl.asie.charset.module.storage.barrels.ItemMinecartDayBarrel;
import pl.asie.charset.module.storage.barrels.TileEntityDayBarrel;

public class BarrelUpgradeOutputSupplier
implements IOutputSupplier {
    private final TileEntityDayBarrel.Upgrade upgradeType;

    private BarrelUpgradeOutputSupplier(TileEntityDayBarrel.Upgrade upgradeType) {
        this.upgradeType = upgradeType;
    }

    @Override
    public ItemStack getCraftingResult(RecipeCharset recipe, IngredientMatcher matcher, InventoryCrafting inv) {
        for (Ingredient i : matcher.getMatchedIngredients()) {
            ItemStack is = matcher.getStack(i);
            if (!(is.func_77973_b() instanceof ItemDayBarrel) && !(is.func_77973_b() instanceof ItemMinecartDayBarrel)) continue;
            is = is.func_77946_l();
            is.func_190920_e(1);
            return TileEntityDayBarrel.addUpgrade(is, this.upgradeType);
        }
        return null;
    }

    @Override
    public ItemStack getDefaultOutput() {
        return new ItemStack((Item)CharsetStorageBarrels.barrelCartItem);
    }

    public static class Factory
    implements IOutputSupplierFactory {
        @Override
        public IOutputSupplier parse(JsonContext context, JsonObject json) {
            return new BarrelUpgradeOutputSupplier(TileEntityDayBarrel.Upgrade.valueOf(JsonUtils.func_151200_h((JsonObject)json, (String)"upgrade")));
        }
    }
}

