/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.barrels;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.utils.Orientation;
import pl.asie.charset.module.storage.barrels.BarrelCacheInfo;
import pl.asie.charset.module.storage.barrels.BlockBarrel;
import pl.asie.charset.module.storage.barrels.CharsetStorageBarrels;
import pl.asie.charset.module.storage.barrels.TileEntityDayBarrel;

public class EntityMinecartDayBarrel
extends EntityMinecart {
    private static final DataParameter<ItemStack> BARREL_ITEM = EntityDataManager.func_187226_a(EntityMinecartDayBarrel.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<String> BARREL_LOG = EntityDataManager.func_187226_a(EntityMinecartDayBarrel.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> BARREL_SLAB = EntityDataManager.func_187226_a(EntityMinecartDayBarrel.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Byte> BARREL_ORIENTATION = EntityDataManager.func_187226_a(EntityMinecartDayBarrel.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<NBTTagCompound> BARREL_UPGRADES = EntityDataManager.func_187226_a(EntityMinecartDayBarrel.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Integer> BARREL_ITEM_COUNT = EntityDataManager.func_187226_a(EntityMinecartDayBarrel.class, (DataSerializer)DataSerializers.field_187192_b);
    protected TileEntityDayBarrel barrel;
    private IItemHandler itemHandler = new MinecartItemHandler();
    private int activatorRailTicks = 0;

    public EntityMinecartDayBarrel(World world) {
        super(world);
    }

    public EntityMinecartDayBarrel(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public void func_94095_a(DamageSource damage) {
        this.func_70106_y();
        ItemStack itemstack = this.getCartItem();
        if (this.func_95999_t() != null) {
            itemstack.func_151001_c(this.func_95999_t());
        }
        this.func_70099_a(itemstack, 0.0f);
        for (ItemStack stack : this.barrel.getContentDrops(false)) {
            this.func_70099_a(stack, 0.0f);
        }
    }

    public ItemStack getCartItem() {
        ItemStack stack = this.barrel.getDroppedBlock(CharsetStorageBarrels.barrelBlock.func_176223_P());
        ItemStack realStack = new ItemStack((Item)CharsetStorageBarrels.barrelCartItem, 1);
        realStack.func_77982_d(stack.func_77978_p());
        return realStack;
    }

    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.CHEST;
    }

    public EntityMinecartDayBarrel initFromStack(ItemStack is) {
        this.barrel.loadFromStack(is);
        this.updateDataWatcher(true);
        return this;
    }

    public EntityMinecartDayBarrel initFromTile(TileEntityDayBarrel barrel) {
        this.barrel = barrel;
        barrel.func_145834_a(this.field_70170_p);
        barrel.func_174878_a(BlockPos.field_177992_a);
        barrel.isEntity = true;
        barrel.orientation = Orientation.fromDirection(EnumFacing.WEST).pointTopTo(EnumFacing.UP);
        barrel.notice_target = this;
        barrel.func_145829_t();
        this.updateDataWatcher(true);
        return this;
    }

    public TileEntityDayBarrel getTileInternal() {
        return this.barrel;
    }

    private void createBarrel() {
        if (this.barrel != null) {
            return;
        }
        this.barrel = new TileEntityDayBarrel();
        this.barrel.func_145834_a(this.field_70170_p);
        this.barrel.func_174878_a(BlockPos.field_177992_a);
        this.barrel.isEntity = true;
        this.barrel.orientation = Orientation.fromDirection(EnumFacing.WEST).pointTopTo(EnumFacing.UP);
        this.barrel.notice_target = this;
        this.barrel.func_145829_t();
    }

    protected final void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.barrel.readNBTData(tag, false);
        this.updateDataWatcher(true);
    }

    protected final void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        this.barrel.writeNBTData(tag, false);
    }

    protected NBTTagCompound getUpgradesNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (TileEntityDayBarrel.Upgrade u : this.barrel.upgrades) {
            list.func_74742_a((NBTBase)new NBTTagString(u.name()));
        }
        compound.func_74782_a("upgrades", (NBTBase)list);
        return compound;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.createBarrel();
        this.field_70180_af.func_187214_a(BARREL_ITEM, (Object)this.barrel.item);
        this.field_70180_af.func_187214_a(BARREL_ITEM_COUNT, (Object)this.barrel.getItemCount());
        this.field_70180_af.func_187214_a(BARREL_LOG, (Object)this.barrel.woodLog.getId());
        this.field_70180_af.func_187214_a(BARREL_SLAB, (Object)this.barrel.woodSlab.getId());
        this.field_70180_af.func_187214_a(BARREL_ORIENTATION, (Object)((byte)this.barrel.orientation.ordinal()));
        this.field_70180_af.func_187214_a(BARREL_UPGRADES, (Object)this.getUpgradesNBT());
    }

    private void updateDataWatcher(boolean full) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(BARREL_ITEM, (Object)this.barrel.item);
            this.field_70180_af.func_187227_b(BARREL_ITEM_COUNT, (Object)this.barrel.getItemCount());
            if (full) {
                this.field_70180_af.func_187227_b(BARREL_LOG, (Object)this.barrel.woodLog.getId());
                this.field_70180_af.func_187227_b(BARREL_SLAB, (Object)this.barrel.woodSlab.getId());
                this.field_70180_af.func_187227_b(BARREL_ORIENTATION, (Object)((byte)this.barrel.orientation.ordinal()));
                this.field_70180_af.func_187227_b(BARREL_UPGRADES, (Object)this.getUpgradesNBT());
            }
        }
    }

    public void func_96095_a(int x, int y, int z, boolean powered) {
        if (powered) {
            this.activatorRailTicks = this.barrel.getLogicSpeed();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.barrel.item = (ItemStack)this.field_70180_af.func_187225_a(BARREL_ITEM);
            this.barrel.item.func_190920_e(((Integer)this.field_70180_af.func_187225_a(BARREL_ITEM_COUNT)).intValue());
            this.barrel.woodLog = ItemMaterialRegistry.INSTANCE.getMaterial((String)this.field_70180_af.func_187225_a(BARREL_LOG));
            this.barrel.woodSlab = ItemMaterialRegistry.INSTANCE.getMaterial((String)this.field_70180_af.func_187225_a(BARREL_SLAB));
            this.barrel.orientation = Orientation.getOrientation(((Byte)this.field_70180_af.func_187225_a(BARREL_ORIENTATION)).byteValue());
            this.barrel.upgrades.clear();
            TileEntityDayBarrel.populateUpgrades(this.barrel.upgrades, (NBTTagCompound)this.field_70180_af.func_187225_a(BARREL_UPGRADES));
        }
        if (!this.field_70170_p.field_72995_K) {
            this.barrel.func_174878_a(new BlockPos((Entity)this));
            if (this.activatorRailTicks > 0) {
                --this.activatorRailTicks;
            }
            if (this.activatorRailTicks <= 0 && this.field_70170_p.func_82737_E() % (long)this.barrel.getLogicSpeed() == 0L) {
                this.barrel.tick();
                this.updateDataWatcher(false);
            }
        }
    }

    public IBlockState func_174897_t() {
        return ((IExtendedBlockState)CharsetStorageBarrels.barrelBlock.func_176223_P()).withProperty(BlockBarrel.BARREL_INFO, (Object)BarrelCacheInfo.from(this.barrel));
    }

    public IBlockState func_180457_u() {
        return CharsetStorageBarrels.barrelBlock.func_176223_P();
    }

    public boolean func_70097_a(DamageSource source, float f) {
        if (source.func_76364_f() instanceof EntityPlayer) {
            int oldItemCount = this.barrel.getItemCount();
            if (!this.field_70170_p.field_72995_K) {
                this.barrel.click((EntityPlayer)source.func_76364_f());
                this.updateDataWatcher(false);
            }
            if (source.func_76364_f().func_70093_af()) {
                return super.func_70097_a(source, f);
            }
            if (this.field_70170_p.field_72995_K) {
                return true;
            }
            if (this.barrel.upgrades.contains((Object)TileEntityDayBarrel.Upgrade.INFINITE)) {
                return false;
            }
            if (this.barrel.getItemCount() != oldItemCount) {
                return false;
            }
        }
        return super.func_70097_a(source, f);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player, hand))) {
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            boolean result = this.barrel.activate(player, null, hand);
            this.updateDataWatcher(false);
            return result ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public int getComparatorLevel() {
        return this.barrel.getComparatorValue();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == Capabilities.BARREL || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
        }
        if (capability == Capabilities.BARREL) {
            return (T)Capabilities.BARREL.cast((Object)this.barrel);
        }
        return (T)super.getCapability(capability, facing);
    }

    public class MinecartItemHandler
    implements IItemHandler {
        public int getSlots() {
            return 1;
        }

        public int getSlotLimit(int slot) {
            return EntityMinecartDayBarrel.this.barrel.readOnlyView.getSlotLimit(slot);
        }

        public ItemStack getStackInSlot(int slot) {
            return EntityMinecartDayBarrel.this.barrel.readOnlyView.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!simulate) {
                EntityMinecartDayBarrel.this.updateDataWatcher(false);
            }
            return EntityMinecartDayBarrel.this.barrel.insertionView.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!simulate) {
                EntityMinecartDayBarrel.this.updateDataWatcher(false);
            }
            return EntityMinecartDayBarrel.this.barrel.extractionView.extractItem(slot, amount, simulate);
        }
    }
}

