/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.barrels;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import pl.asie.charset.lib.recipe.IngredientCharset;
import pl.asie.charset.module.storage.barrels.CharsetStorageBarrels;
import pl.asie.charset.module.storage.barrels.TileEntityDayBarrel;

public class IngredientBarrel
extends IngredientCharset {
    private boolean includeCarts;
    private Set<TileEntityDayBarrel.Upgrade> upgradeBlacklist;

    private static Set<TileEntityDayBarrel.Upgrade> setFromJson(JsonContext context, JsonObject jsonObject, String memberName) {
        if (jsonObject.has(memberName)) {
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            JsonArray array = JsonUtils.func_151214_t((JsonObject)jsonObject, (String)memberName);
            for (JsonElement element : array) {
                builder.add((Object)TileEntityDayBarrel.Upgrade.valueOf(element.getAsString()));
            }
            return builder.build();
        }
        return Collections.emptySet();
    }

    public IngredientBarrel(JsonContext context, JsonObject json) {
        super(0);
        this.includeCarts = JsonUtils.func_151209_a((JsonObject)json, (String)"carts", (boolean)false);
        this.upgradeBlacklist = IngredientBarrel.setFromJson(context, json, "upgradeBlacklist");
    }

    @Override
    public boolean mustIteratePermutations() {
        return true;
    }

    public ItemStack[] func_193365_a() {
        List<ItemStack> stacks = CharsetStorageBarrels.BARRELS_NORMAL;
        ArrayList stacks2 = Lists.newArrayList();
        for (ItemStack s : stacks) {
            stacks2.add(s);
            if (!this.includeCarts) continue;
            stacks2.add(CharsetStorageBarrels.barrelCartItem.makeBarrelCart(s));
        }
        return stacks.toArray(new ItemStack[stacks.size()]);
    }

    public boolean apply(ItemStack stack) {
        if (!stack.func_190926_b() && (stack.func_77973_b() == CharsetStorageBarrels.barrelItem || this.includeCarts && stack.func_77973_b() == CharsetStorageBarrels.barrelCartItem)) {
            if (!this.upgradeBlacklist.isEmpty()) {
                EnumSet<TileEntityDayBarrel.Upgrade> upgrades = EnumSet.noneOf(TileEntityDayBarrel.Upgrade.class);
                TileEntityDayBarrel.populateUpgrades(upgrades, stack.func_77978_p());
                for (TileEntityDayBarrel.Upgrade upgrade : this.upgradeBlacklist) {
                    if (!upgrades.contains((Object)upgrade)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static class Factory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            return new IngredientBarrel(context, json);
        }
    }
}

