/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.barrels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.asie.charset.api.lib.IAxisRotatable;
import pl.asie.charset.api.lib.ICacheable;
import pl.asie.charset.api.locks.Lockable;
import pl.asie.charset.api.storage.IBarrel;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.capability.CapabilityCache;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.lib.scheduler.Scheduler;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.Orientation;
import pl.asie.charset.lib.utils.ProxiedBlockAccess;
import pl.asie.charset.lib.utils.RayTraceUtils;
import pl.asie.charset.lib.utils.RedstoneUtils;
import pl.asie.charset.lib.utils.SpaceUtils;
import pl.asie.charset.module.storage.barrels.CharsetStorageBarrels;
import pl.asie.charset.module.storage.barrels.PacketBarrelCountUpdate;

public class TileEntityDayBarrel
extends TileBase
implements IBarrel,
ICacheable,
ITickable,
IAxisRotatable {
    public ItemStack item = ItemStack.field_190927_a;
    public ItemMaterial woodLog;
    public ItemMaterial woodSlab;
    public Orientation orientation = Orientation.FACE_UP_POINT_NORTH;
    public Set<Upgrade> upgrades = EnumSet.noneOf(Upgrade.class);
    Object notice_target = this;
    protected final Lockable lockable = new Lockable(this);
    protected final InsertionHandler insertionView = new InsertionHandler();
    protected final ExtractionHandler extractionView = new ExtractionHandler();
    protected final ReadableItemHandler readOnlyView = new ReadableItemHandler();
    protected boolean isEntity;
    private CapabilityCache.Single<IItemHandler> helperTop;
    private CapabilityCache.Single<IItemHandler> helperBottom;
    private ProxiedBlockAccess woodLogAccess;
    private static final Upgrade[][] OLD_TYPE_ORDER = new Upgrade[][]{new Upgrade[0], {Upgrade.SILKY}, {Upgrade.HOPPING}, new Upgrade[0], {Upgrade.STICKY}, {Upgrade.INFINITE, Upgrade.HOPPING}};
    private boolean updateRedstoneLevels;
    private int redstoneLevel;
    private int lastMentionedCount = -1;
    private boolean scheduledTick = true;
    private boolean spammed = false;
    private final WeakHashMap<EntityPlayer, Long> lastClickMap = new WeakHashMap();

    @Override
    public boolean isCacheValid() {
        return !this.isEntity && !this.func_145837_r();
    }

    public TileEntityDayBarrel() {
        this.woodLog = TileEntityDayBarrel.getLog(null);
        this.woodSlab = TileEntityDayBarrel.getSlab(null);
    }

    private void markChunkDirty() {
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    public static void populateUpgrades(Set<Upgrade> upgrades, NBTTagCompound compound) {
        if (compound.func_150297_b("upgrades", 9)) {
            NBTTagList upgradeNBT = compound.func_150295_c("upgrades", 8);
            for (int i = 0; i < upgradeNBT.func_74745_c(); ++i) {
                try {
                    Upgrade type = Upgrade.valueOf(upgradeNBT.func_150307_f(i));
                    upgrades.add(type);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        } else if (compound.func_150297_b("type", 8)) {
            String s = compound.func_74779_i("type").toUpperCase();
            Upgrade type = null;
            try {
                type = Upgrade.valueOf(s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (s.equals("CREATIVE")) {
                upgrades.add(Upgrade.HOPPING);
                upgrades.add(Upgrade.INFINITE);
            } else if (type != null) {
                upgrades.add(type);
            }
        } else if (compound.func_74764_b("type")) {
            upgrades.addAll(Arrays.asList(OLD_TYPE_ORDER[compound.func_74771_c("type")]));
        }
    }

    @Override
    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        Orientation oldOrientation = this.orientation;
        this.item = new ItemStack(compound.func_74775_l("item"));
        this.item.func_190920_e(compound.func_74762_e("count"));
        this.orientation = Orientation.getOrientation(compound.func_74771_c("dir"));
        this.helperTop = null;
        this.helperBottom = null;
        this.upgrades.clear();
        TileEntityDayBarrel.populateUpgrades(this.upgrades, compound);
        if (!isClient && compound.func_150297_b("lock", 10)) {
            this.lockable.deserializeNBT(compound.func_74775_l("lock"));
        }
        this.woodLog = TileEntityDayBarrel.getLog(compound);
        this.woodSlab = TileEntityDayBarrel.getSlab(compound);
        this.lastMentionedCount = this.getItemCount();
        if (isClient && this.orientation != oldOrientation) {
            this.markBlockForRenderUpdate();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.woodLogAccess = null;
        this.helperTop = null;
        this.helperBottom = null;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.updateRedstoneLevels = true;
        this.woodLogAccess = new ProxiedBlockAccess((IBlockAccess)this.func_145831_w()){

            @Override
            @Nullable
            public TileEntity func_175625_s(BlockPos pos) {
                return TileEntityDayBarrel.this.func_174877_v().equals((Object)pos) ? null : this.access.func_175625_s(pos);
            }

            @Override
            public IBlockState func_180495_p(BlockPos pos) {
                return TileEntityDayBarrel.this.func_174877_v().equals((Object)pos) ? ItemUtils.getBlockState(TileEntityDayBarrel.this.woodLog.getStack()) : this.access.func_180495_p(pos);
            }

            @Override
            public boolean func_175623_d(BlockPos pos) {
                if (TileEntityDayBarrel.this.func_174877_v().equals((Object)pos)) {
                    IBlockState state = this.func_180495_p(pos);
                    return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
                }
                return this.access.func_175623_d(pos);
            }

            @Override
            public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
                return TileEntityDayBarrel.this.func_174877_v().equals((Object)pos) ? this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side) : this.access.isSideSolid(pos, side, _default);
            }
        };
        if (!this.isEntity) {
            Scheduler.INSTANCE.in(this.func_145831_w(), 1, this::updateComparators);
        }
    }

    public void updateRedstoneLevel() {
        this.redstoneLevel = 0;
        for (EnumFacing d : EnumFacing.field_82609_l) {
            if (this.isTop(d) || this.isTop(d.func_176734_d())) continue;
            this.redstoneLevel = Math.max(this.redstoneLevel, RedstoneUtils.getRedstonePower(this.field_145850_b, this.field_174879_c.func_177972_a(d), d));
        }
    }

    @Override
    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        ItemUtils.writeToNBT(this.item, compound, "item");
        compound.func_74768_a("count", this.item.func_190916_E());
        this.woodLog.writeToNBT(compound, "log");
        this.woodSlab.writeToNBT(compound, "slab");
        compound.func_74774_a("dir", (byte)this.orientation.ordinal());
        NBTTagList upgradeNBT = new NBTTagList();
        for (Upgrade u : this.upgrades) {
            upgradeNBT.func_74742_a((NBTBase)new NBTTagString(u.name()));
        }
        compound.func_74782_a("upgrades", (NBTBase)upgradeNBT);
        if (!isClient) {
            compound.func_74782_a("lock", (NBTBase)this.lockable.serializeNBT());
        }
        return compound;
    }

    public int getLogicSpeed() {
        return 8;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.updateRedstoneLevels) {
            this.updateRedstoneLevel();
            this.updateRedstoneLevels = false;
        }
        if (this.redstoneLevel > 0 || !this.scheduledTick || this.func_145831_w().func_82737_E() % (long)this.getLogicSpeed() != 0L) {
            return;
        }
        this.tick();
    }

    private void onItemChange(boolean typeChanged) {
        this.sync();
        if (!this.isEntity) {
            this.updateComparators();
        }
        this.markChunkDirty();
    }

    void tick() {
        IItemHandler handler;
        if (!this.upgrades.contains((Object)Upgrade.HOPPING) || this.orientation == null) {
            return;
        }
        if (this.notice_target == this && this.field_145850_b.func_175676_y(this.field_174879_c) > 0) {
            return;
        }
        boolean itemChanged = false;
        if (this.helperTop == null) {
            this.helperTop = new CapabilityCache.Single(this.field_145850_b, this.func_174877_v().func_177972_a(this.orientation.top), false, true, true, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.orientation.top.func_176734_d());
            this.helperBottom = new CapabilityCache.Single(this.field_145850_b, this.func_174877_v().func_177972_a(this.orientation.top.func_176734_d()), false, true, true, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.orientation.top);
        }
        if (this.getItemCount() < this.getMaxItemCount() && (handler = this.helperTop.get()) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack got = handler.extractItem(i, 1, true);
                if (!this.insertionView.insertItem(0, got, true).func_190926_b()) continue;
                got = handler.extractItem(i, 1, false);
                this.insertionView.insertItem(0, got, false);
                itemChanged = true;
            }
        }
        if (this.getExtractableItemCount() > 0 && (handler = this.helperBottom.get()) != null) {
            ItemStack toPush = this.item.func_77946_l();
            toPush.func_190920_e(1);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack got = handler.insertItem(i, toPush, false);
                if (!got.func_190926_b()) continue;
                if (!this.upgrades.contains((Object)Upgrade.INFINITE)) {
                    this.item.func_190918_g(1);
                }
                itemChanged = true;
                break;
            }
        }
        if (itemChanged) {
            this.func_70296_d();
        }
    }

    private void needLogic() {
        this.scheduledTick = true;
    }

    public void neighborChanged(BlockPos pos, BlockPos fromPos) {
        if (!this.upgrades.contains((Object)Upgrade.HOPPING)) {
            this.updateRedstoneLevel();
            if (pos.func_177958_n() == fromPos.func_177958_n() && pos.func_177952_p() == fromPos.func_177952_p()) {
                this.needLogic();
            }
        } else if (this.helperTop != null) {
            this.helperTop.neighborChanged(fromPos);
            this.helperBottom.neighborChanged(fromPos);
        }
    }

    @Override
    public int getItemCount() {
        if (this.item.func_190926_b()) {
            return 0;
        }
        if (this.upgrades.contains((Object)Upgrade.INFINITE)) {
            return (this.getMaxStacks() + 1) / 2 * this.item.func_77976_d();
        }
        return this.item.func_190916_E();
    }

    @Override
    public ItemStack extractItem(int maxCount, boolean simulate) {
        return this.extractItem(maxCount, simulate, true);
    }

    @Override
    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        return this.insertItem(stack, simulate, true);
    }

    private ItemStack extractItem(int maxCount, boolean simulate, boolean ignoreMaxStackSize) {
        int amt;
        if (!this.item.func_190926_b() && (amt = Math.min(maxCount, this.getExtractableItemCount())) > 0) {
            ItemStack stack = this.item.func_77946_l();
            stack.func_190920_e(amt);
            if (!simulate && !this.upgrades.contains((Object)Upgrade.INFINITE)) {
                this.item.func_190918_g(amt);
                this.onItemChange(this.item.func_190926_b());
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack insertItem(ItemStack is, boolean simulate, boolean ignoreMaxStackSize) {
        if (is.func_190926_b() || !this.canInsert(is)) {
            return is;
        }
        if (this.upgrades.contains((Object)Upgrade.INFINITE) && !this.item.func_190926_b()) {
            return is;
        }
        int inserted = Math.min(this.getMaxItemCount() - this.item.func_190916_E(), is.func_190916_E());
        if (!simulate) {
            if (this.item.func_190926_b()) {
                this.item = is.func_77946_l();
                this.item.func_190920_e(inserted);
                this.onItemChange(true);
            } else {
                this.item.func_190917_f(inserted);
                this.onItemChange(false);
            }
        }
        if (inserted == is.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        ItemStack leftover = is.func_77946_l();
        leftover.func_190918_g(inserted);
        return leftover;
    }

    public int getExtractableItemCount() {
        if (this.item.func_190926_b()) {
            return 0;
        }
        if (this.upgrades.contains((Object)Upgrade.INFINITE)) {
            return this.item.func_77976_d();
        }
        if (this.upgrades.contains((Object)Upgrade.STICKY)) {
            return Math.min(this.item.func_190916_E() - 1, this.item.func_77976_d());
        }
        return Math.min(this.item.func_190916_E(), this.item.func_77976_d());
    }

    public int getMaxStacks() {
        return 64;
    }

    public int getMaxDropAmount() {
        return CharsetStorageBarrels.maxDroppedStacks * this.item.func_77976_d();
    }

    @Override
    public int getMaxItemCount() {
        if (!this.item.func_190926_b()) {
            return this.item.func_77976_d() * this.getMaxStacks();
        }
        return 64 * this.getMaxStacks();
    }

    @Override
    public boolean containsUpgrade(String upgradeName) {
        return this.upgrades.contains((Object)Upgrade.valueOf(upgradeName));
    }

    public boolean itemMatch(ItemStack is) {
        if (is.func_190926_b() || this.item.func_190926_b()) {
            return false;
        }
        return ItemUtils.canMerge(this.item, is);
    }

    boolean canInsert(ItemStack is) {
        if (is.func_190926_b() || TileEntityDayBarrel.isNested(is)) {
            return false;
        }
        if (this.item.func_190926_b()) {
            return true;
        }
        return ItemUtils.canMerge(this.item, is);
    }

    boolean isTop(EnumFacing d) {
        return this.orientation != null && d == this.orientation.top;
    }

    boolean isTopOrBack(EnumFacing d) {
        return this.orientation != null && (d == this.orientation.top || d == this.orientation.facing.func_176734_d());
    }

    boolean isBottom(EnumFacing d) {
        return this.orientation != null && d == this.orientation.top.func_176734_d();
    }

    boolean isBack(EnumFacing d) {
        return this.orientation != null && d == this.orientation.facing.func_176734_d();
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        RayTraceResult hit = RayTraceUtils.getCollision(this.func_145831_w(), this.func_174877_v(), placer, Block.field_185505_j, 0);
        if (hit != null) {
            if (hit.field_72307_f != null) {
                this.orientation = SpaceUtils.getOrientation(placer, hit.field_178784_b, hit.field_72307_f.func_178788_d(new Vec3d((Vec3i)this.func_174877_v())));
            } else if (hit.field_178784_b != null) {
                this.orientation = Orientation.fromDirection(hit.field_178784_b);
            }
        }
        this.loadFromStack(stack);
        this.needLogic();
    }

    public void loadFromStack(ItemStack is) {
        ItemStack loadItem;
        NBTTagCompound tag;
        int loadCount;
        this.woodLog = TileEntityDayBarrel.getLog(is.func_77978_p());
        this.woodSlab = TileEntityDayBarrel.getSlab(is.func_77978_p());
        this.upgrades.clear();
        if (is.func_77942_o()) {
            TileEntityDayBarrel.populateUpgrades(this.upgrades, is.func_77978_p());
        }
        if (this.upgrades.contains((Object)Upgrade.SILKY) && is.func_77942_o() && (loadCount = (tag = is.func_77978_p()).func_74762_e("SilkCount")) > 0 && !(loadItem = TileEntityDayBarrel.getSilkedItem(is)).func_190926_b()) {
            this.item = loadItem;
            this.item.func_190920_e(loadCount);
        }
    }

    public static ItemStack getSilkedItem(ItemStack is) {
        if (is.func_190926_b() || !is.func_77942_o()) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound tag = is.func_77978_p();
        if (tag.func_74764_b("SilkItem")) {
            return new ItemStack(is.func_77978_p().func_74775_l("SilkItem"));
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isNested(ItemStack is) {
        return !TileEntityDayBarrel.getSilkedItem(is).func_190926_b();
    }

    void updateCountClients() {
        CharsetStorageBarrels.packet.sendToWatching((Packet)new PacketBarrelCountUpdate(this), this);
    }

    protected void onCountUpdate(PacketBarrelCountUpdate packet) {
        this.item.func_190920_e(packet.count);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sync();
        if (this.upgrades.contains((Object)Upgrade.HOPPING)) {
            this.needLogic();
        }
    }

    void sync() {
        int c = this.getItemCount();
        if (c != this.lastMentionedCount) {
            if (this.lastMentionedCount * c <= 0) {
                this.markBlockForUpdate();
            } else {
                this.updateCountClients();
            }
            this.lastMentionedCount = c;
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.isTop(facing) || this.isBottom(facing) || facing == null) {
                return true;
            }
        } else {
            if (capability == Capabilities.BARREL || capability == Capabilities.LOCKABLE) {
                return true;
            }
            if (capability == Capabilities.AXIS_ROTATABLE) {
                return facing != null;
            }
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public boolean shouldExtractFromSide(EnumFacing side) {
        return this.isBottom(side);
    }

    @Override
    public boolean shouldInsertToSide(EnumFacing side) {
        return this.isTop(side);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.shouldExtractFromSide(facing)) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.extractionView);
            }
            if (this.shouldInsertToSide(facing)) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.insertionView);
            }
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.readOnlyView);
            }
        } else {
            if (capability == Capabilities.LOCKABLE) {
                return (T)Capabilities.LOCKABLE.cast((Object)this.lockable);
            }
            if (capability == Capabilities.BARREL) {
                return (T)Capabilities.BARREL.cast((Object)this);
            }
            if (capability == Capabilities.AXIS_ROTATABLE) {
                return (T)Capabilities.AXIS_ROTATABLE.cast((Object)this);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void clear() {
        this.item = ItemStack.field_190927_a;
        this.onItemChange(true);
    }

    public boolean activate(EntityPlayer player, EnumFacing side, EnumHand hand) {
        if (this.lockable.hasLock()) {
            return false;
        }
        Long lastClick = this.lastClickMap.get(player);
        if (lastClick != null && this.field_145850_b.func_82737_E() - lastClick < 10L && !this.item.func_190926_b()) {
            this.addAllItems(player, hand);
            return true;
        }
        this.lastClickMap.put(player, this.field_145850_b.func_82737_E());
        ItemStack held = player.func_184586_b(hand);
        if (held.func_190926_b()) {
            this.info(player);
            return true;
        }
        if (!this.field_145850_b.field_72995_K && TileEntityDayBarrel.isNested(held) && (this.item.func_190926_b() || this.itemMatch(held))) {
            new Notice(this.notice_target, (ITextComponent)new TextComponentTranslation("notice.charset.barrel.no", new Object[0])).sendTo(player);
            return true;
        }
        if (!this.canInsert(held)) {
            this.info(player);
            return true;
        }
        boolean hadNoItem = this.item.func_190926_b();
        int free = this.getMaxItemCount() - this.getItemCount();
        if (free <= 0) {
            this.info(player);
            return true;
        }
        int take = Math.min(free, held.func_190916_E());
        if (take > 0) {
            ItemStack toInsert = held.func_77946_l();
            toInsert.func_190920_e(take);
            ItemStack leftover = this.insertionView.insertItem(0, toInsert, false);
            if ((take -= leftover.func_190916_E()) > 0) {
                held.func_190918_g(take);
                if (hadNoItem) {
                    this.markBlockForUpdate();
                }
            } else {
                this.info(player);
            }
        }
        return true;
    }

    void addAllItems(EntityPlayer entityplayer, EnumHand hand) {
        int free_space;
        ItemStack held = entityplayer.func_184586_b(hand);
        InventoryPlayer inv = entityplayer.field_71071_by;
        int total_delta = 0;
        for (int i = 0; i < inv.func_70302_i_() && (free_space = this.getMaxItemCount() - (this.getItemCount() + total_delta)) > 0; ++i) {
            ItemStack is = inv.func_70301_a(i);
            if (is.func_190926_b() || !this.itemMatch(is)) continue;
            int toAdd = Math.min(is.func_190916_E(), free_space);
            if (is == held && toAdd > 1) {
                --toAdd;
            }
            total_delta += toAdd;
            is.func_190918_g(toAdd);
        }
        if (total_delta > 0) {
            this.item.func_190917_f(total_delta);
            this.onItemChange(false);
            entityplayer.field_71071_by.func_70296_d();
        }
    }

    public void click(EntityPlayer player) {
        if (this.lockable.hasLock()) {
            return;
        }
        EnumHand hand = EnumHand.MAIN_HAND;
        if (this.item.func_190926_b()) {
            this.info(player);
            return;
        }
        ItemStack origHeldItem = player.func_184586_b(hand);
        if (ForgeHooks.canToolHarvestBlock((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)origHeldItem)) {
            return;
        }
        int removeCount = Math.min(this.item.func_77976_d(), this.getItemCount());
        if (removeCount <= 0) {
            return;
        }
        if (player.func_70093_af()) {
            removeCount = 1;
        } else if (removeCount == this.getItemCount() && removeCount > 1) {
            --removeCount;
        }
        BlockPos dropPos = this.func_174877_v();
        RayTraceResult result = RayTraceUtils.getCollision(this.func_145831_w(), this.func_174877_v(), (EntityLivingBase)player, Block.field_185505_j, 0);
        dropPos = result != null && result.field_178784_b != null ? dropPos.func_177972_a(result.field_178784_b) : dropPos.func_177972_a(this.orientation.facing);
        if (this.upgrades.contains((Object)Upgrade.INFINITE)) {
            if (player.func_70093_af()) {
                this.item = ItemStack.field_190927_a;
                this.onItemChange(true);
            } else {
                this.giveOrSpawnItem(player, dropPos, removeCount);
            }
        } else {
            this.giveOrSpawnItem(player, dropPos, removeCount);
            this.item.func_190918_g(removeCount);
            this.onItemChange(false);
        }
    }

    protected void giveOrSpawnItem(EntityPlayer player, BlockPos dropPos, int removeCount) {
        ItemUtils.giveOrSpawnItemEntity(player, this.field_145850_b, new Vec3d((Vec3i)dropPos).func_72441_c(0.5, 0.5, 0.5), this.makeStack(removeCount), 0.2f, 0.2f, 0.2f, 1.0f);
    }

    void info(EntityPlayer entityplayer) {
        new Notice(this.notice_target, msg -> {
            if (this.item.func_190926_b()) {
                msg.setMessage((ITextComponent)new TextComponentTranslation("notice.charset.barrel.empty", new Object[0]));
            } else {
                int count;
                String countMsg = this.upgrades.contains((Object)Upgrade.INFINITE) ? "notice.charset.barrel.infinite" : ((count = this.getItemCount()) >= this.getMaxItemCount() ? "notice.charset.barrel.full" : "" + count);
                msg.withItem(this.item).setMessage((ITextComponent)new TextComponentTranslation("%1$s %2$s", new Object[]{new TextComponentTranslation(countMsg, new Object[0]), new TextComponentString("{ITEM_NAME}{ITEM_INFOS}")}));
            }
        }).sendTo(entityplayer);
    }

    private ItemStack makeStack(int count) {
        if (this.item.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = this.item.func_77946_l();
        ret.func_190920_e(count);
        assert (ret.func_190916_E() > 0 && ret.func_190916_E() <= this.item.func_77976_d());
        return ret;
    }

    @Override
    public int getComparatorValue() {
        int count = this.getItemCount();
        if (count <= 0) {
            return 0;
        }
        int max = this.getMaxItemCount();
        if (count >= max) {
            return 15;
        }
        float v = (float)count / (float)max;
        return (int)Math.max(1.0, Math.floor(v * 15.0f));
    }

    public List<ItemStack> getContentDrops(boolean silkTouch) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.upgrades.contains((Object)Upgrade.INFINITE) || this.upgrades.contains((Object)Upgrade.SILKY) && silkTouch) {
            return stacks;
        }
        if (this.item.func_190926_b()) {
            return stacks;
        }
        int count = Math.min(this.getItemCount(), this.getMaxDropAmount());
        if (count <= 0) {
            return stacks;
        }
        int prev_count = 0;
        while (prev_count != count && count > 0) {
            int toDrop = Math.min(this.item.func_77976_d(), count);
            ItemStack dropStack = this.item.func_77946_l();
            dropStack.func_190920_e(toDrop);
            stacks.add(dropStack);
            prev_count = count;
            count -= toDrop;
        }
        return stacks;
    }

    public List<ItemStack> getDrops(boolean silkTouch) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(this.getDroppedBlock(silkTouch));
        stacks.addAll(this.getContentDrops(silkTouch));
        return stacks;
    }

    public boolean canLose() {
        return !this.item.func_190926_b() && !this.upgrades.contains((Object)Upgrade.INFINITE) && this.getItemCount() > this.getMaxDropAmount();
    }

    public static ItemStack makeDefaultBarrel(Set<Upgrade> upgrades) {
        return TileEntityDayBarrel.makeBarrel(upgrades, ItemMaterialRegistry.INSTANCE.getDefaultMaterialByType("log"), ItemMaterialRegistry.INSTANCE.getDefaultMaterialByType("slab"));
    }

    public static ItemStack makeBarrel(Set<Upgrade> upgrades, ItemMaterial log, ItemMaterial slab) {
        ItemStack stack = new ItemStack((Item)CharsetStorageBarrels.barrelItem);
        NBTTagCompound compound = ItemUtils.getTagCompound(stack, true);
        compound.func_74778_a("log", log.getId());
        compound.func_74778_a("slab", slab.getId());
        if (upgrades.size() > 0) {
            NBTTagList list = new NBTTagList();
            for (Upgrade u : upgrades) {
                list.func_74742_a((NBTBase)new NBTTagString(u.name()));
            }
            compound.func_74782_a("upgrades", (NBTBase)list);
        }
        return stack;
    }

    public static ItemMaterial getLog(NBTTagCompound tag) {
        return ItemMaterialRegistry.INSTANCE.getMaterial(tag, "log", "log");
    }

    public static ItemMaterial getSlab(NBTTagCompound tag) {
        return ItemMaterialRegistry.INSTANCE.getMaterial(tag, "slab", "slab");
    }

    static ItemStack addUpgrade(ItemStack barrel, Upgrade upgrade) {
        NBTTagList list;
        NBTTagCompound tag = ItemUtils.getTagCompound(barrel, true);
        if (!tag.func_74764_b("upgrades")) {
            list = new NBTTagList();
        } else {
            list = tag.func_150295_c("upgrades", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                if (!list.func_150307_f(i).equals(upgrade.name())) continue;
                return barrel;
            }
        }
        list.func_74742_a((NBTBase)new NBTTagString(upgrade.name()));
        if (list.func_74745_c() > 0) {
            tag.func_74782_a("upgrades", (NBTBase)list);
        }
        return barrel;
    }

    private boolean changeOrientation(Orientation newOrientation, boolean simulate) {
        if (this.orientation != newOrientation) {
            if (!simulate) {
                this.orientation = newOrientation;
                this.helperTop = null;
                this.helperBottom = null;
                this.markBlockForUpdate();
                this.func_145831_w().func_175722_b(this.field_174879_c, this.func_145838_q(), true);
            }
            return true;
        }
        return false;
    }

    public void func_189668_a(Mirror mirror) {
        this.changeOrientation(this.orientation.mirror(mirror), false);
    }

    @Override
    public boolean rotateAround(EnumFacing axis, boolean simulate) {
        return this.changeOrientation(this.orientation.rotateAround(axis), simulate);
    }

    public void rotateWrench(EnumFacing axis) {
        Orientation newOrientation = axis == this.orientation.facing.func_176734_d() ? this.orientation.getNextRotationOnFace() : Orientation.getOrientation(Orientation.fromDirection(axis.func_176734_d()).ordinal() & 0xFFFFFFFC | this.orientation.ordinal() & 3);
        this.changeOrientation(newOrientation, false);
    }

    @Override
    public ItemStack getDroppedBlock(IBlockState state) {
        return this.getDroppedBlock(false);
    }

    public ItemStack getDroppedBlock(boolean silkTouch) {
        ItemStack is = TileEntityDayBarrel.makeBarrel(this.upgrades, this.woodLog, this.woodSlab);
        if (this.upgrades.contains((Object)Upgrade.SILKY) && !this.item.func_190926_b() && silkTouch) {
            NBTTagCompound tag = is.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                is.func_77982_d(tag);
            }
            tag.func_74768_a("SilkCount", this.getItemCount());
            NBTTagCompound si = new NBTTagCompound();
            this.item.func_77955_b(si);
            tag.func_74782_a("SilkItem", (NBTBase)si);
        }
        return is;
    }

    public boolean canHarvest(EntityPlayer player) {
        if (this.item.func_190926_b()) {
            return true;
        }
        if (player == null || !player.func_184812_l_()) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            player.func_184609_a(EnumHand.MAIN_HAND);
        } else {
            this.click(player);
        }
        return false;
    }

    public boolean isWooden() {
        try {
            return this.woodLog.getTypes().contains("wood");
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getFlamability(EnumFacing face) {
        try {
            return ItemUtils.getBlockState(this.woodLog.getStack()).func_177230_c().getFlammability((IBlockAccess)this.woodLogAccess, this.func_174877_v(), face);
        }
        catch (Exception e) {
            return this.isWooden() ? 20 : 0;
        }
    }

    public boolean isFlammable(EnumFacing face) {
        try {
            return ItemUtils.getBlockState(this.woodLog.getStack()).func_177230_c().isFlammable((IBlockAccess)this.woodLogAccess, this.func_174877_v(), face);
        }
        catch (Exception e) {
            return this.isWooden();
        }
    }

    public int getFireSpreadSpeed(EnumFacing face) {
        try {
            return ItemUtils.getBlockState(this.woodLog.getStack()).func_177230_c().getFireSpreadSpeed((IBlockAccess)this.woodLogAccess, this.func_174877_v(), face);
        }
        catch (Exception e) {
            return this.isWooden() ? 5 : 0;
        }
    }

    public SoundType getSoundType() {
        try {
            if (this.isTop(EnumFacing.UP) || this.isBottom(EnumFacing.UP)) {
                return ItemUtils.getBlockState(this.woodSlab.getStack()).func_177230_c().func_185467_w();
            }
            return ItemUtils.getBlockState(this.woodLog.getStack()).func_177230_c().func_185467_w();
        }
        catch (Exception e) {
            return SoundType.field_185848_a;
        }
    }

    public static enum Upgrade {
        SILKY,
        HOPPING,
        STICKY,
        INFINITE;

        public static final Upgrade[] VALUES;

        static {
            VALUES = Upgrade.values();
        }
    }

    public class ExtractionHandler
    extends BaseItemHandler {
        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return TileEntityDayBarrel.this.extractItem(amount, simulate, false);
        }
    }

    public class ReadableItemHandler
    extends BaseItemHandler {
        @Override
        public ItemStack getStackInSlot(int slot) {
            if (TileEntityDayBarrel.this.item.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            int count = TileEntityDayBarrel.this.item.func_190916_E() - slot * TileEntityDayBarrel.this.item.func_77976_d();
            if (count <= 0) {
                return ItemStack.field_190927_a;
            }
            if (count > 64) {
                count = 64;
            }
            ItemStack stack = TileEntityDayBarrel.this.item.func_77946_l();
            stack.func_190920_e(count);
            return stack;
        }

        @Override
        public int getSlots() {
            return TileEntityDayBarrel.this.getMaxStacks();
        }

        @Override
        public int getSlotLimit(int slot) {
            return !TileEntityDayBarrel.this.item.func_190926_b() ? TileEntityDayBarrel.this.item.func_77976_d() : 64;
        }
    }

    public class InsertionHandler
    extends BaseItemHandler {
        @Override
        public ItemStack insertItem(int slot, ItemStack is, boolean simulate) {
            return TileEntityDayBarrel.this.insertItem(is, simulate, false);
        }
    }

    public abstract class BaseItemHandler
    implements ICacheable,
    IItemHandler {
        public ItemStack getStackInSlot(int slot) {
            ItemStack stack = TileEntityDayBarrel.this.item;
            if (stack.func_190916_E() > 64) {
                stack = stack.func_77946_l();
                stack.func_190920_e(64);
            }
            return stack;
        }

        public int getSlots() {
            return 1;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        @Override
        public boolean isCacheValid() {
            return TileEntityDayBarrel.this.isCacheValid();
        }
    }
}

