/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.locks;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.CharsetLib;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.ui.GuiHandlerCharset;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.module.storage.locks.ContainerKeyring;
import pl.asie.charset.module.storage.locks.EntityLock;
import pl.asie.charset.module.storage.locks.GuiKeyring;
import pl.asie.charset.module.storage.locks.ItemKey;
import pl.asie.charset.module.storage.locks.ItemKeyring;
import pl.asie.charset.module.storage.locks.ItemLock;
import pl.asie.charset.module.storage.locks.ItemLockingDyeable;
import pl.asie.charset.module.storage.locks.ItemMasterKey;
import pl.asie.charset.module.storage.locks.LockEventHandler;
import pl.asie.charset.module.storage.locks.RenderLock;

@CharsetModule(name="storage.locks", description="Player interaction-preventing locks and keys", profile=ModuleProfile.TESTING)
public class CharsetStorageLocks {
    @CharsetModule.Instance
    public static CharsetStorageLocks instance;
    @CharsetModule.Configuration
    public static Configuration config;
    public static final int DEFAULT_LOCKING_COLOR = 16505706;
    public static ItemMasterKey masterKeyItem;
    public static ItemKey keyItem;
    public static ItemKeyring keyringItem;
    public static ItemLock lockItem;
    public static boolean enableKeyKeepInventory;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        masterKeyItem = new ItemMasterKey();
        keyItem = new ItemKey();
        keyringItem = new ItemKeyring();
        lockItem = new ItemLock();
        enableKeyKeepInventory = config.getBoolean("keepKeysOnDeath", "locks", true, "Should keys be kept in inventory on death?");
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        RegistryUtils.registerModel(masterKeyItem, 0, "charset:masterKey");
        RegistryUtils.registerModel(keyItem, 0, "charset:key");
        RegistryUtils.registerModel(lockItem, 0, "charset:lock");
        RegistryUtils.registerModel(keyringItem, 0, "charset:keyring");
        for (int i = 1; i <= 8; ++i) {
            RegistryUtils.registerModel(keyringItem, i, "charset:keyring#inventory_" + i);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        RegistryUtils.register(event.getRegistry(), masterKeyItem, "masterKey");
        RegistryUtils.register(event.getRegistry(), keyItem, "key");
        RegistryUtils.register(event.getRegistry(), keyringItem, "keyring");
        RegistryUtils.register(event.getRegistry(), lockItem, "lock");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        RegistryUtils.register(EntityLock.class, "lock", 64, 3, false);
        MinecraftForge.EVENT_BUS.register((Object)new LockEventHandler());
        if (enableKeyKeepInventory) {
            CharsetLib.deathHandler.addPredicate(new Predicate<ItemStack>(){

                public boolean apply(@Nullable ItemStack input) {
                    return input != null && input.func_77973_b() instanceof ItemKey;
                }
            });
        }
        GuiHandlerCharset.INSTANCE.register(257, Side.SERVER, r -> new ContainerKeyring(r.player.field_71071_by));
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityLock.class, manager -> new RenderLock(manager));
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemLockingDyeable.Color(), new Item[]{keyItem});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemLockingDyeable.Color(), new Item[]{lockItem});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemKeyring.Color(), new Item[]{keyringItem});
        GuiHandlerCharset.INSTANCE.register(257, Side.CLIENT, r -> new GuiKeyring(new ContainerKeyring(r.player.field_71071_by)));
    }
}

