/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.locks;

import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import pl.asie.charset.api.locks.ILockingEntity;
import pl.asie.charset.api.locks.Lockable;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.module.storage.locks.CharsetStorageLocks;
import pl.asie.charset.module.storage.locks.ItemLock;
import pl.asie.charset.module.storage.locks.LockEventHandler;

public class EntityLock
extends EntityHanging
implements IEntityAdditionalSpawnData,
ILockingEntity {
    static final DataParameter<Integer> COLOR_0 = EntityDataManager.func_187226_a(EntityLock.class, (DataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Integer> COLOR_1 = EntityDataManager.func_187226_a(EntityLock.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<EnumFacing> HANGING_ROTATION = EntityDataManager.func_187226_a(EntityLock.class, (DataSerializer)DataSerializers.field_187202_l);
    private static final Predicate<Entity> IS_HANGING_ENTITY = new Predicate<Entity>(){

        public boolean apply(Entity entity) {
            return entity instanceof EntityHanging;
        }
    };
    private String lockKey = null;
    protected int color = -1;
    private TileEntity tileCached;
    private boolean locked = true;

    public EntityLock(World worldIn) {
        super(worldIn);
    }

    public EntityLock(World worldIn, ItemStack stack, BlockPos pos, EnumFacing facing) {
        super(worldIn, pos);
        this.setColors(stack.func_77978_p());
        this.setLockKey(((ItemLock)stack.func_77973_b()).getRawKey(stack));
        this.func_174859_a(facing);
    }

    private void setColors(NBTTagCompound compound) {
        this.color = compound != null ? (compound.func_74764_b("color") ? compound.func_74762_e("color") : -1) : -1;
    }

    private void setLockKey(String s) {
        this.lockKey = s;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setLockKey(compound.func_74764_b("key") ? compound.func_74779_i("key") : null);
        this.setColors(compound);
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return I18n.func_74838_a((String)"item.charset.lock.name");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.lockKey != null) {
            compound.func_74778_a("key", this.lockKey);
        }
        if (this.color != -1) {
            compound.func_74768_a("color1", this.color);
        }
    }

    public Lockable getAttachedLock() {
        TileEntity tile = this.getAttachedTile();
        if (tile != null && tile.hasCapability(Capabilities.LOCKABLE, null)) {
            Lockable lock = (Lockable)tile.getCapability(Capabilities.LOCKABLE, null);
            if (!lock.hasLock() && LockEventHandler.getLock(tile) == null) {
                lock.addLock(this);
            }
            return lock.getLock() == this ? lock : null;
        }
        return null;
    }

    public BlockPos getAttachmentPos() {
        return this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d());
    }

    public TileEntity getAttachedTile() {
        if (this.tileCached == null || this.tileCached.func_145837_r()) {
            BlockPos pos = this.getAttachmentPos();
            this.tileCached = this.field_70170_p.func_175625_s(pos);
        }
        return this.tileCached;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184224_h(true);
    }

    public boolean func_85031_j(Entity entityIn) {
        if (entityIn instanceof EntityPlayer && entityIn.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K) {
                if (LockEventHandler.unlockOrRaiseError((EntityPlayer)entityIn, this.getAttachedTile(), this.getAttachedLock()) && !this.field_70128_L) {
                    this.func_70106_y();
                    this.func_110128_b(entityIn);
                }
                return true;
            }
            return super.func_85031_j(entityIn);
        }
        return super.func_85031_j(entityIn);
    }

    public void func_70071_h_() {
        ILockableContainer container;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.getAttachedTile() instanceof ILockableContainer && (container = (ILockableContainer)this.tileCached).func_174893_q_() && container.func_174891_i().func_180159_b().startsWith("charset")) {
            container.func_174892_a(LockCode.field_180162_a);
        }
        if (!this.field_70170_p.field_72995_K && this.lockKey != null && this.getAttachedLock() == null) {
            this.drop();
        }
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND && this.lockKey != null && this.getAttachedLock() != null) {
            boolean canUnlock = LockEventHandler.unlockOrRaiseError(player, this.getAttachedTile(), this.getAttachedLock());
            if (canUnlock) {
                Lockable lock = this.getAttachedLock();
                if (lock != null) {
                    this.locked = false;
                    BlockPos pos = this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d());
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    state.func_177230_c().func_180639_a(this.field_70170_p, pos, state, player, hand, this.field_174860_b, 0.5f + (float)this.field_174860_b.func_82601_c() * 0.5f, 0.5f + (float)this.field_174860_b.func_96559_d() * 0.5f, 0.5f + (float)this.field_174860_b.func_82599_e() * 0.5f);
                    this.locked = true;
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.SUCCESS;
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public boolean func_70518_d() {
        if (this.getAttachedLock() == null) {
            return false;
        }
        if (!this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
            return false;
        }
        return this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), IS_HANGING_ENTITY).isEmpty();
    }

    public int func_82329_d() {
        return 8;
    }

    public int func_82330_g() {
        return 8;
    }

    private ItemStack createItemStack(Item item) {
        ItemStack lock = new ItemStack(item);
        lock.func_77982_d(new NBTTagCompound());
        if (this.lockKey != null) {
            lock.func_77978_p().func_74778_a("key", this.lockKey);
        }
        if (this.color != -1) {
            lock.func_77978_p().func_74768_a("color", this.color);
        }
        return lock;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.createItemStack(CharsetStorageLocks.keyItem);
    }

    public void drop() {
        Lockable lock = this.getAttachedLock();
        if (lock != null) {
            lock.removeLock(this);
        }
        this.func_70099_a(this.createItemStack(CharsetStorageLocks.lockItem), 0.0f);
        this.func_70106_y();
    }

    public void func_110128_b(Entity brokenEntity) {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187701_j, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.drop();
    }

    public void func_184523_o() {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187707_l, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeByte(this.field_174860_b.ordinal());
        buffer.writeInt(this.color);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.func_174859_a(EnumFacing.func_82600_a((int)buffer.readUnsignedByte()));
        this.color = buffer.readInt();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean isLockValid(TileEntity tile) {
        if (!this.func_70089_S()) {
            return false;
        }
        if (tile == null) {
            return true;
        }
        return this.getAttachedTile().func_174877_v().equals((Object)tile.func_174877_v());
    }

    @Override
    public int getLockEntityId() {
        return this.func_145782_y();
    }

    @Override
    public String getLockKey() {
        return this.lockKey;
    }
}

