/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tools.building;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.ui.GuiHandlerCharset;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.module.tools.building.ToolItemColor;
import pl.asie.charset.module.tools.building.chisel.ChiselBakedModel;
import pl.asie.charset.module.tools.building.chisel.ContainerChisel;
import pl.asie.charset.module.tools.building.chisel.GuiChisel;
import pl.asie.charset.module.tools.building.chisel.ItemChisel;
import pl.asie.charset.module.tools.building.chisel.PacketSetBlockMask;
import pl.asie.charset.module.tools.building.trowel.ItemTrowel;
import pl.asie.charset.module.tools.building.wrench.ICustomRotateBlock;

@CharsetModule(name="tools.building", description="Building tools: chisel.", profile=ModuleProfile.UNSTABLE)
public class CharsetToolsBuilding {
    private static Map<Block, ICustomRotateBlock> customRotationHandlers = new HashMap<Block, ICustomRotateBlock>();
    public static ItemChisel chisel;
    public static ItemTrowel trowel;
    @CharsetModule.PacketRegistry(value="toolsBldng")
    public static PacketRegistry packet;

    public static ICustomRotateBlock getRotationHandler(Block block) {
        return customRotationHandlers.get(block);
    }

    public static void registerRotationHandler(Block block, ICustomRotateBlock rotateBlock) {
        if (customRotationHandlers.containsKey(block)) {
            throw new RuntimeException("Duplicate rotation handlers for " + block.getRegistryName() + "! " + rotateBlock.getClass().getName() + ", " + customRotationHandlers.get(block).getClass().getName());
        }
        customRotationHandlers.put(block, rotateBlock);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        chisel = new ItemChisel();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packet.registerPacket(1, PacketSetBlockMask.class);
        GuiHandlerCharset.INSTANCE.register(258, Side.SERVER, r -> new ContainerChisel(r.player));
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)ToolItemColor.INSTANCE, new Item[]{chisel});
        GuiHandlerCharset.INSTANCE.register(258, Side.CLIENT, r -> new GuiChisel(new ContainerChisel(r.player)));
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        RegistryUtils.registerModel(chisel, 0, "charset:chisel");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void bakeModels(ModelBakeEvent event) {
        ModelResourceLocation location = new ModelResourceLocation("charset:chisel", "inventory");
        IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)location);
        if (model != null) {
            event.getModelRegistry().func_82595_a((Object)location, (Object)new ChiselBakedModel(model));
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        RegistryUtils.register(event.getRegistry(), chisel, "chisel");
    }
}

