/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tools.building.chisel;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.lib.render.model.BaseBakedModel;
import pl.asie.charset.lib.render.model.ModelFactory;
import pl.asie.charset.module.tools.building.CharsetToolsBuilding;

public class ChiselBakedModel
extends BaseBakedModel {
    private final Cache<Integer, IBakedModel> cache;
    private final TextureAtlasSprite sprite;
    private final IBakedModel parent;
    private final ItemOverrideList list;
    private final List<BakedQuad> quads;

    private BakedQuad buildQuad(EnumFacing side, TextureAtlasSprite sprite, float x, float y, float w, float h, float z, float colorMultiplier) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        if (side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
            this.buildVertex(builder, side, x / 16.0f, y / 16.0f, z / 16.0f, sprite, colorMultiplier);
            this.buildVertex(builder, side, (x + w) / 16.0f, y / 16.0f, z / 16.0f, sprite, colorMultiplier);
            this.buildVertex(builder, side, (x + w) / 16.0f, (y + h) / 16.0f, z / 16.0f, sprite, colorMultiplier);
            this.buildVertex(builder, side, x / 16.0f, (y + h) / 16.0f, z / 16.0f, sprite, colorMultiplier);
        } else {
            this.buildVertex(builder, side, x / 16.0f, y / 16.0f, z / 16.0f, sprite, colorMultiplier);
            this.buildVertex(builder, side, x / 16.0f, (y + h) / 16.0f, z / 16.0f, sprite, colorMultiplier);
            this.buildVertex(builder, side, (x + w) / 16.0f, (y + h) / 16.0f, z / 16.0f, sprite, colorMultiplier);
            this.buildVertex(builder, side, (x + w) / 16.0f, y / 16.0f, z / 16.0f, sprite, colorMultiplier);
        }
        return builder.build();
    }

    private void buildVertex(UnpackedBakedQuad.Builder builder, EnumFacing side, float x, float y, float z, TextureAtlasSprite sprite, float colorMultiplier) {
        VertexFormat format = builder.getVertexFormat();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            VertexFormatElement element = format.func_177348_c(e);
            switch (element.func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{x, 1.0f - y, z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{colorMultiplier, colorMultiplier, colorMultiplier, 1.0f});
                    continue block6;
                }
                case UV: {
                    builder.put(e, new float[]{sprite.func_94214_a((double)(x * 16.0f)), sprite.func_94207_b((double)(y * 16.0f)), 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public ChiselBakedModel(final IBakedModel parent) {
        this.parent = parent;
        this.sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("charset:items/chisel_pattern");
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        this.list = new ItemOverrideList(Collections.emptyList()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                int mask = CharsetToolsBuilding.chisel.getBlockMask(stack);
                if (ModelFactory.DISABLE_CACHE) {
                    return new ChiselBakedModel(parent, ChiselBakedModel.this.sprite, (Cache<Integer, IBakedModel>)ChiselBakedModel.this.cache, mask);
                }
                IBakedModel model = (IBakedModel)ChiselBakedModel.this.cache.getIfPresent((Object)mask);
                if (model == null) {
                    model = new ChiselBakedModel(parent, ChiselBakedModel.this.sprite, (Cache<Integer, IBakedModel>)ChiselBakedModel.this.cache, mask);
                    ChiselBakedModel.this.cache.put((Object)mask, (Object)model);
                }
                return model;
            }
        };
        this.quads = null;
    }

    public ChiselBakedModel(IBakedModel parent, TextureAtlasSprite sprite, Cache<Integer, IBakedModel> cache, int mask) {
        this.parent = parent;
        this.sprite = sprite;
        this.cache = cache;
        this.list = ItemOverrideList.field_188022_a;
        List quads = parent.func_188616_a(null, null, 0L);
        if (mask != 511) {
            ImmutableList.Builder quads2 = ImmutableList.builder();
            quads2.addAll((Iterable)quads);
            int blockMask = mask;
            block0: for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    if ((blockMask & 1 << y * 3 + x) != 0) continue;
                    int width = 1;
                    int height = 1;
                    blockMask |= 1 << y * 3 + x;
                    for (int x0 = x + 1; x0 < 3 && (blockMask & 1 << y * 3 + x0) == 0; ++x0) {
                        blockMask |= 1 << y * 3 + x0;
                        ++width;
                    }
                    for (int y0 = y + 1; y0 < 3; ++y0) {
                        int x0;
                        boolean match = true;
                        for (x0 = x; x0 < x + width; ++x0) {
                            if ((blockMask & 1 << y0 * 3 + x0) == 0) continue;
                            match = false;
                            break;
                        }
                        if (!match) break;
                        for (x0 = x; x0 < x + width; ++x0) {
                            blockMask |= 1 << y0 * 3 + x0;
                        }
                        ++height;
                    }
                    quads2.add((Object)this.buildQuad(EnumFacing.NORTH, sprite, 4 + x, 9 + y, width, height, 7.49f, 0.6f));
                    quads2.add((Object)this.buildQuad(EnumFacing.SOUTH, sprite, 4 + x, 9 + y, width, height, 8.51f, 0.6f));
                    if (blockMask == 511) break block0;
                }
            }
            this.quads = quads2.build();
        } else {
            this.quads = quads;
        }
    }

    @Override
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Pair parentPair = this.parent.handlePerspective(cameraTransformType);
        return ImmutablePair.of((Object)this, (Object)parentPair.getRight());
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return side == null ? this.quads : ImmutableList.of();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return this.list;
    }
}

