/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.transport.carts;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.utils.ItemUtils;

public class TrackCombiner {
    private final Map<IBlockState, Map<ItemStack, IBlockState>> transform = new HashMap<IBlockState, Map<ItemStack, IBlockState>>();
    private final Map<IBlockState, Pair<ItemStack, IBlockState>> transformInv = new HashMap<IBlockState, Pair<ItemStack, IBlockState>>();

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        IBlockState state;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (event.getEntityPlayer().func_70093_af() && !event.getItemStack().func_190926_b() && this.transform.containsKey(state = world.func_180495_p(pos))) {
            for (Map.Entry<ItemStack, IBlockState> entry : this.transform.get(state).entrySet()) {
                if (!ItemUtils.canMerge(entry.getKey(), event.getItemStack())) continue;
                world.func_175656_a(pos, entry.getValue());
                event.getItemStack().func_190918_g(1);
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.getState() == null) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (event.getDrops() == null) {
            ModCharset.logger.error("Block " + event.getState().func_177230_c().getRegistryName() + " provides a null getDrops() list, against Forge's original method behaviour! This is a bug in the mod providing it!");
            return;
        }
        IBlockState state = event.getState();
        if (this.transformInv.containsKey(state)) {
            event.getDrops().clear();
            IBlockState oldState = world.func_180495_p(pos);
            world.func_180501_a(pos, state, 4);
            while (this.transformInv.containsKey(state)) {
                Pair<ItemStack, IBlockState> pair = this.transformInv.get(state);
                event.getDrops().add(((ItemStack)pair.getLeft()).func_77946_l());
                state = (IBlockState)pair.getRight();
                world.func_180501_a(pos, state, 4);
            }
            event.getDrops().addAll(state.func_177230_c().getDrops((IBlockAccess)world, pos, state, event.getFortuneLevel()));
            world.func_180501_a(pos, oldState, 2);
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        IBlockState state;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (event.getEntityPlayer().func_70093_af() && this.transformInv.containsKey(state = world.func_180495_p(pos))) {
            Pair<ItemStack, IBlockState> pair = this.transformInv.get(state);
            if (!world.field_72995_K) {
                ItemUtils.spawnItemEntity(world, new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.125, 0.5), ((ItemStack)pair.getLeft()).func_77946_l(), 0.02f, 0.05f, 0.02f, 1.0f);
            }
            world.func_175656_a(pos, (IBlockState)pair.getRight());
            event.setCanceled(true);
        }
    }

    public void register(IBlockState from, IBlockState to, ItemStack with) {
        if (this.transformInv.containsKey(to)) {
            throw new RuntimeException("Tried to register two mappings resulting in " + to.toString() + " in TrackCombiner!");
        }
        this.transformInv.put(to, (Pair<ItemStack, IBlockState>)Pair.of((Object)with, (Object)from));
        if (!this.transform.containsKey(from)) {
            this.transform.put(from, new HashMap());
        }
        this.transform.get(from).put(with, to);
    }

    public void register(Block from, IBlockState to, ItemStack with) {
        if (this.transformInv.containsKey(to)) {
            throw new RuntimeException("Tried to register two mappings resulting in " + to.toString() + " in TrackCombiner!");
        }
        this.transformInv.put(to, (Pair<ItemStack, IBlockState>)Pair.of((Object)with, (Object)from.func_176223_P()));
        for (IBlockState fromState : from.func_176194_O().func_177619_a()) {
            if (!this.transform.containsKey(from)) {
                this.transform.put(fromState, new HashMap());
            }
            this.transform.get(fromState).put(with, to);
        }
    }
}

