/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.transport.carts.link;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.lib.capability.CapabilityProviderFactory;
import pl.asie.charset.lib.utils.FunctionalUtils;
import pl.asie.charset.module.transport.carts.CharsetTransportCarts;

public final class Linkable {
    public static final Storage STORAGE = new Storage();
    public static final Supplier<CapabilityProviderFactory<Linkable>> PROVIDER = FunctionalUtils.lazySupplier(() -> new CapabilityProviderFactory<Linkable>(CharsetTransportCarts.LINKABLE, STORAGE));
    public static final ResourceLocation ID = new ResourceLocation("charsetcarts", "linkable");
    public Linkable previous;
    public Linkable next;
    private final Entity owner;

    public Linkable(Entity owner) {
        this.owner = owner;
    }

    public Entity getOwner() {
        return this.owner;
    }

    public UUID getId() {
        return this.owner.getPersistentID();
    }

    public static class Storage
    implements Capability.IStorage<Linkable> {
        public NBTBase writeNBT(Capability<Linkable> capability, Linkable instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            if (instance.previous != null) {
                compound.func_186854_a("prev", instance.previous.getId());
            }
            if (instance.next != null) {
                compound.func_186854_a("next", instance.next.getId());
            }
            return compound;
        }

        public void readNBT(Capability<Linkable> capability, Linkable instance, EnumFacing side, NBTBase nbt) {
            instance.previous = null;
            instance.next = null;
            if (nbt instanceof NBTTagCompound) {
                Linkable next;
                Linkable prev;
                NBTTagCompound compound = (NBTTagCompound)nbt;
                if (compound.func_74764_b("prev") && (prev = CharsetTransportCarts.linker.get(compound.func_186857_a("prev"))) != null) {
                    CharsetTransportCarts.linker.link(prev, instance);
                }
                if (compound.func_74764_b("next") && (next = CharsetTransportCarts.linker.get(compound.func_186857_a("next"))) != null) {
                    CharsetTransportCarts.linker.link(instance, next);
                }
            }
        }
    }
}

