/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.transport.carts.link;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import pl.asie.charset.module.transport.carts.link.Linkable;

public class TrainLinker {
    private final BiMap<UUID, Linkable> linkableMap = HashBiMap.create();

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityMinecart) {
            Linkable link = new Linkable((Entity)event.getObject());
            event.addCapability(Linkable.ID, Linkable.PROVIDER.get().create(link));
            this.linkableMap.put((Object)link.getId(), (Object)link);
        }
    }

    private double getDistanceXZ(Entity one, Entity two) {
        double a = one.field_70165_t - two.field_70165_t;
        double b = one.field_70161_v - two.field_70161_v;
        return a * a + b * b;
    }

    @SubscribeEvent
    public void onWorldTickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Linkable link : this.linkableMap.values()) {
                if (link.previous != null || link.next == null) continue;
                ArrayList<Linkable> linked = new ArrayList<Linkable>();
                Entity front = link.getOwner();
                linked.add(link);
                while (link.next != null) {
                    link = link.next;
                    linked.add(link);
                }
            }
        }
    }

    public Linkable get(Entity entity) {
        return this.get(entity.getPersistentID());
    }

    public Linkable get(UUID id) {
        Linkable link = (Linkable)this.linkableMap.get((Object)id);
        if (link.getOwner().field_70128_L) {
            if (link.previous != null) {
                this.unlink(link, link.previous);
            }
            if (link.next != null) {
                this.unlink(link, link.next);
            }
            this.linkableMap.remove((Object)id);
            return null;
        }
        return link;
    }

    public void link(Linkable first, Linkable second) {
        first.next = second;
        second.previous = first;
    }

    public boolean unlink(Linkable first, Linkable second) {
        if (first.previous == second) {
            first.previous = null;
            second.next = null;
            return true;
        }
        if (first.next == second) {
            first.next = null;
            second.previous = null;
            return true;
        }
        return false;
    }
}

