/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.transport.color;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderMinecart;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.resources.CharsetFakeResourcePack;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.module.transport.color.MinecartDyeable;
import pl.asie.charset.module.transport.color.ModelMinecartWrapped;
import pl.asie.charset.module.transport.color.PacketMinecartRequest;
import pl.asie.charset.module.transport.color.PacketMinecartUpdate;

@CharsetModule(name="transport.dyeableMinecarts", description="Use dyes on Minecarts to make them colorful", profile=ModuleProfile.STABLE)
public class CharsetTransportDyeableMinecarts {
    @CharsetModule.PacketRegistry(value="dyeMinecarts")
    public static PacketRegistry packet;
    @CapabilityInject(value=MinecartDyeable.class)
    public static Capability<MinecartDyeable> MINECART_DYEABLE;
    public static ResourceLocation MINECART_DYEABLE_KEY;

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        CharsetFakeResourcePack.INSTANCE.registerEntry(ModelMinecartWrapped.DYEABLE_MINECART, stream -> {
            try {
                int i;
                int rgb;
                int x;
                BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(ModelMinecartWrapped.MINECART).func_110527_b());
                float scale = (float)image.getWidth() / 64.0f;
                int maxValue = 0;
                int y = 0;
                while ((float)y < 28.0f * scale) {
                    x = 0;
                    while ((float)x < 44.0f * scale) {
                        rgb = image.getRGB(x, y);
                        if ((rgb >> 24 & 0xFF) != 0) {
                            i = 0;
                            while (i < 3 && ((rgb & 0xFF) <= maxValue || (maxValue = rgb & 0xFF) != 255)) {
                                ++i;
                                rgb >>= 8;
                            }
                        }
                        if (maxValue == 255) break;
                        ++x;
                    }
                    if (maxValue == 255) break;
                    ++y;
                }
                if ((maxValue = maxValue * 8 / 9) < 255) {
                    y = 0;
                    while ((float)y < 28.0f * scale) {
                        x = 0;
                        while ((float)x < 44.0f * scale) {
                            rgb = image.getRGB(x, y);
                            if ((rgb >> 24 & 0xFF) != 0) {
                                for (i = 0; i < 3; ++i) {
                                    int mask = 255 << i * 8;
                                    int v = rgb >> i * 8 & 0xFF;
                                    if ((v = v * 255 / maxValue) > 255) {
                                        v = 255;
                                    }
                                    rgb = rgb & ~mask | v << i * 8;
                                }
                                image.setRGB(x, y, rgb);
                            }
                            ++x;
                        }
                        ++y;
                    }
                }
                ImageIO.write((RenderedImage)image, "png", stream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packet.registerPacket(1, PacketMinecartUpdate.class);
        packet.registerPacket(2, PacketMinecartRequest.class);
        CapabilityManager.INSTANCE.register(MinecartDyeable.class, (Capability.IStorage)new MinecartDyeable.Storage(), MinecartDyeable.class);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void overrideRenderers(FMLPostInitializationEvent event) {
        Map entityRenderMap = Minecraft.func_71410_x().func_175598_ae().field_78729_o;
        for (Render e : entityRenderMap.values()) {
            Field f;
            if (!(e instanceof RenderMinecart)) continue;
            try {
                f = RenderMinecart.class.getDeclaredField("modelMinecart");
            }
            catch (NoSuchFieldException eee) {
                try {
                    f = RenderMinecart.class.getDeclaredField("field_77013_a");
                }
                catch (NoSuchFieldException ee) {
                    f = null;
                }
            }
            if (f == null) continue;
            try {
                f.setAccessible(true);
                f.set(e, (Object)new ModelMinecartWrapped((ModelBase)f.get(e)));
            }
            catch (IllegalAccessException eee) {
                eee.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof EntityMinecart) {
            event.addCapability(MINECART_DYEABLE_KEY, (ICapabilityProvider)new CapabilityProvider());
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityMinecart) {
            PacketMinecartRequest.send((EntityMinecart)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        MinecartDyeable properties;
        if (event.getTarget() instanceof EntityMinecart && !event.getTarget().func_130014_f_().field_72995_K && event.getEntityPlayer().func_70093_af() && ColorUtils.isDye(event.getEntityPlayer().func_184586_b(event.getHand())) && (properties = MinecartDyeable.get((EntityMinecart)event.getTarget())) != null) {
            properties.setColor(ColorUtils.getDyeColor(event.getEntityPlayer().func_184586_b(event.getHand())));
            event.setCanceled(true);
            event.getEntityPlayer().func_184609_a(event.getHand());
            PacketMinecartUpdate.send((EntityMinecart)event.getTarget());
        }
    }

    static {
        MINECART_DYEABLE_KEY = new ResourceLocation("charsettweaks:minecart_dyeable");
    }

    public static class CapabilityProvider
    implements ICapabilityProvider,
    INBTSerializable<NBTTagCompound> {
        private final MinecartDyeable dyeable = new MinecartDyeable();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == MINECART_DYEABLE;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == MINECART_DYEABLE ? this.dyeable : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)MINECART_DYEABLE.writeNBT((Object)this.dyeable, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            MINECART_DYEABLE.readNBT((Object)this.dyeable, null, (NBTBase)nbt);
        }
    }
}

