/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweaks;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.render.sprite.PixelOperationSprite;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.lib.utils.RenderUtils;

public class CharsetTweakUnifyColors {
    private final Gson gson = new Gson();
    private final ResourceLocation COLOR_PALETTE_LOC = new ResourceLocation("charset", "color_palette.json");
    private final Type COLOR_PALETTE_TYPE = new TypeToken<Map<String, float[]>>(){}.getType();
    private Map<String, float[]> colorPalette;

    private int colorMultiplier(String prefix, EnumDyeColor color) {
        float[] d = ColorUtils.getDyeRgb(color);
        if (prefix.contains("hardened_clay")) {
            float[] dOrig = d;
            d = Arrays.copyOf(dOrig, 3);
            float lum = d[0] * 0.3f + d[1] * 0.59f + d[2] * 0.11f;
            float mul = color == EnumDyeColor.YELLOW || color == EnumDyeColor.ORANGE || color == EnumDyeColor.RED ? 0.6f : 0.7f;
            d[0] = d[0] * 0.9f;
            d[1] = d[1] * 0.9f;
            d[2] = d[2] * 0.9f;
            d[0] = d[0] + (lum - d[0]) * mul;
            d[1] = d[1] + (lum - d[1]) * mul;
            d[2] = d[2] + (lum - d[2]) * mul;
        }
        return Math.min(Math.round(d[0] * 255.0f), 255) << 16 | Math.min(Math.round(d[1] * 255.0f), 255) << 8 | Math.min(Math.round(d[2] * 255.0f), 255) | 0xFF000000;
    }

    private BufferedImage toGrayscale(BufferedImage image) {
        BufferedImage imageGrayscale = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        for (int iy = 0; iy < image.getHeight(); ++iy) {
            for (int ix = 0; ix < image.getWidth(); ++ix) {
                int c = image.getRGB(ix, iy);
                int g = Math.round((float)(c & 0xFF) * 0.11f + (float)(c >> 8 & 0xFF) * 0.59f + (float)(c >> 16 & 0xFF) * 0.3f);
                int o = c & 0xFF000000 | g * 65793;
                imageGrayscale.setRGB(ix, iy, o);
            }
        }
        return imageGrayscale;
    }

    private int[] computeMinMaxData(BufferedImage image) {
        int[] out = new int[]{1, 1, 1, 0, 255, 255, 255, 0, 0, 0, 0, 0};
        for (int iy = 0; iy < image.getHeight(); ++iy) {
            for (int ix = 0; ix < image.getWidth(); ++ix) {
                int c = image.getRGB(ix, iy);
                int g = Math.round((float)(c & 0xFF) * 0.11f + (float)(c >> 8 & 0xFF) * 0.59f + (float)(c >> 16 & 0xFF) * 0.3f);
                if ((c & 0xFF) > out[0]) {
                    out[0] = c & 0xFF;
                }
                if ((c >> 8 & 0xFF) > out[1]) {
                    out[1] = c >> 8 & 0xFF;
                }
                if ((c >> 16 & 0xFF) > out[2]) {
                    out[2] = c >> 16 & 0xFF;
                }
                if ((c & 0xFF) < out[4]) {
                    out[4] = c & 0xFF;
                }
                if ((c >> 8 & 0xFF) < out[5]) {
                    out[5] = c >> 8 & 0xFF;
                }
                if ((c >> 16 & 0xFF) < out[6]) {
                    out[6] = c >> 16 & 0xFF;
                }
                out[8] = out[8] + (c & 0xFF);
                out[9] = out[9] + (c >> 8 & 0xFF);
                out[10] = out[10] + (c >> 16 & 0xFF);
                out[11] = out[11] + g;
            }
        }
        out[3] = Math.max(out[0], Math.max(out[1], out[2]));
        out[7] = Math.min(out[4], Math.min(out[5], out[6]));
        int i = 8;
        while (i < 12) {
            int n = i++;
            out[n] = out[n] / (image.getWidth() * image.getHeight());
        }
        return out;
    }

    private void recolorTextures(TextureMap map, String prefix) {
        ResourceLocation source = new ResourceLocation(prefix + "white");
        for (int i = 0; i < 16; ++i) {
            String s = ColorUtils.getUnderscoredSuffix(EnumDyeColor.func_176764_b((int)i));
            ResourceLocation target = new ResourceLocation(prefix + s);
            if (prefix.contains("hardened_clay")) {
                BufferedImage image = RenderUtils.getTextureImage(new ResourceLocation("minecraft:blocks/hardened_clay"));
                final BufferedImage imageGrayscale = this.toGrayscale(image);
                final int[] imageData = this.computeMinMaxData(image);
                final int[] imageGrayData = this.computeMinMaxData(imageGrayscale);
                int delta = imageGrayData[3] - imageGrayData[7];
                final float divisor = delta > 5 ? (float)delta / 5.0f : 1.0f;
                final int value2 = this.colorMultiplier(prefix, EnumDyeColor.func_176764_b((int)i));
                map.setTextureEntry((TextureAtlasSprite)new PixelOperationSprite(target.toString(), source){

                    @Override
                    public int apply(int x, int y, int value) {
                        int out = -16777216;
                        for (int i = 0; i < 24; i += 8) {
                            int v1 = (imageGrayscale.getRGB(x, y) >> i & 0xFF) * 255 / imageGrayData[i >> 3] - 255;
                            int v2 = (value2 >> i & 0xFF) + (v1 = (int)((float)v1 / divisor));
                            if (v2 < 0) {
                                v2 = 0;
                            }
                            if (v2 > 255) {
                                v2 = 255;
                            }
                            int nonTintedOut = v2 & 0xFF;
                            int tintedOut = nonTintedOut * imageData[8 + (i >> 3)] / imageData[3];
                            out |= Math.round((float)(nonTintedOut + tintedOut + tintedOut / 2) / 2.5f) << i;
                        }
                        return out;
                    }
                });
                continue;
            }
            if (i <= 0) continue;
            map.setTextureEntry((TextureAtlasSprite)new PixelOperationSprite.Multiply(target.toString(), source, this.colorMultiplier(prefix, EnumDyeColor.func_176764_b((int)i))));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        try {
            this.colorPalette = (Map)this.gson.fromJson((Reader)new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(this.COLOR_PALETTE_LOC).func_110527_b()), this.COLOR_PALETTE_TYPE);
            for (int i = 0; i < 16; ++i) {
                EnumDyeColor color = EnumDyeColor.func_176764_b((int)i);
                String key = ColorUtils.getUnderscoredSuffix(color);
                if (!this.colorPalette.containsKey(key)) continue;
                float[] src = this.colorPalette.get(key);
                float[] dst = ColorUtils.getDyeRgb(color);
                dst[0] = src[0];
                dst[1] = src[1];
                dst[2] = src[2];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.recolorTextures(event.getMap(), "minecraft:blocks/wool_colored_");
        this.recolorTextures(event.getMap(), "minecraft:blocks/glass_");
        this.recolorTextures(event.getMap(), "minecraft:blocks/glass_pane_top_");
        this.recolorTextures(event.getMap(), "minecraft:blocks/hardened_clay_stained_");
        this.recolorTextures(event.getMap(), "minecraft:blocks/concrete_");
        this.recolorTextures(event.getMap(), "minecraft:blocks/concrete_powder_");
        this.recolorTextures(event.getMap(), "minecraft:blocks/shulker_top_");
    }
}

