/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.world;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JFrame;
import pl.asie.charset.lib.utils.OpenSimplexNoise;

public class AlgorithmTester {
    private static final int COORD_Z = 0;
    private OpenSimplexNoise noise;
    private static final int COLOR_AIR = -1;
    private static final int COLOR_STONE = -6710887;
    private static final int COLOR_DIRT = -5614336;
    private static final int COLOR_GRASS = -16733696;
    private static final Random RANDOM = new Random();
    private JFrame window = new JFrame(this.getClass().getName());
    private Canvas canvas = new Canvas();

    public int calc(int x, int y, int z) {
        double v = y - 80;
        double heightBase = this.noise.eval((float)x * 0.005f, 3.94384848E8, (float)z * 0.005f) * 64.0;
        double roughness = (this.noise.eval((float)x * 0.002f, 203984.0, (float)z * 0.002f) + 1.0) / 100.0 + (double)1.0E-4f;
        v += heightBase;
        return (v += this.noise.eval((double)x * roughness, (float)y * 0.002f, (double)z * roughness) * 32.0) < 0.0 ? 1 : 0;
    }

    public void update() {
        this.init();
        BufferedImage img = this.canvas.img;
        for (int x = 0; x < img.getWidth(); ++x) {
            int ctr = 0;
            boolean hasWater = false;
            for (int y = 0; y < img.getHeight(); ++y) {
                int ry = img.getHeight() - 1 - y;
                int out = this.calc(x, ry, 0);
                int color = -1;
                if (out == 0) {
                    ctr = 0;
                    if (ry < 64) {
                        color = -16777046;
                        hasWater = true;
                    }
                } else {
                    color = hasWater && ++ctr <= 4 ? -171 : (ctr == 1 ? -16733696 : (ctr >= 2 && ctr <= 4 ? -5614336 : -6710887));
                }
                img.setRGB(x, y, color);
            }
        }
    }

    public void init() {
        this.noise = new OpenSimplexNoise(RANDOM.nextInt());
    }

    public AlgorithmTester() {
        this.window.add(this.canvas);
        this.window.pack();
        this.window.setDefaultCloseOperation(3);
        this.window.setVisible(true);
        this.window.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                AlgorithmTester.this.update();
                AlgorithmTester.this.canvas.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.update();
    }

    public static void main(String[] args) {
        AlgorithmTester tester = new AlgorithmTester();
    }

    public static class Canvas
    extends JComponent {
        public final BufferedImage img;
        public final Dimension size = new Dimension(800, 256);
        public final float multiplier = 1.0f;
        public final Dimension renderSize = Canvas.multiply(this.size, 1.0f);

        private static Dimension multiply(Dimension size, float f) {
            return f == 1.0f ? size : new Dimension(Math.round((float)size.width * f), Math.round((float)size.height * f));
        }

        public Canvas() {
            this.setSize(this.renderSize);
            this.setPreferredSize(this.renderSize);
            this.img = new BufferedImage(this.size.width, this.size.height, 2);
        }

        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(this.img, 0, 0, null);
        }
    }
}

