/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.world;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import net.minecraft.item.EnumDyeColor;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.lib.utils.RenderUtils;

public class TestWools {
    private JFrame window = new JFrame(this.getClass().getName());
    private Canvas canvas = new Canvas();

    private float[] colorMultiplier(String prefix, EnumDyeColor color) {
        float[] dOrig = ColorUtils.getDyeRgb(color);
        float[] d = Arrays.copyOf(dOrig, 3);
        if (color == EnumDyeColor.BLUE) {
            d[0] = d[0] * 0.925f;
            d[1] = d[1] * 0.925f;
            d[2] = d[2] * 0.875f;
        } else if (color == EnumDyeColor.ORANGE) {
            d[0] = d[0] * 1.075f;
            d[1] = d[1] * 1.075f;
        } else if (color == EnumDyeColor.YELLOW) {
            d[0] = d[0] * 1.1f;
            d[1] = d[1] * 0.95f;
            d[2] = d[2] * 0.95f;
        } else if (color == EnumDyeColor.MAGENTA) {
            d[0] = d[0] * 1.1f;
            d[1] = d[1] * 1.05f;
            d[2] = d[2] * 1.1f;
        } else if (color == EnumDyeColor.LIGHT_BLUE) {
            d[0] = d[0] * 1.05f;
            d[1] = d[1] * 1.05f;
            d[2] = d[2] * 1.05f;
        } else if (color == EnumDyeColor.PINK) {
            d[0] = d[0] * 1.025f;
            d[1] = d[1] * 1.075f;
            d[2] = d[2] * 1.025f;
        } else if (color == EnumDyeColor.CYAN) {
            d[0] = d[0] * 0.9f;
            d[1] = d[1] * 0.95f;
            d[2] = d[2] * 1.05f;
        } else if (color == EnumDyeColor.PURPLE) {
            d[0] = d[0] * 1.0f;
            d[1] = d[1] * 1.075f;
            d[2] = d[2] * 1.0f;
        } else if (color == EnumDyeColor.BROWN) {
            d[0] = d[0] * 1.0f;
            d[1] = d[1] * 0.925f;
            d[2] = d[2] * 1.0f;
        } else if (color == EnumDyeColor.BLACK) {
            d[0] = d[0] * 1.33f;
            d[1] = d[1] * 1.33f;
            d[2] = d[2] * 1.33f;
        } else if (color == EnumDyeColor.GRAY) {
            d[0] = d[0] * 1.125f;
            d[1] = d[1] * 1.125f;
            d[2] = d[2] * 1.125f;
        }
        if (prefix.contains("hardened_clay")) {
            float lum = d[0] * 0.3f + d[1] * 0.59f + d[2] * 0.11f;
            float mul = color == EnumDyeColor.YELLOW || color == EnumDyeColor.ORANGE || color == EnumDyeColor.RED ? 0.6f : 0.7f;
            d[0] = d[0] * 0.9f;
            d[1] = d[1] * 0.9f;
            d[2] = d[2] * 0.9f;
            d[0] = d[0] + (lum - d[0]) * mul;
            d[1] = d[1] + (lum - d[1]) * mul;
            d[2] = d[2] + (lum - d[2]) * mul;
        }
        return d;
    }

    private int toIntColor(float[] d) {
        return Math.min(Math.round(d[0] * 255.0f), 255) << 16 | Math.min(Math.round(d[1] * 255.0f), 255) << 8 | Math.min(Math.round(d[2] * 255.0f), 255) | 0xFF000000;
    }

    public void update() throws Exception {
        System.out.println("{");
        for (int i = 0; i < 16; ++i) {
            float[] color1 = this.colorMultiplier("", EnumDyeColor.func_176764_b((int)i));
            String name = ColorUtils.getUnderscoredSuffix(EnumDyeColor.func_176764_b((int)i));
            System.out.println("\t\"" + name + "\": [" + color1[0] + ", " + color1[1] + ", " + color1[2] + "],");
        }
        System.out.println("}");
        BufferedImage img = this.canvas.img;
        BufferedImage wool = ImageIO.read(this.getClass().getClassLoader().getResourceAsStream("assets/minecraft/textures/blocks/wool_colored_white.png"));
        for (int wc2 = 0; wc2 < 16; ++wc2) {
            for (int wc1 = wc2; wc1 < 16; ++wc1) {
                float[] color1 = this.colorMultiplier("", EnumDyeColor.func_176764_b((int)wc1));
                float[] color2 = this.colorMultiplier("", EnumDyeColor.func_176764_b((int)wc2));
                float[] color = new float[3];
                for (int i = 0; i < 3; ++i) {
                    color[i] = (color1[i] + color2[i]) / 2.0f;
                }
                int colorTarget = this.toIntColor(color);
                for (int iy = 0; iy < 16; ++iy) {
                    for (int ix = 0; ix < 16; ++ix) {
                        img.setRGB(wc1 * 16 + ix, wc2 * 16 + iy, RenderUtils.multiplyColor(wool.getRGB(ix, iy), colorTarget));
                    }
                }
            }
        }
    }

    public TestWools() {
        this.window.add(this.canvas);
        this.window.pack();
        this.window.setDefaultCloseOperation(3);
        this.window.setVisible(true);
        this.window.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    TestWools.this.update();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                TestWools.this.canvas.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        try {
            this.update();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        TestWools tester = new TestWools();
    }

    public static class Canvas
    extends JComponent {
        public final BufferedImage img;
        public final Dimension size = new Dimension(256, 256);
        public final float multiplier = 2.0f;
        public final Dimension renderSize = Canvas.multiply(this.size, 2.0f);

        private static Dimension multiply(Dimension size, float f) {
            return f == 1.0f ? size : new Dimension(Math.round((float)size.width * f), Math.round((float)size.height * f));
        }

        public Canvas() {
            this.setSize(this.renderSize);
            this.setPreferredSize(this.renderSize);
            this.img = new BufferedImage(this.size.width, this.size.height, 2);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g2.drawRenderedImage(this.img, AffineTransform.getScaleInstance(2.0, 2.0));
        }
    }
}

