/*
 * Decompiled with CFR 0.152.
 */
package RebornStorage.blocks;

import RebornStorage.RebornStorage;
import RebornStorage.client.CreativeTabRebornStorage;
import RebornStorage.packet.PacketGui;
import RebornStorage.tiles.TileMultiCrafter;
import com.google.common.collect.Lists;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.blocks.PropertyString;
import reborncore.common.multiblock.BlockMultiblockBase;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.NetworkManager;
import reborncore.common.util.ArrayUtils;
import reborncore.common.util.ChatUtils;

public class BlockMultiCrafter
extends BlockMultiblockBase {
    public static final String[] types = new String[]{"frame", "heat", "cpu", "storage"};
    private static final List<String> typesList = Lists.newArrayList((Object[])ArrayUtils.arrayToLowercase((String[])types));
    public static final PropertyString VARIANTS = new PropertyString("type", types);

    public BlockMultiCrafter() {
        super(Material.field_151573_f);
        this.func_149647_a(CreativeTabRebornStorage.INSTANCE);
        this.func_149663_c("rebornstorage.multicrafter");
        this.func_180632_j(this.func_176203_a(0));
        this.func_149711_c(2.0f);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileMultiCrafter((String)((Object)this.func_176203_a(meta).func_177229_b((IProperty)VARIANTS)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileMultiCrafter tile = (TileMultiCrafter)worldIn.func_175625_s(pos);
        if (tile.getMultiblockController() != null) {
            if (!tile.getMultiblockController().isAssembled()) {
                if (tile.getMultiblockController().getLastValidationException() != null) {
                    if (worldIn.field_72995_K) {
                        ChatUtils.sendNoSpamMessages((int)42, (ITextComponent)new TextComponentString(tile.getMultiblockController().getLastValidationException().getMessage()));
                    }
                    return false;
                }
            } else if (worldIn.field_72995_K) {
                playerIn.openGui((Object)RebornStorage.INSTANCE, 1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                NetworkManager.sendToServer((INetworkPacket)new PacketGui(0, pos));
                return true;
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            API.instance().discoverNode(world, pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176194_O().func_177621_b().func_177226_a((IProperty)VARIANTS, (Comparable)((Object)typesList.get(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return typesList.indexOf(state.func_177229_b((IProperty)VARIANTS));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANTS});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add((Object)new ItemStack((Block)this, 1, meta));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileMultiCrafter) {
            TileMultiCrafter tile = (TileMultiCrafter)tileentity;
            if (tile.inv == null) {
                super.func_180663_b(worldIn, pos, state);
                return;
            }
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)tile.inv);
        }
        INetworkNodeManager manager = API.instance().getNetworkNodeManager(worldIn);
        INetworkNode node = manager.getNode(pos);
        manager.removeNode(pos);
        manager.markForSaving();
        if (node.getNetwork() != null) {
            node.getNetwork().getNodeGraph().rebuild();
        }
        super.func_180663_b(worldIn, pos, state);
    }
}

