/*
 * Decompiled with CFR 0.152.
 */
package RebornStorage.items;

import RebornStorage.init.EnumFluidStorage;
import RebornStorage.items.ItemBase;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.storage.StorageDiskType;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ItemRebornStorageCellFluid
extends ItemBase
implements IStorageDiskProvider<FluidStack> {
    public static final String[] types = new String[]{"1024k", "4096k", "16384k", "32768k"};

    public ItemRebornStorageCellFluid() {
        this.func_77655_b("rebornstorage.storagecellfluid");
        this.func_77627_a(true);
        this.setRegistryName("storagecellfluid");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int meta = 0; meta < EnumFluidStorage.values().length; ++meta) {
                list.add((Object)API.instance().getDefaultStorageDiskBehavior().initDisk(StorageDiskType.FLUIDS, new ItemStack((Item)this, 1, meta)));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!stack.func_77942_o()) {
            API.instance().getDefaultStorageDiskBehavior().initDisk(StorageDiskType.FLUIDS, stack);
        }
    }

    public void func_77624_a(ItemStack disk, World world, List<String> tooltip, ITooltipFlag flag) {
        IStorageDisk<FluidStack> storage = this.create(disk);
        if (storage.isValid(disk)) {
            if (storage.getCapacity() == -1) {
                tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored", (Object[])new Object[]{storage.getStored()}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored_capacity", (Object[])new Object[]{storage.getStored(), storage.getCapacity()}));
            }
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        int meta = itemStack.func_77952_i();
        if (meta < 0 || meta >= types.length) {
            meta = 0;
        }
        return super.func_77658_a() + "." + types[meta];
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        API.instance().getDefaultStorageDiskBehavior().initDisk(StorageDiskType.FLUIDS, stack);
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return Integer.MAX_VALUE;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        return API.instance().getDefaultStorageDiskBehavior().getShareTag(StorageDiskType.FLUIDS, stack);
    }

    @Nonnull
    public IStorageDisk<FluidStack> create(ItemStack disk) {
        return API.instance().getDefaultStorageDiskBehavior().createFluidStorage(disk.func_77978_p(), EnumFluidStorage.getById(disk.func_77952_i()).getCap());
    }
}

