/*
 * Decompiled with CFR 0.152.
 */
package RebornStorage.multiblocks;

import RebornStorage.blocks.BlockMultiCrafter;
import RebornStorage.tiles.TileMultiCrafter;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import reborncore.RebornCore;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.rectangular.RectangularMultiblockControllerBase;
import reborncore.common.util.Inventory;

public class MultiBlockCrafter
extends RectangularMultiblockControllerBase {
    public Map<Integer, Inventory> invs = new TreeMap<Integer, Inventory>();
    public int powerUsage = 0;
    public int speed = 0;
    public int pages = 0;
    boolean hasRebuiltRecently = false;
    public List<ICraftingPattern> actualPatterns = new ArrayList<ICraftingPattern>();
    public ICraftingPatternContainer node;

    public MultiBlockCrafter(World world) {
        super(world);
    }

    public void onAttachedPartWithMultiblockData(IMultiblockPart iMultiblockPart, NBTTagCompound nbtTagCompound) {
    }

    protected void onBlockAdded(IMultiblockPart iMultiblockPart) {
    }

    protected void onBlockRemoved(IMultiblockPart iMultiblockPart) {
    }

    protected void onMachineAssembled() {
        this.updateInfo();
        this.hasRebuiltRecently = false;
        this.rebuildPatterns();
    }

    public void updateInfo() {
        this.powerUsage = 0;
        this.speed = 0;
        this.pages = 0;
        this.invs.clear();
        TreeMap<Integer, TileMultiCrafter> collector = new TreeMap<Integer, TileMultiCrafter>();
        int append = 2745;
        for (IMultiblockPart part : this.connectedParts) {
            if (((String)((Object)part.getBlockState().func_177229_b((IProperty)BlockMultiCrafter.VARIANTS))).equals("storage")) {
                ++this.pages;
                this.powerUsage += 5;
                TileMultiCrafter tile = (TileMultiCrafter)part;
                if (tile.page.isPresent()) {
                    collector.put(tile.page.get(), tile);
                } else {
                    collector.put(append++, tile);
                }
            }
            if (!((String)((Object)part.getBlockState().func_177229_b((IProperty)BlockMultiCrafter.VARIANTS))).equals("cpu")) continue;
            this.powerUsage += 10;
            ++this.speed;
        }
        int newid = 0;
        for (TileMultiCrafter tile : collector.values()) {
            tile.page = Optional.of(++newid);
            this.invs.put(newid, tile.inv);
        }
    }

    public Inventory getInvForPage(int page) {
        return this.invs.get(page);
    }

    protected void onMachineRestored() {
    }

    protected void onMachinePaused() {
    }

    protected void onMachineDisassembled() {
        this.actualPatterns.clear();
    }

    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 27;
    }

    protected int getMaximumXSize() {
        return 16;
    }

    protected int getMaximumZSize() {
        return 16;
    }

    protected int getMaximumYSize() {
        return 16;
    }

    protected int getMinimumXSize() {
        return 3;
    }

    protected int getMinimumYSize() {
        return 3;
    }

    protected int getMinimumZSize() {
        return 3;
    }

    protected void onAssimilate(MultiblockControllerBase multiblockControllerBase) {
    }

    protected void onAssimilated(MultiblockControllerBase multiblockControllerBase) {
    }

    protected boolean updateServer() {
        this.tick();
        return true;
    }

    protected void updateClient() {
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
    }

    public void formatDescriptionPacket(NBTTagCompound nbtTagCompound) {
        this.writeToNBT(nbtTagCompound);
    }

    public void decodeDescriptionPacket(NBTTagCompound nbtTagCompound) {
        this.readFromNBT(nbtTagCompound);
    }

    public void tick() {
        this.hasRebuiltRecently = false;
    }

    public void rebuildPatterns() {
        if (this.hasRebuiltRecently) {
            return;
        }
        this.hasRebuiltRecently = true;
        long start = System.currentTimeMillis();
        if (this.worldObj.field_72995_K) {
            return;
        }
        if (this.node == null) {
            this.node = this.getReferenceTile().getNewNode();
        }
        this.actualPatterns.clear();
        if (this.isAssembled()) {
            this.updateInfo();
            for (Map.Entry<Integer, Inventory> entry : this.invs.entrySet()) {
                for (int i = 0; i < entry.getValue().func_70302_i_(); ++i) {
                    ICraftingPattern pattern;
                    ItemStack patternStack = entry.getValue().func_70301_a(i);
                    if (patternStack.func_190926_b() || !(patternStack.func_77973_b() instanceof ICraftingPatternProvider) || !(pattern = ((ICraftingPatternProvider)patternStack.func_77973_b()).create(this.worldObj, patternStack, this.node)).isValid()) continue;
                    this.actualPatterns.add(pattern);
                }
            }
        }
        RebornCore.logHelper.debug((Object)("pattern rebuild took" + (System.currentTimeMillis() - start) + " ms"));
    }

    private TileMultiCrafter getReferenceTile() {
        return (TileMultiCrafter)this.worldObj.func_175625_s(this.getReferenceCoord().toBlockPos());
    }
}

