/*
 * Decompiled with CFR 0.152.
 */
package RebornStorage.tiles;

import RebornStorage.blocks.BlockMultiCrafter;
import RebornStorage.multiblocks.MultiBlockCrafter;
import RebornStorage.tiles.NetworkNodeMultiCrafter;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.MultiblockValidationException;
import reborncore.common.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import reborncore.common.util.Inventory;

public class TileMultiCrafter
extends RectangularMultiblockTileEntityBase
implements INetworkNodeProxy {
    NetworkNodeMultiCrafter clientNode;
    NetworkNodeMultiCrafter serverNode;
    public Inventory inv;
    public Optional<Integer> page = Optional.empty();

    public void isGoodForFrame() throws MultiblockValidationException {
        if (!this.getVarient().equals("frame")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the frame of the block");
        }
    }

    public void isGoodForSides() throws MultiblockValidationException {
        if (!this.getVarient().equals("heat")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the sides of the block");
        }
    }

    public void isGoodForTop() throws MultiblockValidationException {
        if (!this.getVarient().equals("heat")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the sides of the block");
        }
    }

    public void isGoodForBottom() throws MultiblockValidationException {
        if (!this.getVarient().equals("heat")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the sides of the block");
        }
    }

    public void isGoodForInterior() throws MultiblockValidationException {
        if (!this.getVarient().equals("cpu") && !this.getVarient().equals("storage")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the inside of the block");
        }
    }

    public void onMachineActivated() {
        if (this.getMultiBlock() != null) {
            MultiBlockCrafter multiBlockCrafter = this.getMultiBlock();
            multiBlockCrafter.rebuildPatterns();
        }
    }

    public void onMachineDeactivated() {
        if (this.getMultiBlock() != null) {
            MultiBlockCrafter multiBlockCrafter = this.getMultiBlock();
            multiBlockCrafter.rebuildPatterns();
        }
    }

    String getVarient() {
        return (String)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockMultiCrafter.VARIANTS));
    }

    public MultiblockControllerBase createNewMultiblock() {
        return new MultiBlockCrafter(this.func_145831_w());
    }

    public Class<? extends MultiblockControllerBase> getMultiblockControllerType() {
        return MultiBlockCrafter.class;
    }

    public MultiBlockCrafter getMultiBlock() {
        return (MultiBlockCrafter)this.getMultiblockController();
    }

    public void func_73660_a() {
        if (this.inv != null && this.inv.hasChanged) {
            this.inv.hasChanged = false;
            this.checkNodes(true);
            API.instance().discoverNode(this.field_145850_b, this.field_174879_c);
            if (!this.field_145850_b.field_72995_K && this.serverNode != null && this.serverNode.getNetwork() != null && this.serverNode.getNetwork().getCraftingManager() != null) {
                this.serverNode.getNetwork().getCraftingManager().rebuild();
            }
        }
    }

    public void checkNodes(boolean rebuildPatterns) {
        if (this.getMultiBlock() == null) {
            return;
        }
        MultiBlockCrafter multiBlockCrafter = this.getMultiBlock();
        if (this.field_145850_b.field_72995_K) {
            multiBlockCrafter.node = this.clientNode;
        } else {
            multiBlockCrafter.node = this.serverNode;
            if (rebuildPatterns) {
                multiBlockCrafter.rebuildPatterns();
            }
        }
    }

    public TileMultiCrafter(String varient) {
        if (varient.equals("storage")) {
            this.inv = new Inventory(78, "storageBlock", 1, (TileEntity)this);
        }
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (this.inv == null && data.func_74764_b("hasInv")) {
            this.inv = new Inventory(78, "storageBlock", 1, (TileEntity)this);
        }
        if (this.inv != null) {
            this.inv.readFromNBT(data);
        }
        if (data.func_74764_b("page")) {
            this.page = Optional.of(data.func_74762_e("page"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        if (this.inv != null) {
            this.inv.writeToNBT(data);
            data.func_74757_a("hasInv", true);
        }
        if (this.page.isPresent()) {
            data.func_74768_a("page", this.page.get().intValue());
        }
        return super.func_189515_b(data);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public TileMultiCrafter() {
    }

    @Nonnull
    public INetworkNode getNode() {
        if (!this.field_145850_b.field_72995_K) {
            INetworkNodeManager manager = API.instance().getNetworkNodeManager(this.field_145850_b);
            NetworkNodeMultiCrafter node = (NetworkNodeMultiCrafter)manager.getNode(this.field_174879_c);
            if (node == null || !node.getId().equals("rebornstorage.multicrafter")) {
                node = this.getNewNode();
                manager.setNode(this.field_174879_c, (INetworkNode)node);
                manager.markForSaving();
            }
            this.serverNode = node;
            this.checkNodes(false);
            return node;
        }
        if (this.clientNode == null) {
            this.clientNode = this.getNewNode();
        }
        this.checkNodes(false);
        return this.clientNode;
    }

    public NetworkNodeMultiCrafter getNewNode() {
        return new NetworkNodeMultiCrafter(this);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY) {
            return (T)CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, side);
    }
}

