/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import wanion.lib.common.FixedSizeList;
import wanion.lib.common.MetaItem;
import wanion.unidict.UniDict;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.integration.AbstractIntegrationThread;

final class IEIntegration
extends AbstractIntegrationThread {
    private final UniOreDictionary uniOreDictionary = (UniOreDictionary)UniDict.getDependencies().get(UniOreDictionary.class);

    IEIntegration() {
        super("Immersive Engineering");
    }

    public String call() {
        try {
            this.fixArcFurnaceRecipes();
            this.fixBlastFurnaceRecipes();
            this.fixCrusherRecipes();
            this.fixMetalPressRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "The world's engineer appears to be more immersive.";
    }

    private void fixArcFurnaceRecipes() {
        ArrayList arcFurnaceRecipes = ArcFurnaceRecipe.recipeList;
        ArrayList<ArcFurnaceRecipe> correctRecipes = new ArrayList<ArcFurnaceRecipe>(new Double((double)arcFurnaceRecipes.size() * 1.3).intValue());
        Iterator arcFurnaceRecipeIterator = arcFurnaceRecipes.iterator();
        while (arcFurnaceRecipeIterator.hasNext()) {
            ArcFurnaceRecipe recipe = (ArcFurnaceRecipe)arcFurnaceRecipeIterator.next();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(recipe.output);
            if (correctOutput == recipe.output) continue;
            int time = (int)Math.floor((float)recipe.getTotalProcessTime() / ArcFurnaceRecipe.timeModifier);
            int energy = (int)Math.floor((float)recipe.getTotalProcessEnergy() / ArcFurnaceRecipe.energyModifier / (float)recipe.getTotalProcessTime());
            correctRecipes.add(new ArcFurnaceRecipe(correctOutput, this.ingredientStackToValidInput(recipe.input), recipe.slag, time, energy, this.ingredientStackToValidInput(recipe.additives)));
            arcFurnaceRecipeIterator.remove();
        }
        arcFurnaceRecipes.addAll(correctRecipes);
    }

    private void fixBlastFurnaceRecipes() {
        ArrayList correctRecipes = new ArrayList(new Double((double)BlastFurnaceRecipe.recipeList.size() * 1.3).intValue());
        correctRecipes.addAll(BlastFurnaceRecipe.recipeList.stream().map(blastFurnaceRecipe -> new BlastFurnaceRecipe(this.resourceHandler.getMainItemStack(blastFurnaceRecipe.output), blastFurnaceRecipe.input, blastFurnaceRecipe.time, blastFurnaceRecipe.slag)).collect(Collectors.toList()));
        BlastFurnaceRecipe.recipeList.clear();
        BlastFurnaceRecipe.recipeList.addAll(correctRecipes);
    }

    private void fixCrusherRecipes() {
        ArrayList crusherRecipes = CrusherRecipe.recipeList;
        FixedSizeList correctRecipes = new FixedSizeList(crusherRecipes.size());
        TIntHashSet uniques = new TIntHashSet(crusherRecipes.size(), 1.0f);
        Iterator crusherRecipesIterator = crusherRecipes.iterator();
        while (crusherRecipesIterator.hasNext()) {
            CrusherRecipe crusherRecipe = (CrusherRecipe)crusherRecipesIterator.next();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(crusherRecipe.output);
            if (correctOutput == crusherRecipe.output) continue;
            ItemStack input = UniOreDictionary.getFirstEntry(crusherRecipe.oreInputString);
            int recipeId = MetaItem.getCumulative((ItemStack[])new ItemStack[]{input, correctOutput});
            if (!uniques.contains(recipeId)) {
                int energy = (int)Math.floor((float)crusherRecipe.getTotalProcessEnergy() / CrusherRecipe.energyModifier);
                if (crusherRecipe.secondaryOutput == null) {
                    correctRecipes.add(new CrusherRecipe(correctOutput, this.ingredientStackToValidInput(crusherRecipe.input), energy));
                } else {
                    correctRecipes.add(new UniCrusherRecipe(correctOutput, this.ingredientStackToValidInput(crusherRecipe.input), energy, this.resourceHandler.getMainItemStacks(crusherRecipe.secondaryOutput), crusherRecipe.secondaryChance));
                }
                uniques.add(recipeId);
            }
            crusherRecipesIterator.remove();
        }
        crusherRecipes.addAll(correctRecipes);
    }

    private void fixMetalPressRecipes() {
        ArrayListMultimap metalPressRecipes = MetalPressRecipe.recipeList;
        ArrayListMultimap correctRecipes = ArrayListMultimap.create();
        TIntHashSet uniques = new TIntHashSet(metalPressRecipes.size(), 1.0f);
        Iterator metalPressRecipesIterator = metalPressRecipes.values().iterator();
        while (metalPressRecipesIterator.hasNext()) {
            MetalPressRecipe metalPressRecipe = (MetalPressRecipe)metalPressRecipesIterator.next();
            ItemStack output = this.resourceHandler.getMainItemStack(metalPressRecipe.output);
            if (output == metalPressRecipe.output) continue;
            int id = MetaItem.getCumulative((ItemStack[])new ItemStack[]{output, metalPressRecipe.mold.stack});
            if (!uniques.contains(id)) {
                correctRecipes.put((Object)metalPressRecipe.mold, (Object)new MetalPressRecipe(output, this.ingredientStackToValidInput(metalPressRecipe.input), metalPressRecipe.mold.stack, (int)Math.floor((float)metalPressRecipe.getTotalProcessEnergy() / MetalPressRecipe.timeModifier)).setInputSize(metalPressRecipe.input.inputSize));
                uniques.add(id);
            }
            metalPressRecipesIterator.remove();
        }
        metalPressRecipes.putAll((Multimap)correctRecipes);
    }

    private Object[] ingredientStackToValidInput(IngredientStack[] ingredientStacks) {
        if (ingredientStacks == null) {
            return null;
        }
        ArrayList<Object> inputs = new ArrayList<Object>();
        for (IngredientStack ingredientStack : ingredientStacks) {
            Object buf = this.ingredientStackToValidInput(ingredientStack);
            if (buf == null) continue;
            inputs.add(buf);
        }
        return inputs.toArray();
    }

    private Object ingredientStackToValidInput(IngredientStack ingredientStack) {
        if (ingredientStack == null) {
            return null;
        }
        ItemStack buf = ingredientStack.stack;
        if (buf != null) {
            if (buf instanceof ItemStack) {
                return buf;
            }
            if (buf instanceof List && !((List)buf).isEmpty()) {
                String oreName = this.uniOreDictionary.getName(buf);
                if (oreName != null) {
                    return oreName;
                }
                Object object = ((List)buf).get(0);
                if (object instanceof ItemStack) {
                    return Arrays.copyOf(((List)buf).toArray(), ((List)buf).size(), ItemStack[].class);
                }
                if (object instanceof String) {
                    return Arrays.copyOf(((List)buf).toArray(), ((List)buf).size(), String[].class);
                }
            }
        }
        return null;
    }

    private static final class UniCrusherRecipe
    extends CrusherRecipe {
        private UniCrusherRecipe(ItemStack output, Object input, int energy, ItemStack[] secondaryOutputs, float[] secondaryChances) {
            super(output, input, energy);
            this.secondaryOutput = secondaryOutputs;
            this.secondaryChance = secondaryChances;
        }
    }
}

