/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.text.WordUtils;
import wanion.lib.module.AbstractModule;
import wanion.unidict.common.Reference;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.integration.AbyssalCraftIntegration;
import wanion.unidict.integration.EmbersIntegration;
import wanion.unidict.integration.FurnaceIntegration;
import wanion.unidict.integration.IC2Integration;
import wanion.unidict.integration.IEIntegration;
import wanion.unidict.integration.MekanismIntegration;
import wanion.unidict.integration.TEIntegration;
import wanion.unidict.integration.TechRebornIntegration;

public final class IntegrationModule
extends AbstractModule {
    public IntegrationModule() {
        super("Integration", Class::newInstance);
    }

    protected void init() {
        Configuration config = new Configuration(new File("." + Reference.SLASH + "config" + Reference.SLASH + "unidict" + Reference.SLASH + "IntegrationModule.cfg"));
        for (Integration integration : Integration.values()) {
            if (!config.get("Integrations", WordUtils.capitalizeFully((String)integration.name().replace("_", " ")).replace(" ", ""), integration.enabledByDefault).getBoolean() || integration.modId != null && !Loader.isModLoaded((String)integration.modId)) continue;
            this.manager.add(integration.integrationClass);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static enum Integration {
        FURNACE(FurnaceIntegration.class),
        ABYSSAL_CRAFT("abyssalcraft", AbyssalCraftIntegration.class),
        EMBERS("embers", EmbersIntegration.class),
        IMMERSIVE_ENGINEERING("immersiveengineering", IEIntegration.class),
        INDUSTRIAL_CRAFT_2("ic2", IC2Integration.class),
        MEKANISM("mekanism", MekanismIntegration.class),
        TECH_REBORN("techreborn", TechRebornIntegration.class),
        THERMAL_EXPANSION("thermalexpansion", TEIntegration.class);

        private final String modId;
        private final Class<? extends AbstractIntegrationThread> integrationClass;
        private final boolean enabledByDefault;

        private Integration(Class<? extends AbstractIntegrationThread> integrationClass) {
            this(null, integrationClass);
        }

        private Integration(String modId, Class<? extends AbstractIntegrationThread> integrationClass) {
            this.modId = modId;
            this.integrationClass = integrationClass;
            this.enabledByDefault = true;
        }

        private Integration(String modId, Class<? extends AbstractIntegrationThread> integrationClass, boolean enabledByDefault) {
            this.modId = modId;
            this.integrationClass = integrationClass;
            this.enabledByDefault = enabledByDefault;
        }
    }
}

