/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import net.minecraft.item.ItemStack;
import wanion.lib.common.MetaItem;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.resource.UniResourceContainer;

final class MekanismIntegration
extends AbstractIntegrationThread {
    MekanismIntegration() {
        super("Mekanism");
    }

    public String call() {
        try {
            this.fixMekanismRecipes(RecipeHandler.Recipe.CRUSHER.get());
            this.fixMekanismRecipes(RecipeHandler.Recipe.ENRICHMENT_CHAMBER.get());
            this.fixInfusionMekanismRecipes(RecipeHandler.Recipe.METALLURGIC_INFUSER.get());
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "All the mekanisms were checked.";
    }

    private void fixMekanismRecipes(@Nonnull Map<ItemStackInput, MachineRecipe<ItemStackInput, ItemStackOutput, ? extends MachineRecipe>> recipes) {
        int initialSize = recipes.size();
        HashMap<MachineInput, MachineRecipe> correctRecipes = new HashMap<MachineInput, MachineRecipe>(initialSize, 1.0f);
        if (!this.config.inputReplacementMekanism) {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerInputKeyMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<MachineRecipe<ItemStackInput, ItemStackOutput, ? extends MachineRecipe>> mekanismRecipeIterator = recipes.values().iterator();
            while (mekanismRecipeIterator.hasNext()) {
                TIntSet inputKeySet;
                MachineRecipe<ItemStackInput, ItemStackOutput, ? extends MachineRecipe> mekanismRecipe = mekanismRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((ItemStackInput)mekanismRecipe.recipeInput).ingredient);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                MachineRecipe correctRecipe = mekanismRecipe.copy();
                ItemStack inputStack = this.config.keepOneEntry ? (((ItemStackInput)correctRecipe.recipeInput).ingredient = inputContainer.getMainEntry(((ItemStackInput)correctRecipe.recipeInput).ingredient.func_190916_E())) : (((ItemStackInput)correctRecipe.recipeInput).ingredient = ((ItemStackInput)correctRecipe.recipeInput).ingredient.func_77946_l());
                int inputId = MetaItem.get((ItemStack)inputStack);
                if (!containerInputKeyMap.containsKey(outputContainer)) {
                    containerInputKeyMap.put(outputContainer, new TIntHashSet());
                }
                if (!(inputKeySet = (TIntSet)containerInputKeyMap.get(outputContainer)).contains(inputId)) {
                    inputKeySet.add(inputId);
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)correctRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                mekanismRecipeIterator.remove();
            }
        } else {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerKindMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<MachineRecipe<ItemStackInput, ItemStackOutput, ? extends MachineRecipe>> mekanismRecipeIterator = recipes.values().iterator();
            while (mekanismRecipeIterator.hasNext()) {
                TIntSet kindSet;
                MachineRecipe<ItemStackInput, ItemStackOutput, ? extends MachineRecipe> mekanismRecipe = mekanismRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((ItemStackInput)mekanismRecipe.recipeInput).ingredient);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                int kind = inputContainer.kind;
                if (!containerKindMap.containsKey(outputContainer)) {
                    containerKindMap.put(outputContainer, new TIntHashSet());
                }
                if (!(kindSet = (TIntSet)containerKindMap.get(outputContainer)).contains(kind)) {
                    kindSet.add(kind);
                    MachineRecipe correctRecipe = mekanismRecipe.copy();
                    ((ItemStackInput)correctRecipe.recipeInput).ingredient = inputContainer.getMainEntry(((ItemStackInput)correctRecipe.recipeInput).ingredient.func_190916_E());
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                mekanismRecipeIterator.remove();
            }
        }
        recipes.putAll(correctRecipes);
    }

    private void fixInfusionMekanismRecipes(@Nonnull Map<InfusionInput, MachineRecipe<InfusionInput, ItemStackOutput, MetallurgicInfuserRecipe>> recipes) {
        int initialSize = recipes.size();
        HashMap<MachineInput, MachineRecipe> correctRecipes = new HashMap<MachineInput, MachineRecipe>(initialSize, 1.0f);
        if (!this.config.inputReplacementMekanism) {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerInputKeyMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<MachineRecipe<InfusionInput, ItemStackOutput, MetallurgicInfuserRecipe>> infusionRecipeIterator = recipes.values().iterator();
            while (infusionRecipeIterator.hasNext()) {
                TIntSet inputKeySet;
                MachineRecipe<InfusionInput, ItemStackOutput, MetallurgicInfuserRecipe> infusionRecipe = infusionRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((InfusionInput)infusionRecipe.recipeInput).inputStack);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)infusionRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)infusionRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)infusionRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                MachineRecipe correctRecipe = infusionRecipe.copy();
                ItemStack inputStack = this.config.keepOneEntry ? (((InfusionInput)correctRecipe.recipeInput).inputStack = inputContainer.getMainEntry(((InfusionInput)correctRecipe.recipeInput).inputStack.func_190916_E())) : (((InfusionInput)correctRecipe.recipeInput).inputStack = ((InfusionInput)correctRecipe.recipeInput).inputStack.func_77946_l());
                int inputId = MetaItem.get((ItemStack)inputStack);
                if (!containerInputKeyMap.containsKey(outputContainer)) {
                    containerInputKeyMap.put(outputContainer, new TIntHashSet());
                }
                if (!(inputKeySet = (TIntSet)containerInputKeyMap.get(outputContainer)).contains(inputId)) {
                    inputKeySet.add(inputId);
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)correctRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                infusionRecipeIterator.remove();
            }
        } else {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerKindMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<MachineRecipe<InfusionInput, ItemStackOutput, MetallurgicInfuserRecipe>> infusionRecipeIterator = recipes.values().iterator();
            while (infusionRecipeIterator.hasNext()) {
                TIntSet kindSet;
                MachineRecipe<InfusionInput, ItemStackOutput, MetallurgicInfuserRecipe> mekanismRecipe = infusionRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((InfusionInput)mekanismRecipe.recipeInput).inputStack);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                int kind = inputContainer.kind;
                if (!containerKindMap.containsKey(outputContainer)) {
                    containerKindMap.put(outputContainer, new TIntHashSet());
                }
                if (!(kindSet = (TIntSet)containerKindMap.get(outputContainer)).contains(kind)) {
                    kindSet.add(kind);
                    MachineRecipe correctRecipe = mekanismRecipe.copy();
                    ((InfusionInput)correctRecipe.recipeInput).inputStack = inputContainer.getMainEntry(((InfusionInput)correctRecipe.recipeInput).inputStack.func_190916_E());
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                infusionRecipeIterator.remove();
            }
        }
        recipes.putAll(correctRecipes);
    }
}

