/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld;

import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.init.WorldHandler;
import cofh.cofhworld.init.WorldProps;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="cofhworld", name="CoFH World", version="1.0.1", dependencies="required-after:forge@[14.21.1.2388,15.0.0.0);", updateJSON="https://raw.github.com/cofh/version/master/cofhworld_update.json", acceptedMinecraftVersions="[1.12]")
public class CoFHWorld {
    public static final String MOD_ID = "cofhworld";
    public static final String MOD_NAME = "CoFH World";
    public static final String VERSION = "1.0.1";
    public static final String VERSION_MAX = "1.1.0";
    public static final String VERSION_GROUP = "required-after:cofhworld@[1.0.1,1.1.0);";
    public static final String UPDATE_URL = "https://raw.github.com/cofh/version/master/cofhworld_update.json";
    public static final String DEPENDENCIES = "required-after:forge@[14.21.1.2388,15.0.0.0);";
    @Mod.Instance(value="cofhworld")
    public static CoFHWorld instance;
    public static Logger log;
    public static Configuration config;

    public CoFHWorld() {
        WorldHandler.register();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        WorldProps.configDir = event.getModConfigurationDirectory();
        config = new Configuration(new File(WorldProps.configDir, "/cofh/world/config.cfg"), VERSION, true);
        config.load();
        WorldProps.preInit();
        WorldHandler.initialize();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        try {
            FeatureParser.parseGenerationFiles();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        config.save();
        log.info("CoFH World: Load Complete.");
    }

    static {
        log = LogManager.getLogger((String)MOD_ID);
    }
}

