/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.decoration.parser;

import cofh.cofhworld.decoration.IGeneratorParser;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.world.generator.WorldGenBoulder;
import cofh.shade.com.typesafe.config.Config;
import java.util.List;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class BoulderParser
implements IGeneratorParser {
    @Override
    public WorldGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) {
        int clusterSize = genObject.getInt("diameter");
        if (clusterSize <= 0) {
            log.warn("Invalid diameter for generator '{}'", (Object)name);
            return null;
        }
        WorldGenBoulder r = new WorldGenBoulder(resList, clusterSize, matList);
        if (genObject.hasPath("size-variance")) {
            r.sizeVariance = genObject.getInt("size-variance");
        }
        if (genObject.hasPath("count")) {
            r.clusters = genObject.getInt("count");
        }
        if (genObject.hasPath("count-variance")) {
            r.clusterVariance = genObject.getInt("count-variance");
        }
        if (genObject.hasPath("hollow")) {
            r.hollow = genObject.getBoolean("hollow");
        }
        if (genObject.hasPath("hollow-size")) {
            r.hollowAmt = (float)genObject.getDouble("hollow-size");
        }
        if (genObject.hasPath("hollow-variance")) {
            r.hollowVar = (float)genObject.getDouble("hollow-variance");
        }
        return r;
    }
}

