/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.generator;

import cofh.cofhworld.feature.generator.FeatureBase;
import cofh.cofhworld.util.Utils;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.cofhworld.world.generator.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class FeatureGenTopBlock
extends FeatureBase {
    final WorldGenerator worldGen;
    final INumberProvider count;
    final WeightedRandomBlock[] matList;

    public FeatureGenTopBlock(String name, WorldGenerator worldGen, List<WeightedRandomBlock> matList, int count, FeatureBase.GenRestriction biomeRes, boolean regen, FeatureBase.GenRestriction dimRes) {
        this(name, worldGen, matList, new ConstantProvider(count), biomeRes, regen, dimRes);
    }

    public FeatureGenTopBlock(String name, WorldGenerator worldGen, List<WeightedRandomBlock> matList, INumberProvider count, FeatureBase.GenRestriction biomeRes, boolean regen, FeatureBase.GenRestriction dimRes) {
        super(name, biomeRes, regen, dimRes);
        this.worldGen = worldGen;
        this.count = count;
        this.matList = matList.toArray(new WeightedRandomBlock[matList.size()]);
    }

    @Override
    public boolean generateFeature(Random random, int blockX, int blockZ, World world) {
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        int count = this.count.intValue(world, random, pos);
        boolean generated = false;
        for (int i = 0; i < count; ++i) {
            int y;
            IBlockState state;
            int z;
            int x = blockX + random.nextInt(16);
            if (!this.canGenerateInBiome(world, x, z = blockZ + random.nextInt(16), random) || (state = world.func_180495_p(new BlockPos(x, y = Utils.getTopBlockY(world, x, z), z))).func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)) || !WorldGenMinableCluster.canGenerateInBlock(world, x, y, z, this.matList)) continue;
            generated |= this.worldGen.func_180709_b(world, random, new BlockPos(x, y + 1, z));
        }
        return generated;
    }
}

