/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.init;

import cofh.cofhworld.CoFHWorld;
import cofh.cofhworld.biome.BiomeInfo;
import cofh.cofhworld.biome.BiomeInfoRarity;
import cofh.cofhworld.biome.BiomeInfoSet;
import cofh.cofhworld.decoration.IGeneratorParser;
import cofh.cofhworld.feature.IFeatureGenerator;
import cofh.cofhworld.feature.IFeatureParser;
import cofh.cofhworld.init.WorldHandler;
import cofh.cofhworld.init.WorldProps;
import cofh.cofhworld.util.Utils;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.WeightedRandomItemStack;
import cofh.cofhworld.util.WeightedRandomNBTTag;
import cofh.cofhworld.util.WeightedRandomWorldGenerator;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.cofhworld.util.numbers.SkellamRandomProvider;
import cofh.cofhworld.util.numbers.UniformRandomProvider;
import cofh.cofhworld.world.generator.WorldGenMulti;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigException;
import cofh.shade.com.typesafe.config.ConfigFactory;
import cofh.shade.com.typesafe.config.ConfigIncludeContext;
import cofh.shade.com.typesafe.config.ConfigIncluder;
import cofh.shade.com.typesafe.config.ConfigIncluderClasspath;
import cofh.shade.com.typesafe.config.ConfigIncluderFile;
import cofh.shade.com.typesafe.config.ConfigIncluderURL;
import cofh.shade.com.typesafe.config.ConfigList;
import cofh.shade.com.typesafe.config.ConfigObject;
import cofh.shade.com.typesafe.config.ConfigParseOptions;
import cofh.shade.com.typesafe.config.ConfigResolveOptions;
import cofh.shade.com.typesafe.config.ConfigSyntax;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.io.FilenameUtils;

public class FeatureParser {
    private static HashMap<String, IFeatureParser> templateHandlers = new HashMap();
    private static HashMap<String, IGeneratorParser> generatorHandlers = new HashMap();
    public static ArrayList<IFeatureGenerator> parsedFeatures = new ArrayList();

    private FeatureParser() {
    }

    public static boolean registerTemplate(String template, IFeatureParser handler) {
        if (!templateHandlers.containsKey(template)) {
            templateHandlers.put(template, handler);
            return true;
        }
        CoFHWorld.log.error("Attempted to register duplicate template '{}'!", (Object)template);
        return false;
    }

    public static boolean registerGenerator(String generator, IGeneratorParser handler) {
        if (!generatorHandlers.containsKey(generator)) {
            generatorHandlers.put(generator, handler);
            return true;
        }
        CoFHWorld.log.error("Attempted to register duplicate generator '{}'!", (Object)generator);
        return false;
    }

    public static void addFiles(ArrayList<File> list, File folder) {
        File o;
        AtomicInteger dirs = new AtomicInteger(0);
        File[] fList = folder.listFiles((file, name) -> {
            if (name == null) {
                return false;
            }
            if (new File(file, name).isDirectory()) {
                dirs.incrementAndGet();
                return true;
            }
            return name.toLowerCase(Locale.US).endsWith(".json");
        });
        Comparable<File> comparable = o = folder == WorldProps.worldGenDir ? folder : WorldProps.worldGenPath.relativize(Paths.get(folder.getPath(), new String[0]));
        if (fList == null || fList.length <= 0) {
            CoFHWorld.log.debug("There are no World Generation files present in {}.", (Object)o);
            return;
        }
        int d = dirs.get();
        CoFHWorld.log.info("Found {} World Generation files and {} folders present in {}.", (Object)(fList.length - d), (Object)d, (Object)o);
        list.addAll(Arrays.asList(fList));
    }

    public static void parseGenerationFiles() {
        File genFile;
        ArrayList<File> worldGenList = new ArrayList<File>(5);
        int i = 0;
        if (WorldProps.disableStandardGeneration) {
            worldGenList.add(WorldProps.standardGenFile);
            ++i;
        }
        FeatureParser.addFiles(worldGenList, WorldProps.worldGenDir);
        int e = worldGenList.size();
        while (i < e) {
            genFile = worldGenList.get(i);
            if (genFile.equals(WorldProps.standardGenFile)) {
                worldGenList.remove(i);
                break;
            }
            ++i;
        }
        for (i = 0; i < worldGenList.size(); ++i) {
            File genFile2 = worldGenList.get(i);
            if (!genFile2.isDirectory()) continue;
            worldGenList.remove(i--);
            FeatureParser.addFiles(worldGenList, genFile2);
        }
        e = worldGenList.size();
        for (i = 0; i < e; ++i) {
            Config genList;
            genFile = worldGenList.get(i);
            String file = WorldProps.worldGenPath.relativize(Paths.get(genFile.getPath(), new String[0])).toString();
            try {
                genList = ConfigFactory.parseFile(genFile, Includer.options).resolve(Includer.resolveOptions);
            }
            catch (Throwable t) {
                CoFHWorld.log.error("Critical error reading from a world generation file: \"{}\" > Please be sure the file is correct!", (Object)genFile, (Object)t);
                continue;
            }
            if (genList.hasPath("dependencies") && !FeatureParser.processDependencies(genList.getValue("dependencies"))) {
                CoFHWorld.log.info("Unmet dependencies to load {}", (Object)file);
                continue;
            }
            if (!genList.hasPath("populate")) continue;
            CoFHWorld.log.info("Reading world generation info from: {}:", (Object)file);
            Config genData = genList.getConfig("populate");
            for (Map.Entry genEntry : genData.root().entrySet()) {
                String key = (String)genEntry.getKey();
                try {
                    if (((ConfigValue)genEntry.getValue()).valueType() != ConfigValueType.OBJECT) {
                        CoFHWorld.log.error("Error parsing generation entry: '{}' > This must be an object and is not.", (Object)key);
                        continue;
                    }
                    switch (FeatureParser.parseGenerationEntry(key, genData.getConfig(key))) {
                        case SUCCESS: {
                            CoFHWorld.log.debug("Generation entry successfully parsed: '{}'", (Object)key);
                            break;
                        }
                        case FAIL: {
                            CoFHWorld.log.error("Error parsing generation entry: '{}' > Please check the parameters.", (Object)key);
                            break;
                        }
                        case PASS: {
                            CoFHWorld.log.error("Error parsing generation entry: '{}' > It is a duplicate.", (Object)key);
                        }
                    }
                }
                catch (ConfigException ex) {
                    String line = "";
                    if (ex.origin() != null) {
                        line = String.format(" on line %s", ex.origin().lineNumber());
                    }
                    CoFHWorld.log.error("Error parsing entry '{}'{}: {}", (Object)key, (Object)line, (Object)ex.getMessage());
                }
                catch (Throwable t) {
                    CoFHWorld.log.fatal("There was a severe error parsing '{}'!", (Object)key, (Object)t);
                }
            }
            CoFHWorld.log.info("Finished reading {}", (Object)file);
        }
    }

    public static boolean processDependencies(ConfigValue value) {
        if (value.valueType() == ConfigValueType.LIST) {
            ConfigList list = (ConfigList)value;
            boolean r = true;
            int e = list.size();
            for (int i = 0; i < e; ++i) {
                r &= FeatureParser.processDependency((ConfigValue)list.get(i));
            }
            return r;
        }
        return FeatureParser.processDependency(value);
    }

    public static boolean processDependency(ConfigValue value) {
        ModContainer con;
        String id;
        ArtifactVersion vers = null;
        boolean retComp = true;
        switch (value.valueType()) {
            case STRING: {
                id = (String)value.unwrapped();
                if (id.contains("@")) {
                    vers = VersionParser.parseVersionReference((String)id);
                    id = vers.getLabel();
                }
                con = (ModContainer)Loader.instance().getIndexedModList().get(id);
                break;
            }
            case OBJECT: {
                Config data = ((ConfigObject)value).toConfig();
                id = data.getString("id");
                con = (ModContainer)Loader.instance().getIndexedModList().get(id);
                if (data.hasPath("version")) {
                    vers = new DefaultArtifactVersion(id, data.getString("version"));
                }
                if (!data.hasPath("exclude")) break;
                retComp = !data.getBoolean("exclude");
                break;
            }
            default: {
                CoFHWorld.log.fatal("Invalid dependency at line {}!", (Object)value.origin().lineNumber());
                return false;
            }
        }
        if (con == null && (con = WorldHandler.getLoadedAPIs().get(id)) == null) {
            CoFHWorld.log.debug("Dependency '{}' is not loaded.", (Object)id);
            return false == retComp;
        }
        LoaderState.ModState state = Loader.instance().getModState(con);
        if (state == LoaderState.ModState.DISABLED || state == LoaderState.ModState.ERRORED) {
            CoFHWorld.log.debug("Dependency '{}' is disabled or crashed.", (Object)id);
            return false == retComp;
        }
        if (vers != null) {
            if (retComp != vers.containsVersion(con.getProcessedVersion())) {
                CoFHWorld.log.debug("Dependency '{}' has an incompatible version.", (Object)id);
                return false;
            }
            return true;
        }
        return true == retComp;
    }

    public static EnumActionResult parseGenerationEntry(String featureName, Config genObject) {
        if (genObject.hasPath("enabled") && !genObject.getBoolean("enabled")) {
            CoFHWorld.log.info('\"' + featureName + "\" is disabled.");
            return EnumActionResult.SUCCESS;
        }
        String templateName = FeatureParser.parseTemplate(genObject);
        IFeatureParser template = templateHandlers.get(templateName);
        if (template != null) {
            IFeatureGenerator feature = template.parseFeature(featureName, genObject, CoFHWorld.log);
            if (feature != null) {
                parsedFeatures.add(feature);
                return WorldHandler.registerFeature(feature) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
            CoFHWorld.log.warn("Template '" + templateName + "' failed to parse its entry!");
        } else {
            CoFHWorld.log.warn("Unknown template + '" + templateName + "'.");
        }
        return EnumActionResult.FAIL;
    }

    public static String parseTemplate(Config genObject) {
        return genObject.getString("distribution");
    }

    public static WorldGenerator parseGenerator(String def, Config genObject, List<WeightedRandomBlock> defaultMaterial) {
        if (!genObject.hasPath("generator")) {
            return null;
        }
        ConfigValue genData = genObject.root().get("generator");
        if (genData.valueType() == ConfigValueType.LIST) {
            List<? extends Config> list = genObject.getConfigList("generator");
            ArrayList<WeightedRandomWorldGenerator> gens = new ArrayList<WeightedRandomWorldGenerator>(list.size());
            for (Config config : list) {
                WorldGenerator gen = FeatureParser.parseGeneratorData(def, config, defaultMaterial);
                int weight = config.hasPath("weight") ? config.getInt("weight") : 100;
                gens.add(new WeightedRandomWorldGenerator(gen, weight));
            }
            return new WorldGenMulti(gens);
        }
        if (genData.valueType() == ConfigValueType.OBJECT) {
            return FeatureParser.parseGeneratorData(def, genObject.getConfig("generator"), defaultMaterial);
        }
        CoFHWorld.log.error("Invalid data type for field 'generator'. > It must be an object or list.");
        return null;
    }

    public static WorldGenerator parseGeneratorData(String def, Config genObject, List<WeightedRandomBlock> defaultMaterial) {
        IGeneratorParser parser;
        String name = def;
        if (genObject.hasPath("type") && !generatorHandlers.containsKey(name = genObject.getString("type"))) {
            CoFHWorld.log.warn("Unknown generator '{}'! using '{}'", (Object)name, (Object)def);
            name = def;
        }
        ArrayList<WeightedRandomBlock> resList = new ArrayList<WeightedRandomBlock>();
        if (!FeatureParser.parseResList(genObject.getValue("block"), resList, true)) {
            return null;
        }
        List<WeightedRandomBlock> matList = defaultMaterial;
        matList = new ArrayList<WeightedRandomBlock>();
        if (!FeatureParser.parseResList(genObject.root().get("material"), matList, false)) {
            CoFHWorld.log.warn("Invalid material list! Using default list.");
            matList = defaultMaterial;
        }
        if ((parser = generatorHandlers.get(name)) == null) {
            throw new IllegalStateException("Generator '" + name + "' is not registered!");
        }
        return parser.parseGenerator(name, genObject, CoFHWorld.log, resList, matList);
    }

    public static BiomeInfoSet parseBiomeRestrictions(Config genObject) {
        BiomeInfoSet set;
        ConfigValue data = genObject.getValue("value");
        if (data.valueType() == ConfigValueType.LIST) {
            ConfigList restrictionList = (ConfigList)data;
            set = new BiomeInfoSet(restrictionList.size());
            int e = restrictionList.size();
            for (int i = 0; i < e; ++i) {
                BiomeInfo info = FeatureParser.parseBiomeData((ConfigValue)restrictionList.get(i));
                if (info == null) continue;
                set.add(info);
            }
        } else {
            set = new BiomeInfoSet(1);
            BiomeInfo info = FeatureParser.parseBiomeData(data);
            if (info != null) {
                set.add(info);
            }
        }
        return set;
    }

    public static BiomeInfo parseBiomeData(ConfigValue element) {
        BiomeInfo info = null;
        switch (element.valueType()) {
            case NULL: {
                CoFHWorld.log.info("Null biome entry. Ignoring.");
                break;
            }
            case OBJECT: {
                int t;
                Object data;
                int rarity;
                Config obj = ((ConfigObject)element).toConfig();
                String type = obj.getString("type");
                boolean wl = !obj.hasPath("whitelist") || obj.getBoolean("whitelist");
                ConfigValue value = obj.root().get("entry");
                List<String> array = value.valueType() == ConfigValueType.LIST ? obj.getStringList("entry") : null;
                String entry = array != null ? null : (String)value.unwrapped();
                int n = rarity = obj.hasPath("rarity") ? obj.getInt("rarity") : -1;
                if (type.equalsIgnoreCase("name")) {
                    if (array != null) {
                        List<String> names = array;
                        if (rarity > 0) {
                            info = new BiomeInfoRarity(names, 4, true, rarity);
                            break;
                        }
                        info = new BiomeInfo(names, 4, true);
                        break;
                    }
                    if (rarity > 0) {
                        info = new BiomeInfoRarity(entry, rarity);
                        break;
                    }
                    info = new BiomeInfo(entry);
                    break;
                }
                if (type.equalsIgnoreCase("dictionary")) {
                    if (array != null) {
                        ArrayList<BiomeDictionary.Type> tags = new ArrayList<BiomeDictionary.Type>(array.size());
                        int j = array.size();
                        for (int k = 0; k < j; ++k) {
                            tags.add(BiomeDictionary.Type.getType((String)array.get(k), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
                        }
                        data = tags.toArray(new BiomeDictionary.Type[tags.size()]);
                        t = 6;
                    } else {
                        data = BiomeDictionary.Type.getType((String)entry, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                        t = 2;
                    }
                } else if (type.equalsIgnoreCase("id")) {
                    if (array != null) {
                        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(array.size());
                        int j = array.size();
                        for (int k = 0; k < j; ++k) {
                            ids.add(new ResourceLocation(array.get(k)));
                        }
                        data = ids;
                        t = 8;
                    } else {
                        data = new ResourceLocation(entry);
                        t = 7;
                    }
                } else if (type.equalsIgnoreCase("temperature")) {
                    if (array != null) {
                        ArrayList<Biome.TempCategory> temps = new ArrayList<Biome.TempCategory>(array.size());
                        int j = array.size();
                        for (int k = 0; k < j; ++k) {
                            temps.add(Biome.TempCategory.valueOf((String)array.get(k)));
                        }
                        data = EnumSet.copyOf(temps);
                        t = 5;
                    } else {
                        data = Biome.TempCategory.valueOf((String)entry);
                        t = 1;
                    }
                } else {
                    CoFHWorld.log.warn("Biome entry of unknown type");
                    break;
                }
                if (data == null) break;
                if (rarity > 0) {
                    info = new BiomeInfoRarity(data, t, wl, rarity);
                    break;
                }
                info = new BiomeInfo(data, t, wl);
                break;
            }
            case STRING: {
                info = new BiomeInfo((String)element.unwrapped());
                break;
            }
            default: {
                CoFHWorld.log.error("Unknown biome type in at line {}", (Object)element.origin().lineNumber());
            }
        }
        return info;
    }

    public static Block parseBlockName(String blockRaw) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockRaw));
    }

    public static WeightedRandomBlock parseBlockEntry(ConfigValue genElement, boolean clamp) {
        int min = clamp ? 0 : -1;
        switch (genElement.valueType()) {
            case NULL: {
                CoFHWorld.log.warn("Null Block entry!");
                return null;
            }
            case OBJECT: {
                int weight;
                Config blockElement = ((ConfigObject)genElement).toConfig();
                if (!blockElement.hasPath("name")) {
                    CoFHWorld.log.error("Block entry needs a name!");
                    return null;
                }
                String blockName = blockElement.getString("name");
                Block block = FeatureParser.parseBlockName(blockName);
                if (block == Blocks.field_150350_a && !blockName.equalsIgnoreCase("minecraft:air")) {
                    CoFHWorld.log.error("Invalid block entry!");
                    return null;
                }
                int n = weight = blockElement.hasPath("weight") ? MathHelper.func_76125_a((int)blockElement.getInt("weight"), (int)1, (int)1000000) : 100;
                if (blockElement.hasPath("properties")) {
                    BlockStateContainer blockstatecontainer = block.func_176194_O();
                    IBlockState state = block.func_176223_P();
                    for (Map.Entry propEntry : blockElement.getObject("properties").entrySet()) {
                        IProperty prop = blockstatecontainer.func_185920_a((String)propEntry.getKey());
                        if (prop == null) {
                            CoFHWorld.log.warn("Block '{}' does not have property '{}'.", (Object)blockName, propEntry.getKey());
                        }
                        if (((ConfigValue)propEntry.getValue()).valueType() != ConfigValueType.STRING) {
                            CoFHWorld.log.error("Property '{}' is not a string. All block properties must be strings.", propEntry.getKey());
                            prop = null;
                        }
                        if (prop == null) continue;
                        state = FeatureParser.setValue(state, prop, (String)((ConfigValue)propEntry.getValue()).unwrapped());
                    }
                    return new WeightedRandomBlock(state, weight);
                }
                int metadata = blockElement.hasPath("data") ? MathHelper.func_76125_a((int)blockElement.getInt("data"), (int)min, (int)15) : (blockElement.hasPath("metadata") ? MathHelper.func_76125_a((int)blockElement.getInt("metadata"), (int)min, (int)15) : min);
                return new WeightedRandomBlock(block, metadata, weight);
            }
            case STRING: {
                String name = (String)genElement.unwrapped();
                Block block = FeatureParser.parseBlockName(name);
                if (block == Blocks.field_150350_a && !name.equalsIgnoreCase("minecraft:air")) {
                    CoFHWorld.log.error("Invalid block entry!");
                    return null;
                }
                return new WeightedRandomBlock(block, min);
            }
        }
        return null;
    }

    private static <T extends Comparable<T>> IBlockState setValue(IBlockState state, IProperty<T> prop, String val) {
        return state.func_177226_a(prop, (Comparable)prop.func_185929_b(val).get());
    }

    public static boolean parseResList(ConfigValue genElement, List<WeightedRandomBlock> resList, boolean clamp) {
        if (genElement == null) {
            return false;
        }
        if (genElement.valueType() == ConfigValueType.LIST) {
            ConfigList blockList = (ConfigList)genElement;
            int e = blockList.size();
            for (int i = 0; i < e; ++i) {
                WeightedRandomBlock entry = FeatureParser.parseBlockEntry((ConfigValue)blockList.get(i), clamp);
                if (entry == null) {
                    return false;
                }
                resList.add(entry);
            }
        } else {
            if (genElement.valueType() == ConfigValueType.NULL) {
                return true;
            }
            WeightedRandomBlock entry = FeatureParser.parseBlockEntry(genElement, clamp);
            if (entry == null) {
                return false;
            }
            resList.add(entry);
        }
        return true;
    }

    public static WeightedRandomNBTTag parseEntityEntry(ConfigValue genElement) {
        switch (genElement.valueType()) {
            case NULL: {
                CoFHWorld.log.warn("Null entity entry!");
                return null;
            }
            case OBJECT: {
                NBTTagCompound data;
                Config genObject = ((ConfigObject)genElement).toConfig();
                if (genObject.hasPath("spawner-tag")) {
                    try {
                        data = JsonToNBT.func_180713_a((String)genObject.getString("spawner-tag"));
                    }
                    catch (NBTException e) {
                        CoFHWorld.log.error("Invalid entity entry at line {}!", (Object)genElement.origin().lineNumber(), (Object)e);
                        return null;
                    }
                } else {
                    if (!genObject.hasPath("entity")) {
                        CoFHWorld.log.error("Invalid entity entry at line {}!", (Object)genElement.origin().lineNumber());
                        return null;
                    }
                    data = new NBTTagCompound();
                    String type = genObject.getString("entity");
                    data.func_74778_a("EntityId", type);
                }
                int weight = genObject.hasPath("weight") ? genObject.getInt("weight") : 100;
                return new WeightedRandomNBTTag(weight, (NBTBase)data);
            }
            case STRING: {
                String type = (String)genElement.unwrapped();
                if (type == null) {
                    CoFHWorld.log.error("Invalid entity entry!");
                    return null;
                }
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("EntityId", type);
                return new WeightedRandomNBTTag(100, (NBTBase)tag);
            }
        }
        CoFHWorld.log.warn("Invalid entity entry type at line {}", (Object)genElement.origin().lineNumber());
        return null;
    }

    public static boolean parseEntityList(ConfigValue genElement, List<WeightedRandomNBTTag> list) {
        if (genElement.valueType() == ConfigValueType.LIST) {
            ConfigList blockList = (ConfigList)genElement;
            int e = blockList.size();
            for (int i = 0; i < e; ++i) {
                WeightedRandomNBTTag entry = FeatureParser.parseEntityEntry((ConfigValue)blockList.get(i));
                if (entry == null) {
                    return false;
                }
                list.add(entry);
            }
        } else {
            WeightedRandomNBTTag entry = FeatureParser.parseEntityEntry(genElement);
            if (entry == null) {
                return false;
            }
            list.add(entry);
        }
        return true;
    }

    public static DungeonHooks.DungeonMob parseWeightedStringEntry(ConfigValue genElement) {
        int weight = 100;
        String type = null;
        switch (genElement.valueType()) {
            case LIST: {
                CoFHWorld.log.warn("Lists are not supported for string values at line {}.", (Object)genElement.origin().lineNumber());
                return null;
            }
            case NULL: {
                CoFHWorld.log.warn("Null string entry at line {}", (Object)genElement.origin().lineNumber());
                return null;
            }
            case OBJECT: {
                Config genObject = ((ConfigObject)genElement).toConfig();
                if (genObject.hasPath("type")) {
                    type = genObject.getString("name");
                } else {
                    CoFHWorld.log.warn("Value missing 'type' field at line {}", (Object)genElement.origin().lineNumber());
                }
                if (!genObject.hasPath("weight")) break;
                weight = genObject.getInt("weight");
                break;
            }
            case STRING: 
            case BOOLEAN: 
            case NUMBER: {
                type = String.valueOf(genElement.unwrapped());
            }
        }
        return new DungeonHooks.DungeonMob(weight, new ResourceLocation(type));
    }

    public static boolean parseWeightedStringList(ConfigValue genElement, List<DungeonHooks.DungeonMob> list) {
        if (genElement.valueType() == ConfigValueType.LIST) {
            ConfigList blockList = (ConfigList)genElement;
            int e = blockList.size();
            for (int i = 0; i < e; ++i) {
                DungeonHooks.DungeonMob entry = FeatureParser.parseWeightedStringEntry((ConfigValue)blockList.get(i));
                if (entry == null) {
                    return false;
                }
                list.add(entry);
            }
        } else {
            DungeonHooks.DungeonMob entry = FeatureParser.parseWeightedStringEntry(genElement);
            if (entry == null) {
                return false;
            }
            list.add(entry);
        }
        return true;
    }

    public static WeightedRandomItemStack parseWeightedRandomItem(ConfigValue genElement) {
        ItemStack stack;
        if (genElement.valueType() == ConfigValueType.NULL) {
            return null;
        }
        int metadata = 0;
        int stackSize = 1;
        int chance = 100;
        if (genElement.valueType() != ConfigValueType.OBJECT) {
            stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(String.valueOf(genElement.unwrapped()))), 1, metadata);
        } else {
            Config item = ((ConfigObject)genElement).toConfig();
            if (item.hasPath("metadata")) {
                metadata = item.getInt("metadata");
            }
            if (item.hasPath("count")) {
                stackSize = item.getInt("count");
            } else if (item.hasPath("stack-size")) {
                stackSize = item.getInt("stack-size");
            } else if (item.hasPath("amount")) {
                stackSize = item.getInt("amount");
            }
            if (stackSize <= 0) {
                stackSize = 1;
            }
            if (item.hasPath("weight")) {
                chance = item.getInt("weight");
            }
            if (item.hasPath("ore-name")) {
                String oreName = item.getString("ore-name");
                if (!Utils.oreNameExists(oreName)) {
                    CoFHWorld.log.error("Invalid ore name for item at line {}!", (Object)genElement.origin().lineNumber());
                    return null;
                }
                ItemStack oreStack = (ItemStack)OreDictionary.getOres((String)oreName, (boolean)false).get(0);
                stack = Utils.cloneStack(oreStack, stackSize);
            } else {
                if (!item.hasPath("name")) {
                    CoFHWorld.log.error("Item entry missing valid name or ore name at line {}!", (Object)genElement.origin().lineNumber());
                    return null;
                }
                stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item.getString("name"))), stackSize, metadata);
            }
            if (item.hasPath("nbt")) {
                try {
                    NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)item.getString("nbt"));
                    stack.func_77982_d(nbtbase);
                }
                catch (NBTException t) {
                    CoFHWorld.log.error("Item has invalid NBT data.", (Throwable)t);
                }
            }
        }
        return new WeightedRandomItemStack(stack, chance);
    }

    public static boolean parseWeightedItemList(ConfigValue genElement, List<WeightedRandomItemStack> res) {
        if (genElement.valueType() != ConfigValueType.LIST) {
            WeightedRandomItemStack entry = FeatureParser.parseWeightedRandomItem(genElement);
            if (entry == null) {
                return false;
            }
            res.add(entry);
        } else {
            ConfigList list = (ConfigList)genElement;
            int e = list.size();
            for (int i = 0; i < e; ++i) {
                WeightedRandomItemStack entry = FeatureParser.parseWeightedRandomItem((ConfigValue)list.get(i));
                if (entry == null) {
                    return false;
                }
                res.add(entry);
            }
        }
        return true;
    }

    public static INumberProvider parseNumberValue(ConfigValue genElement) {
        return FeatureParser.parseNumberValue(genElement, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static INumberProvider parseNumberValue(ConfigValue genElement, long min, long max) {
        switch (genElement.valueType()) {
            case NUMBER: {
                return new ConstantProvider(FeatureParser.boundCheck((Number)genElement.unwrapped(), min, max));
            }
            case OBJECT: {
                ConfigObject genData = (ConfigObject)genElement;
                Config genProp = genData.toConfig();
                switch (genData.size()) {
                    case 1: {
                        if (genData.containsKey("value")) {
                            return new ConstantProvider(FeatureParser.boundCheck(genProp.getNumber("value"), min, max));
                        }
                        if (!genData.containsKey("variance")) break;
                        return new SkellamRandomProvider(FeatureParser.boundCheck(genProp.getNumber("variance"), min, max));
                    }
                    case 2: {
                        if (!genData.containsKey("min") || !genData.containsKey("max")) break;
                        return new UniformRandomProvider(FeatureParser.boundCheck(genProp.getNumber("min"), min, max), FeatureParser.boundCheck(genProp.getNumber("max"), min, max));
                    }
                    default: {
                        throw new Error(String.format("Too many properties on object at line %s", genElement.origin().lineNumber()));
                    }
                    case 0: 
                }
                throw new Error(String.format("Unknown properties on object at line %s", genElement.origin().lineNumber()));
            }
        }
        throw new Error(String.format("Unsupported data type at line %s", genElement.origin().lineNumber()));
    }

    public static Number boundCheck(Number value, long min, long max) {
        if (value.longValue() >= min) {
            if (value.longValue() <= max) {
                return value;
            }
            return new Long(max);
        }
        return new Long(min);
    }

    public static class Includer
    implements ConfigIncluder,
    ConfigIncluderClasspath,
    ConfigIncluderFile,
    ConfigIncluderURL {
        public static Includer includer = new Includer();
        public static ConfigParseOptions options = ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF).setIncluder(includer);
        public static ConfigResolveOptions resolveOptions = ConfigResolveOptions.noSystem();

        @Override
        public ConfigIncluder withFallback(ConfigIncluder fallback) {
            return this;
        }

        @Override
        public ConfigObject include(ConfigIncludeContext context, String what) {
            return this.includeFile(context, new File(what));
        }

        @Override
        public ConfigObject includeFile(ConfigIncludeContext context, File file) {
            try {
                if (!FilenameUtils.directoryContains((String)WorldProps.worldGenDir.getCanonicalPath(), (String)file.getCanonicalPath())) {
                    return null;
                }
            }
            catch (IOException e) {
                return null;
            }
            return ConfigFactory.parseFileAnySyntax(file, context.parseOptions()).root();
        }

        @Override
        public ConfigObject includeResources(ConfigIncludeContext context, String what) {
            throw new IllegalArgumentException("Cannot include resources!");
        }

        @Override
        public ConfigObject includeURL(ConfigIncludeContext context, URL what) {
            throw new IllegalArgumentException("Cannot include URLs!");
        }
    }
}

