/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.cofhworld.world.generator.WorldGenMinableCluster;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenAdvLakes
extends WorldGenerator {
    private static final List<WeightedRandomBlock> GAP_BLOCK = Arrays.asList(new WeightedRandomBlock(Blocks.field_150350_a, 0));
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    private List<WeightedRandomBlock> outlineBlock = null;
    private List<WeightedRandomBlock> gapBlock = GAP_BLOCK;
    private boolean solidOutline = false;
    private boolean totalOutline = false;
    private INumberProvider width;
    private INumberProvider height;

    public WorldGenAdvLakes(List<WeightedRandomBlock> resource, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.genBlock = block == null ? null : block.toArray(new WeightedRandomBlock[block.size()]);
        this.setWidth(16);
        this.setHeight(9);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int y;
        int x;
        int yStart;
        int xStart = pos.func_177958_n();
        int zStart = pos.func_177952_p();
        int width = this.width.intValue(world, rand, pos);
        int height = this.height.intValue(world, rand, pos);
        int widthOff = width / 2;
        int heightOff = height / 2 + 1;
        xStart -= widthOff;
        zStart -= widthOff;
        for (yStart = pos.func_177956_o(); yStart > heightOff && world.func_175623_d(new BlockPos(xStart, yStart, zStart)); --yStart) {
        }
        if (yStart <= --heightOff) {
            return false;
        }
        yStart -= heightOff;
        boolean[] spawnBlock = new boolean[width * width * height];
        int W = width - 1;
        int H = height - 1;
        int e = rand.nextInt(4) + 4;
        for (int i = 0; i < e; ++i) {
            double xSize = rand.nextDouble() * 6.0 + 3.0;
            double ySize = rand.nextDouble() * 4.0 + 2.0;
            double zSize = rand.nextDouble() * 6.0 + 3.0;
            double xCenter = rand.nextDouble() * ((double)width - xSize - 2.0) + 1.0 + xSize / 2.0;
            double yCenter = rand.nextDouble() * ((double)height - ySize - 4.0) + 2.0 + ySize / 2.0;
            double zCenter = rand.nextDouble() * ((double)width - zSize - 2.0) + 1.0 + zSize / 2.0;
            for (int x2 = 1; x2 < W; ++x2) {
                for (int z = 1; z < W; ++z) {
                    for (int y2 = 1; y2 < H; ++y2) {
                        double xDist = ((double)x2 - xCenter) / (xSize / 2.0);
                        double yDist = ((double)y2 - yCenter) / (ySize / 2.0);
                        double zDist = ((double)z - zCenter) / (zSize / 2.0);
                        double dist = xDist * xDist + yDist * yDist + zDist * zDist;
                        if (!(dist < 1.0)) continue;
                        spawnBlock[(x2 * width + z) * height + y2] = true;
                    }
                }
            }
        }
        for (x = 0; x < width; ++x) {
            for (int z = 0; z < width; ++z) {
                for (y = 0; y < height; ++y) {
                    Material material;
                    boolean flag;
                    boolean bl = flag = spawnBlock[(x * width + z) * height + y] || x < W && spawnBlock[((x + 1) * width + z) * height + y] || x > 0 && spawnBlock[((x - 1) * width + z) * height + y] || z < W && spawnBlock[(x * width + (z + 1)) * height + y] || z > 0 && spawnBlock[(x * width + (z - 1)) * height + y] || y < H && spawnBlock[(x * width + z) * height + (y + 1)] || y > 0 && spawnBlock[(x * width + z) * height + (y - 1)];
                    if (!flag || !(y >= heightOff ? (material = world.func_180495_p(new BlockPos(xStart + x, yStart + y, zStart + z)).func_185904_a()).func_76224_d() : !WorldGenMinableCluster.canGenerateInBlock(world, xStart + x, yStart + y, zStart + z, this.genBlock))) continue;
                    return false;
                }
            }
        }
        for (x = 0; x < width; ++x) {
            for (int z = 0; z < width; ++z) {
                for (y = 0; y < height; ++y) {
                    if (!spawnBlock[(x * width + z) * height + y]) continue;
                    if (y < heightOff) {
                        WorldGenMinableCluster.generateBlock(world, xStart + x, yStart + y, zStart + z, this.genBlock, this.cluster);
                        continue;
                    }
                    if (!WorldGenMinableCluster.canGenerateInBlock(world, xStart + x, yStart + y, zStart + z, this.genBlock)) continue;
                    WorldGenMinableCluster.generateBlock(world, xStart + x, yStart + y, zStart + z, this.gapBlock);
                }
            }
        }
        for (x = 0; x < width; ++x) {
            for (int z = 0; z < width; ++z) {
                for (y = 0; y < height; ++y) {
                    if (!spawnBlock[(x * width + z) * height + y] || !world.func_180495_p(new BlockPos(xStart + x, yStart + y - 1, zStart + z)).func_177230_c().equals(Blocks.field_150346_d) || world.func_175642_b(EnumSkyBlock.SKY, new BlockPos(xStart + x, yStart + y, zStart + z)) <= 0) continue;
                    Biome bgb = world.func_180494_b(new BlockPos(xStart + x, 0, zStart + z));
                    world.func_180501_a(new BlockPos(xStart + x, yStart + y - 1, zStart + z), bgb.field_76752_A, 2);
                }
            }
        }
        if (this.outlineBlock != null) {
            for (x = 0; x < width; ++x) {
                for (int z = 0; z < width; ++z) {
                    for (y = 0; y < height; ++y) {
                        boolean flag;
                        boolean bl = flag = !spawnBlock[(x * width + z) * height + y] && (x < W && spawnBlock[((x + 1) * width + z) * height + y] || x > 0 && spawnBlock[((x - 1) * width + z) * height + y] || z < W && spawnBlock[(x * width + (z + 1)) * height + y] || z > 0 && spawnBlock[(x * width + (z - 1)) * height + y] || y < H && spawnBlock[(x * width + z) * height + (y + 1)] || y > 0 && spawnBlock[(x * width + z) * height + (y - 1)]);
                        if (!flag || !(this.solidOutline | y < heightOff) && rand.nextInt(2) == 0 || !this.totalOutline && !world.func_180495_p(new BlockPos(xStart + x, yStart + y, zStart + z)).func_185904_a().func_76220_a()) continue;
                        WorldGenMinableCluster.generateBlock(world, xStart + x, yStart + y, zStart + z, this.outlineBlock);
                    }
                }
            }
        }
        return true;
    }

    public WorldGenAdvLakes setWidth(int width) {
        this.width = new ConstantProvider(width);
        return this;
    }

    public WorldGenAdvLakes setWidth(INumberProvider width) {
        this.width = width;
        return this;
    }

    public WorldGenAdvLakes setHeight(int height) {
        this.height = new ConstantProvider(height);
        return this;
    }

    public WorldGenAdvLakes setHeight(INumberProvider height) {
        this.height = height;
        return this;
    }

    public WorldGenAdvLakes setSolidOutline(boolean outline) {
        this.solidOutline = outline;
        return this;
    }

    public WorldGenAdvLakes setTotalOutline(boolean outline) {
        this.totalOutline = outline;
        return this;
    }

    public WorldGenAdvLakes setOutlineBlock(List<WeightedRandomBlock> blocks) {
        this.outlineBlock = blocks;
        return this;
    }

    public WorldGenAdvLakes setGapBlock(List<WeightedRandomBlock> blocks) {
        this.gapBlock = blocks;
        return this;
    }
}

