/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.cofhworld.util.numbers.SkellamRandomProvider;
import cofh.cofhworld.world.generator.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenDecoration
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    private final WeightedRandomBlock[] onBlock;
    private final INumberProvider clusterSize;
    private boolean seeSky = true;
    private boolean checkStay = true;
    private INumberProvider stackHeight;
    private INumberProvider xVar;
    private INumberProvider yVar;
    private INumberProvider zVar;

    public WorldGenDecoration(List<WeightedRandomBlock> blocks, int count, List<WeightedRandomBlock> material, List<WeightedRandomBlock> on) {
        this(blocks, new ConstantProvider(count), material, on);
    }

    public WorldGenDecoration(List<WeightedRandomBlock> blocks, INumberProvider count, List<WeightedRandomBlock> material, List<WeightedRandomBlock> on) {
        this.cluster = blocks;
        this.clusterSize = count;
        this.genBlock = material == null ? null : material.toArray(new WeightedRandomBlock[material.size()]);
        this.onBlock = on == null ? null : on.toArray(new WeightedRandomBlock[on.size()]);
        this.setStackHeight(1);
        this.setXVar(new SkellamRandomProvider(8));
        this.setYVar(new SkellamRandomProvider(4));
        this.setZVar(new SkellamRandomProvider(8));
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int xStart = pos.func_177958_n();
        int yStart = pos.func_177956_o();
        int zStart = pos.func_177952_p();
        int clusterSize = this.clusterSize.intValue(world, rand, pos);
        boolean r = false;
        int l = clusterSize;
        block0: while (l-- > 0) {
            int z;
            int y;
            int x = xStart + this.xVar.intValue(world, rand, pos);
            if (!world.func_175667_e(new BlockPos(x, y = yStart + this.yVar.intValue(world, rand, pos), z = zStart + this.zVar.intValue(world, rand, pos)))) {
                ++l;
                continue;
            }
            if (this.seeSky && !world.func_175678_i(new BlockPos(x, y, z)) || !WorldGenMinableCluster.canGenerateInBlock(world, x, y - 1, z, this.onBlock) || !WorldGenMinableCluster.canGenerateInBlock(world, x, y, z, this.genBlock)) continue;
            WeightedRandomBlock block = WorldGenMinableCluster.selectBlock(world, this.cluster);
            int stack = this.stackHeight.intValue(world, rand, pos);
            while (!this.checkStay) {
                r |= world.func_180501_a(new BlockPos(x, y, z), block.getState(), 2);
                if (WorldGenMinableCluster.canGenerateInBlock(world, x, ++y, z, this.genBlock) && --stack > 0) continue;
                continue block0;
            }
        }
        return r;
    }

    public WorldGenDecoration setSeeSky(boolean seeSky) {
        this.seeSky = seeSky;
        return this;
    }

    public WorldGenDecoration setCheckStay(boolean checkStay) {
        this.checkStay = checkStay;
        return this;
    }

    public WorldGenDecoration setStackHeight(int stackHeight) {
        return this.setStackHeight(new ConstantProvider(stackHeight));
    }

    public WorldGenDecoration setStackHeight(INumberProvider stackHeight) {
        this.stackHeight = stackHeight;
        return this;
    }

    public WorldGenDecoration setXVar(int xVar) {
        return this.setXVar(new ConstantProvider(xVar));
    }

    public WorldGenDecoration setXVar(INumberProvider xVar) {
        this.xVar = xVar;
        return this;
    }

    public WorldGenDecoration setYVar(int yVar) {
        return this.setYVar(new ConstantProvider(yVar));
    }

    public WorldGenDecoration setYVar(INumberProvider yVar) {
        this.yVar = yVar;
        return this;
    }

    public WorldGenDecoration setZVar(int zVar) {
        return this.setZVar(new ConstantProvider(zVar));
    }

    public WorldGenDecoration setZVar(INumberProvider zVar) {
        this.zVar = zVar;
        return this;
    }
}

