/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.world.generator.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenStalagmite
extends WorldGenerator {
    protected final List<WeightedRandomBlock> cluster;
    protected final WeightedRandomBlock[] baseBlock;
    protected final WeightedRandomBlock[] genBlock;
    public int minHeight = 7;
    public int heightVariance = 4;
    public int sizeVariance = 2;
    public int heightMod = 5;
    public int genSize = 0;
    public boolean smooth = false;
    public boolean fat = true;
    public boolean altSinc = false;

    public WorldGenStalagmite(List<WeightedRandomBlock> resource, List<WeightedRandomBlock> block, List<WeightedRandomBlock> gblock) {
        this.cluster = resource;
        this.baseBlock = block.toArray(new WeightedRandomBlock[block.size()]);
        this.genBlock = gblock.toArray(new WeightedRandomBlock[gblock.size()]);
    }

    protected int getHeight(int x, int z, int size, Random rand, int height) {
        int dist;
        int absz;
        if (this.smooth) {
            if ((x * x + z * z) * 4 >= size * size * 5) {
                return 0;
            }
            double lim = (this.altSinc ? 600.0f : (this.fat ? 1.0f : 0.5f) * 400.0f) / (float)size;
            double pi = Math.PI;
            double r = (double)x * lim / Math.PI;
            double d = r * r;
            r = (double)z * lim / Math.PI;
            r = Math.sqrt(d + r * r) * Math.PI / 180.0;
            if (this.altSinc && r < 1.0) {
                r = Math.sqrt((double)(size * 2) * lim / Math.PI) * Math.PI / 180.0;
            }
            if (r == 0.0) {
                return height;
            }
            if (!this.altSinc) {
                return (int)Math.round((double)height * (this.fat ? Math.sin(r) / r : Math.sin(r *= Math.PI) / r));
            }
            double sinc = Math.sin(r) / r;
            return (int)Math.round((double)height * (sinc * 2.0 + Math.sin(r *= Math.PI * 4) / r) / 2.0 + rand.nextGaussian() * 0.75);
        }
        int absx = x < 0 ? -x : x;
        int n = absz = z < 0 ? -z : z;
        int n2 = this.fat ? (absx < absz ? absz + absx / 2 : absx + absz / 2) : (dist = absx + absz);
        if (dist == 0) {
            return height;
        }
        int v = 1 + height / dist;
        return v > 1 ? rand.nextInt(v) : 0;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int size;
        int yStart;
        int xStart = pos.func_177958_n();
        int zStart = pos.func_177952_p();
        for (yStart = pos.func_177956_o(); world.func_175623_d(new BlockPos(xStart, yStart, zStart)) && yStart > 0; --yStart) {
        }
        if (!WorldGenMinableCluster.canGenerateInBlock(world, xStart, yStart++, zStart, this.baseBlock)) {
            return false;
        }
        int maxHeight = (this.heightVariance > 0 ? rand.nextInt(this.heightVariance) : 0) + this.minHeight;
        int n = size = this.genSize > 0 ? this.genSize : maxHeight / this.heightMod;
        if (this.sizeVariance > 0) {
            size += rand.nextInt(this.sizeVariance);
        }
        boolean r = false;
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                if (!WorldGenMinableCluster.canGenerateInBlock(world, xStart + x, yStart - 1, zStart + z, this.baseBlock)) continue;
                int height = this.getHeight(x, z, size, rand, maxHeight);
                for (int y = 0; y < height; ++y) {
                    r |= WorldGenMinableCluster.generateBlock(world, xStart + x, yStart + y, zStart + z, this.genBlock, this.cluster);
                }
            }
        }
        return r;
    }
}

