/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.feature;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import journeymap.client.feature.Feature;
import journeymap.client.feature.Policy;
import journeymap.client.feature.impl.Unlimited;
import journeymap.common.Journeymap;
import journeymap.server.properties.PermissionProperties;

public class FeatureManager {
    private final PolicySet policySet;
    private final HashMap<Feature, Policy> policyMap = new HashMap();
    private final HashMap<String, EnumSet<Feature>> disableControlCodes = new HashMap();
    private Boolean controlCodeAltered = null;

    private FeatureManager() {
        this.disableControlCodes.put("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7e", Feature.radar());
        this.disableControlCodes.put("\u00a73\u00a76\u00a73\u00a76\u00a73\u00a76\u00a7e", Feature.radar());
        this.disableControlCodes.put("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7d", EnumSet.of(Feature.MapCaves));
        this.disableControlCodes.put("\u00a73\u00a76\u00a73\u00a76\u00a73\u00a76\u00a7d", EnumSet.of(Feature.MapCaves));
        this.policySet = new Unlimited();
        this.reset();
    }

    public static String getPolicyDetails() {
        StringBuilder sb = new StringBuilder(String.format("%s Features: ", FeatureManager.getPolicySetName()));
        for (Feature feature : Feature.values()) {
            boolean single = false;
            boolean multi = false;
            if (Holder.INSTANCE.policyMap.containsKey((Object)feature)) {
                single = Holder.INSTANCE.policyMap.get((Object)((Object)feature)).allowInSingleplayer;
                multi = Holder.INSTANCE.policyMap.get((Object)((Object)feature)).allowInMultiplayer;
            }
            sb.append(String.format("\n\t%s : singleplayer = %s , multiplayer = %s", feature.name(), single, multi));
        }
        return sb.toString();
    }

    public static FeatureManager instance() {
        return Holder.INSTANCE;
    }

    public static boolean isAllowed(Feature feature) {
        Policy policy = Holder.INSTANCE.policyMap.get((Object)feature);
        return policy != null && policy.isCurrentlyAllowed();
    }

    public static Map<Feature, Boolean> getAllowedFeatures() {
        HashMap<Feature, Boolean> map = new HashMap<Feature, Boolean>(Feature.values().length * 2);
        for (Feature feature : Feature.values()) {
            map.put(feature, FeatureManager.isAllowed(feature));
        }
        return map;
    }

    public static String getPolicySetName() {
        return FeatureManager.instance().policySet.getName();
    }

    public Set<String> getControlCodes() {
        return this.disableControlCodes.keySet();
    }

    public void handleControlCode(String controlCode) {
        if (this.disableControlCodes.containsKey(controlCode)) {
            this.controlCodeAltered = true;
            for (Feature feature : this.disableControlCodes.get(controlCode)) {
                Journeymap.getLogger().info("Feature disabled in multiplayer via control code: " + (Object)((Object)feature));
                Holder.INSTANCE.policyMap.put(feature, new Policy(feature, true, false));
            }
        }
    }

    public void disableDimensionFeature(PermissionProperties properties) {
        FeatureManager.instance().reset();
        Holder.INSTANCE.policyMap.put(Feature.RadarAnimals, new Policy(Feature.RadarAnimals, true, true));
        Holder.INSTANCE.policyMap.put(Feature.RadarMobs, new Policy(Feature.RadarMobs, true, true));
        Holder.INSTANCE.policyMap.put(Feature.RadarVillagers, new Policy(Feature.RadarVillagers, true, true));
        Holder.INSTANCE.policyMap.put(Feature.RadarPlayers, new Policy(Feature.RadarPlayers, true, true));
        Holder.INSTANCE.policyMap.put(Feature.MapCaves, new Policy(Feature.MapCaves, true, true));
        if (!properties.caveMappingEnabled.get().booleanValue()) {
            Journeymap.getLogger().info("Feature disabled in multiplayer: " + (Object)((Object)Feature.MapCaves));
            Holder.INSTANCE.policyMap.put(Feature.MapCaves, new Policy(Feature.MapCaves, true, false));
        }
        if (properties.radarEnabled.get().booleanValue()) {
            if (!properties.animalRadarEnabled.get().booleanValue()) {
                Journeymap.getLogger().info("Feature disabled in multiplayer: " + (Object)((Object)Feature.RadarAnimals));
                Holder.INSTANCE.policyMap.put(Feature.RadarAnimals, new Policy(Feature.RadarAnimals, true, false));
            }
            if (!properties.mobRadarEnabled.get().booleanValue()) {
                Journeymap.getLogger().info("Feature disabled in multiplayer: " + (Object)((Object)Feature.RadarMobs));
                Holder.INSTANCE.policyMap.put(Feature.RadarMobs, new Policy(Feature.RadarMobs, true, false));
            }
            if (!properties.playerRadarEnabled.get().booleanValue()) {
                Journeymap.getLogger().info("Feature disabled in multiplayer: " + (Object)((Object)Feature.RadarPlayers));
                Holder.INSTANCE.policyMap.put(Feature.RadarPlayers, new Policy(Feature.RadarPlayers, true, false));
            }
            if (!properties.villagerRadarEnabled.get().booleanValue()) {
                Journeymap.getLogger().info("Feature disabled in multiplayer: " + (Object)((Object)Feature.RadarVillagers));
                Holder.INSTANCE.policyMap.put(Feature.RadarVillagers, new Policy(Feature.RadarVillagers, true, false));
            }
        } else {
            Journeymap.getLogger().info("Feature disabled in multiplayer via control code: AllRadar");
            Holder.INSTANCE.policyMap.put(Feature.RadarAnimals, new Policy(Feature.RadarAnimals, true, false));
            Holder.INSTANCE.policyMap.put(Feature.RadarMobs, new Policy(Feature.RadarMobs, true, false));
            Holder.INSTANCE.policyMap.put(Feature.RadarVillagers, new Policy(Feature.RadarVillagers, true, false));
            Holder.INSTANCE.policyMap.put(Feature.RadarPlayers, new Policy(Feature.RadarPlayers, true, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        PolicySet policySet = this.policySet;
        synchronized (policySet) {
            if (this.controlCodeAltered == null || this.controlCodeAltered.booleanValue()) {
                for (Policy policy : this.policySet.getPolicies()) {
                    this.policyMap.put(policy.feature, policy);
                }
                if (this.controlCodeAltered != null) {
                    Journeymap.getLogger().info("Returning to default " + FeatureManager.getPolicyDetails());
                }
                this.controlCodeAltered = false;
            }
        }
    }

    private static class Holder {
        private static final FeatureManager INSTANCE = new FeatureManager();

        private Holder() {
        }
    }

    public static interface PolicySet {
        public Set<Policy> getPolicies();

        public String getName();
    }
}

