/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.GuiSideWindow;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketServerCommand;
import mcjty.lib.varia.Logging;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.lwjgl.input.Keyboard;

public abstract class GenericGuiContainer<T extends GenericTileEntity>
extends GuiContainer {
    protected ModBase modBase;
    protected SimpleNetworkWrapper network;
    protected Window window;
    private WindowManager windowManager;
    protected final T tileEntity;
    private GuiSideWindow sideWindow;

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public GenericGuiContainer(ModBase mod, SimpleNetworkWrapper network, T tileEntity, Container container, int manual, String manualNode) {
        super(container);
        this.modBase = mod;
        this.network = network;
        this.tileEntity = tileEntity;
        this.sideWindow = new GuiSideWindow(manual, manualNode);
        this.windowManager = null;
    }

    public List<Rectangle> getSideWindowBounds() {
        if (this.sideWindow.getWindow() == null || this.sideWindow.getWindow().getToplevel() == null) {
            try {
                throw new RuntimeException("Internal error! getSideWindowBounds() called before initGui!");
            }
            catch (RuntimeException e) {
                Logging.logError("Internal error! getSideWindowBounds() called before initGui!", e);
                return Collections.emptyList();
            }
        }
        return Collections.singletonList(this.sideWindow.getWindow().getToplevel().getBounds());
    }

    public void func_73866_w_() {
        this.windowManager = null;
        super.func_73866_w_();
        this.sideWindow.initGui(this.modBase, this.network, this.field_146297_k, (GuiScreen)this, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
    }

    protected void registerWindows(WindowManager mgr) {
    }

    protected WindowManager getWindowManager() {
        if (this.windowManager == null) {
            this.windowManager = new WindowManager((GuiScreen)this);
            this.windowManager.addWindow(this.sideWindow.getWindow());
            this.windowManager.addWindow(this.window);
            this.registerWindows(this.windowManager);
        }
        return this.windowManager;
    }

    protected void func_146979_b(int i, int i2) {
        this.getWindowManager().drawTooltips();
    }

    private List parseString(String s, List<ItemStack> items) {
        ArrayList<String> l = new ArrayList<String>();
        String current = "";
        for (int i = 0; i < s.length(); ++i) {
            String c = s.substring(i, i + 1);
            if ("@".equals(c)) {
                int itemIdx;
                ItemStack e;
                if (!current.isEmpty()) {
                    l.add(current);
                    current = "";
                }
                if ((e = items.get(itemIdx = Integer.parseInt(s.substring(++i, i + 1)))).func_190926_b()) continue;
                l.add((String)e);
                continue;
            }
            current = current + c;
        }
        if (!current.isEmpty()) {
            l.add(current);
        }
        return l;
    }

    public void drawHoveringText(List<String> textLines, List<ItemStack> items, int x, int y, FontRenderer font) {
        if (!textLines.isEmpty()) {
            GlStateManager.func_179101_C();
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int i = 0;
            int linesWithItemStacks = 0;
            for (String s : textLines) {
                int j;
                if (s.contains("@") && !items.isEmpty()) {
                    ++linesWithItemStacks;
                    List list = this.parseString(s, items);
                    j = 0;
                    for (Object o : list) {
                        if (o instanceof String) {
                            j += font.func_78256_a((String)o);
                            continue;
                        }
                        j += 20;
                    }
                } else {
                    j = font.func_78256_a(s);
                }
                if (j <= i) continue;
                i = j;
            }
            int xx = x + 12;
            int yy = y - 12;
            int k = 8;
            if (textLines.size() > 1) {
                k += 2 + (textLines.size() - 1) * 10 + linesWithItemStacks * 8;
            }
            if (xx + i > this.field_146294_l) {
                xx -= 28 + i;
            }
            if (yy + k + 6 > this.field_146295_m) {
                yy = this.field_146295_m - k - 6;
            }
            this.field_73735_i = 300.0f;
            this.field_146296_j.field_77023_b = 300.0f;
            int l = -267386864;
            this.func_73733_a(xx - 3, yy - 4, xx + i + 3, yy - 3, l, l);
            this.func_73733_a(xx - 3, yy + k + 3, xx + i + 3, yy + k + 4, l, l);
            this.func_73733_a(xx - 3, yy - 3, xx + i + 3, yy + k + 3, l, l);
            this.func_73733_a(xx - 4, yy - 3, xx - 3, yy + k + 3, l, l);
            this.func_73733_a(xx + i + 3, yy - 3, xx + i + 4, yy + k + 3, l, l);
            int i1 = 0x505000FF;
            int j1 = (i1 & 0xFEFEFE) >> 1 | i1 & 0xFF000000;
            this.func_73733_a(xx - 3, yy - 3 + 1, xx - 3 + 1, yy + k + 3 - 1, i1, j1);
            this.func_73733_a(xx + i + 2, yy - 3 + 1, xx + i + 3, yy + k + 3 - 1, i1, j1);
            this.func_73733_a(xx - 3, yy - 3, xx + i + 3, yy - 3 + 1, i1, i1);
            this.func_73733_a(xx - 3, yy + k + 2, xx + i + 3, yy + k + 3, j1, j1);
            for (int k1 = 0; k1 < textLines.size(); ++k1) {
                String s1 = textLines.get(k1);
                if (s1.contains("@") && !items.isEmpty()) {
                    List list = this.parseString(s1, items);
                    int curx = xx;
                    for (Object o : list) {
                        if (o instanceof String) {
                            font.func_175063_a(s1, (float)curx, (float)yy, -1);
                            curx += font.func_78256_a((String)o);
                            continue;
                        }
                        RenderHelper.renderObject(this.field_146297_k, curx + 1, yy, o, false);
                        curx += 20;
                    }
                    yy += 8;
                } else {
                    font.func_175063_a(s1, (float)xx, (float)yy, -1);
                }
                if (k1 == 0) {
                    yy += 2;
                }
                yy += 10;
            }
            this.field_73735_i = 0.0f;
            this.field_146296_j.field_77023_b = 0.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            net.minecraft.client.renderer.RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    protected void drawWindow() {
        this.func_146276_q_();
        this.getWindowManager().draw();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.getWindowManager().mouseClicked(x, y, button);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.getWindowManager().handleMouseInput();
    }

    protected void func_146286_b(int x, int y, int state) {
        super.func_146286_b(x, y, state);
        this.getWindowManager().mouseReleased(x, y, state);
    }

    public Window getWindow() {
        return this.window;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean b = this.getWindowManager().keyTyped(typedChar, keyCode);
        if (b) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void keyTypedFromEvent(char typedChar, int keyCode) {
        try {
            boolean b = this.getWindowManager().keyTyped(typedChar, keyCode);
            if (b) {
                super.func_73869_a(typedChar, keyCode);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendServerCommand(SimpleNetworkWrapper network, String command, Argument ... arguments) {
        network.sendToServer((IMessage)new PacketServerCommand(this.tileEntity.func_174877_v(), null, command, arguments));
    }

    public void sendServerCommand(SimpleNetworkWrapper network, int dimensionId, String command, Argument ... arguments) {
        network.sendToServer((IMessage)new PacketServerCommand(this.tileEntity.func_174877_v(), dimensionId, command, arguments));
    }
}

