/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.StringUtils;

public class TextPage
extends AbstractWidget<TextPage> {
    private ModBase modBase;
    private final List<Page> pages = new ArrayList<Page>();
    private final Map<String, Integer> nodes = new HashMap<String, Integer>();
    private int pageIndex = 0;
    private final List<Line> lines = new ArrayList<Line>();
    private final List<Link> links = new ArrayList<Link>();
    private ResourceLocation arrowImage = null;
    private int arrowU;
    private int arrowV;
    private ResourceLocation craftingGridImage = null;
    private int craftU;
    private int craftV;
    private int tabCounter = 0;

    public TextPage(ModBase modBase, Minecraft mc, Gui gui) {
        super(mc, gui);
        this.modBase = modBase;
    }

    public TextPage setArrowImage(ResourceLocation image, int u, int v) {
        this.arrowImage = image;
        this.arrowU = u;
        this.arrowV = v;
        return this;
    }

    public TextPage setCraftingGridImage(ResourceLocation image, int u, int v) {
        this.craftingGridImage = image;
        this.craftU = u;
        this.craftV = v;
        return this;
    }

    private void setPage(Page page) {
        this.lines.clear();
        this.links.clear();
        if (!this.pages.isEmpty()) {
            int y = 3;
            int tab = 0;
            for (Line line : page.lines) {
                this.lines.add(line);
                if (line.isNexttab()) {
                    y = 3;
                    ++tab;
                } else if (line.isLink()) {
                    this.links.add(new Link(tab, y, y + 13, line.node));
                }
                y += line.height;
            }
        }
    }

    private void newPage(Page page) {
        if (!page.isEmpty()) {
            this.pages.add(page);
        }
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public TextPage setText(ResourceLocation manualResource) {
        Page page = new Page();
        try {
            IResource iresource;
            IResourceManager resourceManager = this.mc.func_110442_L();
            try {
                iresource = resourceManager.func_110536_a(manualResource);
            }
            catch (Exception e) {
                String fallBackPath = manualResource.func_110623_a().replaceAll("-([a-z\\-]{2,6})_?([a-z]{0,3})", "");
                iresource = resourceManager.func_110536_a(new ResourceLocation(manualResource.func_110624_b(), fallBackPath));
            }
            InputStream inputstream = iresource.func_110527_b();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith("{------")) {
                    this.newPage(page);
                    page = new Page();
                } else {
                    Line l = page.addLine(this.modBase, line);
                    if (l.isNode()) {
                        this.nodes.put(l.node, this.pages.size());
                    }
                }
                line = br.readLine();
            }
            this.newPage(page);
        }
        catch (FileNotFoundException e) {
            Logging.logError("Error reading manual text", e);
        }
        catch (IOException e) {
            Logging.logError("Error reading manual text", e);
        }
        this.showCurrentPage();
        return this;
    }

    public void prevPage() {
        --this.pageIndex;
        if (this.pageIndex < 0) {
            this.pageIndex = 0;
        }
        this.showCurrentPage();
    }

    public void nextPage() {
        ++this.pageIndex;
        if (this.pageIndex >= this.pages.size()) {
            this.pageIndex = this.pages.size() - 1;
        }
        this.showCurrentPage();
    }

    private void showCurrentPage() {
        this.setPage(this.pages.get(this.pageIndex));
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        if (this.isEnabledAndVisible()) {
            window.setTextFocus(this);
            for (Link link : this.links) {
                int t;
                if (this.tabCounter == 0) {
                    if (link.y1 > y || y > link.y2 || !this.gotoLink(link)) continue;
                    return this;
                }
                int n = t = x < this.getBounds().width / 2 ? 0 : 1;
                if (link.y1 > y || y > link.y2 || link.tab != t || !this.gotoLink(link)) continue;
                return this;
            }
            return this;
        }
        return null;
    }

    private boolean gotoLink(Link link) {
        String node = link.node;
        return this.gotoNode(node);
    }

    public boolean gotoNode(String node) {
        Integer page = this.nodes.get(node);
        if (page != null) {
            this.pageIndex = page;
            this.showCurrentPage();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyTyped(Window window, char typedChar, int keyCode) {
        boolean rc = super.keyTyped(window, typedChar, keyCode);
        if (rc) {
            return true;
        }
        if (this.isEnabledAndVisible()) {
            if (keyCode == 14 || keyCode == 203) {
                this.prevPage();
                return true;
            }
            if (keyCode == 57 || keyCode == 205) {
                this.nextPage();
                return true;
            }
            if (keyCode == 199) {
                this.pageIndex = 0;
                this.showCurrentPage();
            } else if (keyCode == 207 && !this.pages.isEmpty()) {
                this.pageIndex = this.pages.size() - 1;
                this.showCurrentPage();
            }
        }
        return false;
    }

    @Override
    public void draw(Window window, int x, int y) {
        super.draw(window, x, y);
        this.tabCounter = 0;
        int starty = y += 3;
        for (Line line : this.lines) {
            if (line.isNexttab()) {
                y = starty;
                x += this.getBounds().width / 2;
                ++this.tabCounter;
            } else if (line.recipe != null) {
                y = this.renderRecipe(x, y, line);
            } else if (line.resourceLocation != null) {
                this.renderImage(x, y, line);
            } else if (line.line != null) {
                this.renderLine(x, y, line);
            }
            y += line.height;
        }
    }

    private void renderImage(int x, int y, Line line) {
        char c;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(line.resourceLocation);
        this.gui.func_73729_b(x + 4, y + 1, line.u, line.v, 16, 16);
        int dx = 22;
        String s = "";
        int col = -16777216;
        if (line.isBold()) {
            c = '\u00a7';
            s = Character.toString(c) + "l";
        }
        if (line.isLink()) {
            c = '\u00a7';
            s = Character.toString(c) + "n";
            col = -16760662;
            dx = 25;
        }
        s = s + line.line;
        this.mc.field_71466_p.func_78276_b(this.mc.field_71466_p.func_78269_a(s, this.bounds.width - dx), x + dx + this.bounds.x, y + this.bounds.y + 3, col);
    }

    private void renderLine(int x, int y, Line line) {
        char c;
        String s = "";
        int col = -16777216;
        int dx = 0;
        if (line.isBold()) {
            c = '\u00a7';
            s = Character.toString(c) + "l";
        }
        if (line.isLink()) {
            c = '\u00a7';
            s = Character.toString(c) + "n";
            col = -16760662;
            dx = 25;
        }
        s = s + line.line;
        this.mc.field_71466_p.func_78276_b(this.mc.field_71466_p.func_78269_a(s, this.bounds.width - dx), x + dx + this.bounds.x, y + this.bounds.y, col);
    }

    private int renderRecipe(int x, int y, Line line) {
        NonNullList ingredients;
        int h;
        int w;
        y += 4;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.craftingGridImage != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(this.craftingGridImage);
            this.gui.func_73729_b(25 + x, y, this.craftU, this.craftV, 57, 57);
        }
        if (line.recipe instanceof ShapedRecipes) {
            w = ((ShapedRecipes)line.recipe).func_192403_f();
            h = ((ShapedRecipes)line.recipe).func_192404_g();
            ingredients = line.recipe.func_192400_c();
        } else if (line.recipe instanceof ShapedOreRecipe) {
            w = ((ShapedOreRecipe)line.recipe).getWidth();
            h = ((ShapedOreRecipe)line.recipe).getHeight();
            ingredients = line.recipe.func_192400_c();
        } else {
            w = 0;
            h = 0;
            ingredients = null;
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Ingredient ingredient;
                if (i >= w || j >= h || (ingredient = (Ingredient)ingredients.get(i + j * w)).func_193365_a().length <= 0) continue;
                ItemStack stack = ingredient.func_193365_a()[0];
                if (stack != null && stack.func_77952_i() == Short.MAX_VALUE) {
                    NBTTagCompound tc = stack.func_77978_p();
                    stack = new ItemStack(stack.func_77973_b(), stack.func_190916_E(), 0);
                    if (tc != null) {
                        stack.func_77982_d(tc.func_74737_b());
                    }
                }
                RenderHelper.renderObject(this.mc, 26 + x + i * 18, 1 + y + j * 18, stack, false);
            }
        }
        if (this.arrowImage != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(this.arrowImage);
            this.gui.func_73729_b(x + 25 + 67, y + 18, this.arrowU, this.arrowV, 16, 16);
        }
        if (this.craftingGridImage != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(this.craftingGridImage);
            this.gui.func_73729_b(x + 25 + 92, y + 16, this.craftU, this.craftV, 18, 18);
        }
        RenderHelper.renderObject(this.mc, x + 25 + 93, y + 17, line.recipe.func_77571_b(), false);
        return y -= 4;
    }

    private static IRecipe findRecipe(ItemStack item) {
        if (item == null) {
            return null;
        }
        for (Map.Entry entry : ForgeRegistries.RECIPES.getEntries()) {
            ItemStack recipeOutput;
            IRecipe recipe = (IRecipe)entry.getValue();
            if (!(recipe instanceof ShapedRecipes) && !(recipe instanceof ShapedOreRecipe) || (recipeOutput = recipe.func_77571_b()).func_190926_b() || !recipeOutput.func_77969_a(item)) continue;
            return recipe;
        }
        return null;
    }

    public static class Link {
        final int tab;
        final int y1;
        final int y2;
        final String node;

        public Link(int tab, int y1, int y2, String node) {
            this.tab = tab;
            this.y1 = y1;
            this.y2 = y2;
            this.node = node;
        }
    }

    public static class Page {
        final List<Line> lines = new ArrayList<Line>();

        public boolean isEmpty() {
            return this.lines.isEmpty();
        }

        public Line addLine(ModBase modBase, String line) {
            Line l = new Line(modBase, line);
            this.lines.add(l);
            return l;
        }
    }

    private static class Line {
        private boolean bold = false;
        private boolean islink = false;
        private boolean isnode;
        private boolean nexttab = false;
        String node = null;
        String line = null;
        IRecipe recipe = null;
        ResourceLocation resourceLocation = null;
        int u;
        int v;
        int height = 14;

        public boolean isBold() {
            return this.bold;
        }

        public boolean isLink() {
            return this.islink;
        }

        public boolean isNode() {
            return this.isnode;
        }

        public boolean isNexttab() {
            return this.nexttab;
        }

        Line(ModBase modBase, String line) {
            if (line.startsWith("{b}")) {
                this.bold = true;
                this.line = line.substring(3);
            } else if (line.startsWith("{/}")) {
                this.nexttab = true;
                this.height = 0;
            } else if (line.startsWith("{n:")) {
                this.parseNode(line);
            } else if (line.startsWith("{l:")) {
                this.parseLink(line);
            } else if (line.startsWith("{i:")) {
                this.parseImage(modBase, line);
            } else if (line.startsWith("{ri:")) {
                this.parseItemRecipe(modBase, line);
            } else if (line.startsWith("{rb:")) {
                this.parseBlockRecipe(modBase, line);
            } else {
                this.line = line;
            }
        }

        private void parseNode(String line) {
            int end = line.indexOf(125);
            if (end == -1) {
                this.line = line;
            } else {
                this.node = line.substring(3, end);
                this.isnode = true;
                this.line = null;
            }
            this.height = 0;
        }

        private void parseLink(String line) {
            int end = line.indexOf(125);
            if (end == -1) {
                this.line = line;
            } else {
                this.node = line.substring(3, end);
                this.islink = true;
                this.line = line.substring(end + 1);
            }
        }

        private void parseBlockRecipe(ModBase modBase, String line) {
            int end = line.indexOf(125);
            if (end == -1) {
                this.line = line;
            } else {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modBase.getModId(), line.substring(4, end)));
                IRecipe iRecipe = this.recipe = block == null ? null : TextPage.findRecipe(new ItemStack(block));
                if (this.recipe == null) {
                    this.line = line;
                } else {
                    this.height = 62;
                }
            }
        }

        private void parseItemRecipe(ModBase modBase, String line) {
            int end = line.indexOf(125);
            if (end == -1) {
                this.line = line;
            } else {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modBase.getModId(), line.substring(4, end)));
                IRecipe iRecipe = this.recipe = item == null ? null : TextPage.findRecipe(new ItemStack(item));
                if (this.recipe == null) {
                    this.line = line;
                } else if (!(this.recipe instanceof ShapedRecipes) && !(this.recipe instanceof ShapedOreRecipe)) {
                    this.recipe = null;
                    this.line = line;
                } else {
                    this.height = 62;
                }
            }
        }

        private void parseImage(ModBase modBase, String line) {
            int end = line.indexOf(125);
            if (end == -1) {
                this.line = line;
            } else {
                String substring = line.substring(3, end);
                String[] split = StringUtils.split((String)substring, (char)',');
                this.u = 0;
                this.v = 0;
                try {
                    this.u = Integer.parseInt(split[1]);
                    this.v = Integer.parseInt(split[2]);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.resourceLocation = new ResourceLocation(modBase.getModId(), split[0]);
                try {
                    this.line = split[3];
                }
                catch (IndexOutOfBoundsException e) {
                    this.line = "<error>";
                }
                this.height = 18;
            }
        }
    }
}

