/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.api.carving;

import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.api.carving.ICarvingVariation;

@ParametersAreNonnullByDefault
public class CarvingUtils {
    @Nullable
    public static ICarvingRegistry chisel;

    public static int compare(ICarvingVariation v1, ICarvingVariation v2) {
        return v1.getOrder() - v2.getOrder();
    }

    @Deprecated
    public static ItemStack getStack(ICarvingVariation variation) {
        return variation.getStack();
    }

    @Nullable
    public static ICarvingRegistry getChiselRegistry() {
        return chisel;
    }

    @Deprecated
    public static ICarvingVariation getDefaultVariationFor(IBlockState state, int order) {
        return new SimpleCarvingVariation(state, order);
    }

    public static ICarvingVariation variationFor(IBlockState state, int order) {
        return new VariationForState(state, order);
    }

    public static ICarvingVariation variationFor(ItemStack stack, int order) {
        return new VariationForStack(stack, order);
    }

    public static ICarvingVariation variationFor(ItemStack stack, @Nullable IBlockState state, int order) {
        return new SimpleVariation(stack, state, order);
    }

    public static ICarvingGroup getDefaultGroupFor(String name) {
        return new SimpleCarvingGroup(name);
    }

    private static class SimpleCarvingGroup
    implements ICarvingGroup {
        private String name;
        @Nullable
        private String sound;
        private List<ICarvingVariation> variations = Lists.newArrayList();

        public SimpleCarvingGroup(String name) {
            this.name = name;
        }

        @Override
        public List<ICarvingVariation> getVariations() {
            return Lists.newArrayList(this.variations);
        }

        @Override
        public void addVariation(ICarvingVariation variation) {
            this.variations.add(variation);
            Collections.sort(this.variations, new Comparator<ICarvingVariation>(){

                @Override
                public int compare(ICarvingVariation o1, ICarvingVariation o2) {
                    return CarvingUtils.compare(o1, o2);
                }
            });
        }

        @Override
        public boolean removeVariation(ICarvingVariation variation) {
            return this.variations.removeIf(v -> ItemStack.func_179545_c((ItemStack)v.getStack(), (ItemStack)variation.getStack()) && (v.getStack().func_77978_p() == null || ItemStack.func_77970_a((ItemStack)v.getStack(), (ItemStack)variation.getStack())) || v.getBlockState() != null && v.getBlockState().equals(variation.getBlockState()));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getSound() {
            return this.sound;
        }

        @Override
        public void setSound(@Nullable String sound) {
            this.sound = sound;
        }

        @Override
        @Deprecated
        @Nullable
        public String getOreName() {
            return null;
        }

        @Override
        @Deprecated
        public void setOreName(@Nullable String oreName) {
        }
    }

    private static class SimpleVariation
    extends SimpleVariationBase {
        private final ItemStack stack;
        @Nullable
        private final IBlockState blockState;

        public SimpleVariation(ItemStack stack, @Nullable IBlockState state, int order) {
            super(order);
            this.stack = stack;
            this.blockState = state;
        }

        @Override
        @Nullable
        public Block getBlock() {
            return this.blockState == null ? null : this.blockState.func_177230_c();
        }

        @Override
        public ItemStack getStack() {
            return this.stack;
        }

        @Override
        @Nullable
        public IBlockState getBlockState() {
            return this.blockState;
        }
    }

    private static class VariationForStack
    extends SimpleVariationBase {
        private final ItemStack stack;
        private final boolean hasBlock;

        public VariationForStack(ItemStack stack, int order) {
            super(order);
            this.stack = stack;
            this.hasBlock = stack.func_77973_b() instanceof ItemBlock;
        }

        @Override
        @Nullable
        @Deprecated
        public Block getBlock() {
            return this.hasBlock ? ((ItemBlock)this.stack.func_77973_b()).func_179223_d() : null;
        }

        @Override
        @Nullable
        public IBlockState getBlockState() {
            return this.hasBlock ? ((ItemBlock)this.stack.func_77973_b()).func_179223_d().func_176203_a(this.stack.func_77952_i()) : null;
        }

        @Override
        public ItemStack getStack() {
            return this.stack;
        }
    }

    private static class VariationForState
    extends SimpleCarvingVariation {
        public VariationForState(IBlockState state, int order) {
            super(state, order);
        }
    }

    @Deprecated
    private static class SimpleCarvingVariation
    extends SimpleVariationBase {
        private IBlockState state;

        public SimpleCarvingVariation(IBlockState state, int order) {
            super(order);
            this.state = state;
        }

        @Override
        @Deprecated
        public Block getBlock() {
            return this.state.func_177230_c();
        }

        @Override
        public IBlockState getBlockState() {
            return this.state;
        }

        @Override
        public ItemStack getStack() {
            return new ItemStack(this.state.func_177230_c(), 1, this.state.func_177230_c().func_180651_a(this.state));
        }
    }

    private static abstract class SimpleVariationBase
    implements ICarvingVariation {
        private final int order;

        @ConstructorProperties(value={"order"})
        protected SimpleVariationBase(int order) {
            this.order = order;
        }

        @Override
        public int getOrder() {
            return this.order;
        }
    }
}

