/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.chisel.api.IChiselGuiType;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.common.config.Configurations;
import team.chisel.common.init.ChiselTabs;

@ParametersAreNonnullByDefault
public class ItemChisel
extends Item
implements IChiselItem {
    private final ChiselType type;

    public ItemChisel(ChiselType type) {
        this.type = type;
        this.func_77625_d(1);
        String name = "chisel_" + type.name().toLowerCase(Locale.US);
        this.setRegistryName(name);
        this.func_77655_b("chisel." + name);
        this.func_77637_a(ChiselTabs.tab);
    }

    public int func_77612_l() {
        if (Configurations.allowChiselDamage) {
            return this.type.maxDamage;
        }
        return 0;
    }

    public boolean func_77645_m() {
        return Configurations.allowChiselDamage;
    }

    public boolean func_82789_a(ItemStack damagedItem, ItemStack repairMaterial) {
        switch (this.type) {
            case DIAMOND: 
            case HITECH: {
                return repairMaterial.func_77973_b().equals(Items.field_151045_i);
            }
            case IRON: {
                return repairMaterial.func_77973_b().equals(Items.field_151042_j);
            }
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List list, ITooltipFlag flag) {
        String base = "item.chisel.chisel.desc.";
        String gui = I18n.func_135052_a((String)(base + "gui"), (Object[])new Object[0]);
        String lc1 = I18n.func_135052_a((String)(base + "lc1"), (Object[])new Object[0]);
        String lc2 = I18n.func_135052_a((String)(base + "lc2"), (Object[])new Object[0]);
        String modes = I18n.func_135052_a((String)(base + "modes"), (Object[])new Object[0]);
        list.add(gui);
        if (this.type == ChiselType.DIAMOND || Configurations.ironChiselCanLeftClick) {
            list.add(lc1);
            list.add(lc2);
        }
        if (this.type == ChiselType.DIAMOND || Configurations.ironChiselHasModes) {
            list.add("");
            list.add(modes);
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Chisel Damage", (double)this.type.attackDamage, 0));
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return super.func_77644_a(stack, attacker, target);
    }

    @Override
    public boolean canOpenGui(World world, EntityPlayer player, EnumHand hand) {
        return true;
    }

    @Override
    public IChiselGuiType getGuiType(World world, EntityPlayer player, EnumHand hand) {
        return this.type == ChiselType.HITECH ? IChiselGuiType.ChiselGuiType.HITECH : IChiselGuiType.ChiselGuiType.NORMAL;
    }

    @Override
    public boolean canChisel(World world, EntityPlayer player, ItemStack chisel, ICarvingVariation target) {
        return true;
    }

    @Override
    public boolean onChisel(World world, EntityPlayer player, ItemStack chisel, ICarvingVariation target) {
        return Configurations.allowChiselDamage;
    }

    @Override
    public boolean canChiselBlock(World world, EntityPlayer player, EnumHand hand, BlockPos pos, IBlockState state) {
        return this.type == ChiselType.DIAMOND || Configurations.ironChiselCanLeftClick;
    }

    @Override
    public boolean hasModes(EntityPlayer player, EnumHand hand) {
        return this.type == ChiselType.DIAMOND || Configurations.ironChiselHasModes;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public ChiselType getType() {
        return this.type;
    }

    public static enum ChiselType {
        IRON(Configurations.ironChiselMaxDamage, Configurations.ironChiselAttackDamage),
        DIAMOND(Configurations.diamondChiselMaxDamage, Configurations.diamondChiselAttackDamage),
        HITECH(Configurations.hitechChiselMaxDamage, Configurations.hitechChiselAttackDamage);

        final int maxDamage;
        final int attackDamage;

        private ChiselType(int maxDamage, int attackDamage) {
            this.maxDamage = maxDamage;
            this.attackDamage = attackDamage;
        }
    }
}

