/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import team.chisel.client.gui.PreviewType;

@ParametersAreNonnullByDefault
public class NBTUtil {
    private static final String KEY_TAG = "chiseldata";
    private static final String KEY_TARGET = "target";
    private static final String KEY_PREVIEW_TYPE = "preview";
    private static final String KEY_SELECTION_SLOT = "selectslot";
    private static final String KEY_TARGET_SLOT = "targetslot";
    private static final String KEY_ROTATE = "rotate";

    public static NBTTagCompound getTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static NBTTagCompound getChiselTag(ItemStack stack) {
        NBTTagCompound tag = NBTUtil.getTag(stack);
        if (!tag.func_74764_b(KEY_TAG)) {
            tag.func_74782_a(KEY_TAG, (NBTBase)new NBTTagCompound());
        }
        return tag.func_74775_l(KEY_TAG);
    }

    public static void setChiselTag(ItemStack stack, NBTTagCompound tag) {
        NBTUtil.getTag(stack).func_74782_a(KEY_TAG, (NBTBase)tag);
    }

    public static ItemStack getChiselTarget(ItemStack stack) {
        return new ItemStack(NBTUtil.getChiselTag(stack).func_74775_l(KEY_TARGET));
    }

    public static void setChiselTarget(ItemStack chisel, ItemStack target) {
        NBTUtil.getChiselTag(chisel).func_74782_a(KEY_TARGET, (NBTBase)target.func_77955_b(new NBTTagCompound()));
    }

    public static PreviewType getHitechType(ItemStack stack) {
        return PreviewType.values()[NBTUtil.getChiselTag(stack).func_74762_e(KEY_PREVIEW_TYPE)];
    }

    public static void setHitechType(ItemStack stack, int type) {
        NBTUtil.getChiselTag(stack).func_74768_a(KEY_PREVIEW_TYPE, type);
    }

    public static int getHitechSelection(ItemStack stack) {
        NBTTagCompound tag = NBTUtil.getChiselTag(stack);
        return tag.func_74764_b(KEY_SELECTION_SLOT) ? tag.func_74762_e(KEY_SELECTION_SLOT) : -1;
    }

    public static void setHitechSelection(ItemStack chisel, int slot) {
        NBTUtil.getChiselTag(chisel).func_74768_a(KEY_SELECTION_SLOT, slot);
    }

    public static int getHitechTarget(ItemStack stack) {
        NBTTagCompound tag = NBTUtil.getChiselTag(stack);
        return tag.func_74764_b(KEY_TARGET_SLOT) ? tag.func_74762_e(KEY_TARGET_SLOT) : -1;
    }

    public static void setHitechTarget(ItemStack chisel, int slot) {
        NBTUtil.getChiselTag(chisel).func_74768_a(KEY_TARGET_SLOT, slot);
    }

    public static boolean getHitechRotate(ItemStack stack) {
        return NBTUtil.getChiselTag(stack).func_74767_n(KEY_ROTATE);
    }

    public static void setHitechRotate(ItemStack chisel, boolean rotate) {
        NBTUtil.getChiselTag(chisel).func_74757_a(KEY_ROTATE, rotate);
    }
}

