/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import mod.chiselsandbits.bitbag.BagInventory;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.StateLookup;
import mod.chiselsandbits.integration.mcmultipart.MCMultipartProxy;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.items.ItemNegativePrint;
import mod.chiselsandbits.items.ItemPositivePrint;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.tuple.Pair;

public class ModUtil {
    @Nonnull
    public static final String NBT_SIDE = "side";
    @Nonnull
    public static final String NBT_BLOCKENTITYTAG = "BlockEntityTag";
    private static final Random RAND = new Random();
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    private static final Random itemRand = new Random();
    private static StateLookup IDRelay = new StateLookup();

    public static EnumFacing getPlaceFace(EntityLivingBase placer) {
        return EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
    }

    public static Pair<Vec3d, Vec3d> getPlayerRay(EntityPlayer playerIn) {
        double reachDistance = 5.0;
        double x = playerIn.field_70169_q + (playerIn.field_70165_t - playerIn.field_70169_q);
        double y = playerIn.field_70167_r + (playerIn.field_70163_u - playerIn.field_70167_r) + (double)playerIn.func_70047_e();
        double z = playerIn.field_70166_s + (playerIn.field_70161_v - playerIn.field_70166_s);
        float playerPitch = playerIn.field_70127_C + (playerIn.field_70125_A - playerIn.field_70127_C);
        float playerYaw = playerIn.field_70126_B + (playerIn.field_70177_z - playerIn.field_70126_B);
        float yawRayX = MathHelper.func_76126_a((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float yawRayZ = MathHelper.func_76134_b((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchMultiplier = -MathHelper.func_76134_b((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayY = MathHelper.func_76126_a((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayX = yawRayX * pitchMultiplier;
        float eyeRayZ = yawRayZ * pitchMultiplier;
        if (playerIn instanceof EntityPlayerMP) {
            reachDistance = ((EntityPlayerMP)playerIn).field_71134_c.getBlockReachDistance();
        }
        Vec3d from = new Vec3d(x, y, z);
        Vec3d to = from.func_72441_c((double)eyeRayX * reachDistance, (double)eyeRayY * reachDistance, (double)eyeRayZ * reachDistance);
        return Pair.of((Object)from, (Object)to);
    }

    public static ItemStackSlot findBit(ActingPlayer who, BlockPos pos, int StateID) {
        ItemStack inHand = who.getCurrentEquippedItem();
        IInventory inv = who.getInventory();
        boolean canEdit = who.canPlayerManipulate(pos, EnumFacing.UP, inHand, true);
        if (inHand != null && ModUtil.getStackSize(inHand) > 0 && inHand.func_77973_b() instanceof ItemChiseledBit && ItemChiseledBit.getStackState(inHand) == StateID) {
            return new ItemStackSlot(inv, who.getCurrentItem(), inHand, who, canEdit);
        }
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack is = inv.func_70301_a(x);
            if (is == null || ModUtil.getStackSize(is) <= 0 || !(is.func_77973_b() instanceof ItemChiseledBit) || !ItemChiseledBit.sameBit(is, StateID)) continue;
            return new ItemStackSlot(inv, x, is, who, canEdit);
        }
        return new ItemStackSlot(inv, -1, ModUtil.getEmptyStack(), who, canEdit);
    }

    @Nonnull
    public static ItemStack copy(ItemStack st) {
        if (st == null) {
            return ModUtil.getEmptyStack();
        }
        return ModUtil.nonNull(st.func_77946_l());
    }

    @Nonnull
    public static ItemStack nonNull(ItemStack st) {
        if (st == null) {
            return ModUtil.getEmptyStack();
        }
        return st;
    }

    public static boolean isHoldingPattern(EntityPlayer player) {
        ItemStack inHand = player.func_184614_ca();
        if (inHand != null && inHand.func_77973_b() instanceof ItemPositivePrint) {
            return true;
        }
        return inHand != null && inHand.func_77973_b() instanceof ItemNegativePrint;
    }

    public static boolean isHoldingChiseledBlock(EntityPlayer player) {
        ItemStack inHand = player.func_184614_ca();
        return inHand != null && inHand.func_77973_b() instanceof ItemBlockChiseled;
    }

    public static int getRotationIndex(EnumFacing face) {
        return face.func_176736_b();
    }

    public static int getRotations(EntityLivingBase placer, EnumFacing oldYaw) {
        int rotations;
        EnumFacing newFace = ModUtil.getPlaceFace(placer);
        for (rotations = ModUtil.getRotationIndex(newFace) - ModUtil.getRotationIndex(oldYaw); rotations < 0; rotations = 4 + rotations) {
        }
        while (rotations > 4) {
            rotations -= 4;
        }
        return 4 - rotations;
    }

    public static BlockPos getPartialOffset(EnumFacing side, BlockPos partial, IntegerBox modelBounds) {
        int offset_x = modelBounds.minX;
        int offset_y = modelBounds.minY;
        int offset_z = modelBounds.minZ;
        int partial_x = partial.func_177958_n();
        int partial_y = partial.func_177956_o();
        int partial_z = partial.func_177952_p();
        int middle_x = (modelBounds.maxX - modelBounds.minX) / -2;
        int middle_y = (modelBounds.maxY - modelBounds.minY) / -2;
        int middle_z = (modelBounds.maxZ - modelBounds.minZ) / -2;
        switch (side) {
            case DOWN: {
                offset_y = modelBounds.maxY;
                middle_y = 0;
                break;
            }
            case EAST: {
                offset_x = modelBounds.minX;
                middle_x = 0;
                break;
            }
            case NORTH: {
                offset_z = modelBounds.maxZ;
                middle_z = 0;
                break;
            }
            case SOUTH: {
                offset_z = modelBounds.minZ;
                middle_z = 0;
                break;
            }
            case UP: {
                offset_y = modelBounds.minY;
                middle_y = 0;
                break;
            }
            case WEST: {
                offset_x = modelBounds.maxX;
                middle_x = 0;
                break;
            }
            default: {
                throw new NullPointerException();
            }
        }
        int t_x = -offset_x + middle_x + partial_x;
        int t_y = -offset_y + middle_y + partial_y;
        int t_z = -offset_z + middle_z + partial_z;
        return new BlockPos(t_x, t_y, t_z);
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... options) {
        for (T i : options) {
            if (i == null) continue;
            return i;
        }
        throw new NullPointerException("Unable to find a non null item.");
    }

    public static TileEntity getTileEntitySafely(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (world instanceof ChunkCache) {
            return ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK);
        }
        if (world instanceof World) {
            return ((World)world).func_175726_f(pos).func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        }
        return world.func_175625_s(pos);
    }

    public static TileEntityBlockChiseled getChiseledTileEntity(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity te = ModUtil.getTileEntitySafely(world, pos);
        if (te instanceof TileEntityBlockChiseled) {
            return (TileEntityBlockChiseled)te;
        }
        return MCMultipartProxy.proxyMCMultiPart.getPartFromBlockAccess(world, pos);
    }

    public static TileEntityBlockChiseled getChiseledTileEntity(@Nonnull World world, @Nonnull BlockPos pos, boolean create) {
        if (world.func_175667_e(pos)) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityBlockChiseled) {
                return (TileEntityBlockChiseled)te;
            }
            return MCMultipartProxy.proxyMCMultiPart.getChiseledTileEntity(world, pos, create);
        }
        return null;
    }

    public static void removeChisledBlock(@Nonnull World world, @Nonnull BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityBlockChiseled) {
            world.func_175698_g(pos);
            return;
        }
        MCMultipartProxy.proxyMCMultiPart.removeChisledBlock(te);
        world.func_175704_b(pos, pos);
    }

    public static void feedPlayer(World world, EntityPlayer player, EntityItem ei) {
        ItemStack is = ModUtil.nonNull(ei.func_92059_d());
        List<ItemBitBag.BagPos> bags = ItemBitBag.getBags((IInventory)player.field_71071_by);
        if (!ModUtil.containsAtLeastOneOf((IInventory)player.field_71071_by, is)) {
            ItemStack minSize = is.func_77946_l();
            if (ModUtil.getStackSize(minSize) > minSize.func_77976_d()) {
                ModUtil.setStackSize(minSize, minSize.func_77976_d());
            }
            ModUtil.adjustStackSize(is, -ModUtil.getStackSize(minSize));
            player.field_71071_by.func_70441_a(minSize);
            ModUtil.adjustStackSize(is, ModUtil.getStackSize(minSize));
        }
        for (ItemBitBag.BagPos bp : bags) {
            is = bp.inv.insertItem(is);
        }
        if (is != null && !player.field_71071_by.func_70441_a(is)) {
            ei.func_92058_a(is);
            world.func_72838_d((Entity)ei);
        } else if (!ei.func_174814_R()) {
            ei.field_70170_p.func_184148_a((EntityPlayer)null, ei.field_70165_t, ei.field_70163_u, ei.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((itemRand.nextFloat() - itemRand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        player.field_71071_by.func_70296_d();
        if (player.field_71069_bz != null) {
            player.field_71069_bz.func_75142_b();
        }
    }

    public static boolean containsAtLeastOneOf(IInventory inv, ItemStack is) {
        boolean seen = false;
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack which = inv.func_70301_a(x);
            if (which == null || which.func_77973_b() != is.func_77973_b() || !ItemChiseledBit.sameBit(which, ItemChiseledBit.getStackState(is)) || seen) continue;
            seen = true;
        }
        return seen;
    }

    public static List<BagInventory> getBags(ActingPlayer player) {
        if (player.isCreative()) {
            return Collections.emptyList();
        }
        ArrayList<BagInventory> bags = new ArrayList<BagInventory>();
        IInventory inv = player.getInventory();
        for (int zz = 0; zz < inv.func_70302_i_(); ++zz) {
            ItemStack which = inv.func_70301_a(zz);
            if (which == null || !(which.func_77973_b() instanceof ItemBitBag)) continue;
            bags.add(new BagInventory(which));
        }
        return bags;
    }

    public static int consumeBagBit(List<BagInventory> bags, int inPattern, int howMany) {
        int remaining = howMany;
        for (BagInventory inv : bags) {
            if ((remaining -= inv.extractBit(inPattern, remaining)) != 0) continue;
            return howMany;
        }
        return howMany - remaining;
    }

    public static VoxelBlob getBlobFromStack(ItemStack stack, EntityLivingBase rotationPlayer) {
        if (stack.func_77942_o()) {
            NBTBlobConverter tmp = new NBTBlobConverter();
            NBTTagCompound cData = ModUtil.getSubCompound(stack, NBT_BLOCKENTITYTAG, false);
            if (cData == null) {
                cData = stack.func_77978_p();
            }
            tmp.readChisleData(cData, -1);
            VoxelBlob blob = tmp.getBlob();
            if (rotationPlayer != null) {
                int xrotations = ModUtil.getRotations(rotationPlayer, ModUtil.getSide(stack));
                while (xrotations-- > 0) {
                    blob = blob.spin(EnumFacing.Axis.Y);
                }
            }
            return blob;
        }
        return new VoxelBlob();
    }

    public static void sendUpdate(@Nonnull World worldObj, @Nonnull BlockPos pos) {
        IBlockState state = worldObj.func_180495_p(pos);
        worldObj.func_184138_a(pos, state, state, 0);
    }

    public static ItemStack getItemFromBlock(@Nonnull IBlockState state) {
        ItemBlock ib;
        Block blk = state.func_177230_c();
        Item i = blk.func_180660_a(state, RAND, 0);
        int meta = blk.func_176201_c(state);
        int damage = blk.func_180651_a(state);
        Item blockVarient = Item.func_150898_a((Block)blk);
        if (blk == Blocks.field_150349_c) {
            return new ItemStack((Block)Blocks.field_150349_c);
        }
        if (i == null || blockVarient == null || blockVarient != i) {
            return ModUtil.getEmptyStack();
        }
        if (blockVarient instanceof ItemBlock && meta != (ib = (ItemBlock)blockVarient).func_77647_b(damage)) {
            return ModUtil.getEmptyStack();
        }
        return new ItemStack(i, 1, damage);
    }

    public static boolean isNormalCube(IBlockState blockType) {
        return blockType.func_185915_l();
    }

    public static EnumFacing getSide(ItemStack stack) {
        if (stack != null) {
            NBTTagCompound c;
            NBTTagCompound blueprintTag = stack.func_77978_p();
            int byteValue = EnumFacing.NORTH.ordinal();
            if (blueprintTag == null) {
                return EnumFacing.NORTH;
            }
            if (blueprintTag.func_74764_b(NBT_SIDE)) {
                byteValue = blueprintTag.func_74771_c(NBT_SIDE);
            }
            if (blueprintTag.func_74764_b(NBT_BLOCKENTITYTAG) && (c = blueprintTag.func_74775_l(NBT_BLOCKENTITYTAG)).func_74764_b(NBT_SIDE)) {
                byteValue = c.func_74771_c(NBT_SIDE);
            }
            EnumFacing side = EnumFacing.NORTH;
            if (byteValue >= 0 && byteValue < EnumFacing.values().length) {
                side = EnumFacing.values()[byteValue];
            }
            if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                side = EnumFacing.NORTH;
            }
            return side;
        }
        return EnumFacing.NORTH;
    }

    public static void setSide(ItemStack stack, EnumFacing side) {
        if (stack != null) {
            NBTTagCompound blueprintTag = stack.func_77978_p();
            if (blueprintTag == null) {
                blueprintTag = new NBTTagCompound();
            }
            if (blueprintTag.func_74764_b(NBT_BLOCKENTITYTAG)) {
                blueprintTag.func_74775_l(NBT_BLOCKENTITYTAG).func_74774_a(NBT_SIDE, (byte)side.ordinal());
            }
            blueprintTag.func_74768_a(NBT_SIDE, side.ordinal());
            stack.func_77982_d(blueprintTag);
        }
    }

    public static IBlockState getStateById(int blockStateID) {
        return IDRelay.getStateById(blockStateID);
    }

    public static int getStateId(IBlockState state) {
        return IDRelay.getStateId(state);
    }

    public static void cacheFastStates() {
        if (!ChiselsAndBits.getConfig().lowMemoryMode) {
            IDRelay = new StateLookup.CachedStateLookup();
        }
    }

    public static int getStackSize(ItemStack stack) {
        return stack == null ? 0 : stack.func_190916_E();
    }

    public static void setStackSize(@Nonnull ItemStack stack, int stackSize) {
        stack.func_190920_e(stackSize);
    }

    public static void adjustStackSize(@Nonnull ItemStack is, int sizeDelta) {
        ModUtil.setStackSize(is, ModUtil.getStackSize(is) + sizeDelta);
    }

    public static NBTTagCompound getSubCompound(ItemStack stack, String tag, boolean create) {
        if (create) {
            return stack.func_190925_c(tag);
        }
        return stack.func_179543_a(tag);
    }

    @Nonnull
    public static ItemStack getEmptyStack() {
        return ItemStack.field_190927_a;
    }

    public static boolean notEmpty(ItemStack itemStack) {
        return itemStack != null && !itemStack.func_190926_b();
    }

    public static boolean isEmpty(ItemStack itemStack) {
        return itemStack == null || itemStack.func_190926_b();
    }

    @Nonnull
    public static NBTTagCompound getTagCompound(ItemStack ei) {
        NBTTagCompound c = ei.func_77978_p();
        if (c == null) {
            return new NBTTagCompound();
        }
        return c;
    }

    public static IBlockState getStateFromItem(ItemStack is) {
        try {
            ItemBlock iblk;
            IBlockState state;
            ItemStack out;
            if (!ModUtil.isEmpty(is) && is.func_77973_b() instanceof ItemBlock && !ModUtil.isEmpty(out = ModUtil.getItemFromBlock(state = (iblk = (ItemBlock)is.func_77973_b()).func_179223_d().func_176203_a(iblk.func_77647_b(is.func_77952_i())))) && out.func_77973_b() == is.func_77973_b() && is.func_77952_i() == out.func_77952_i()) {
                return state;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static void damageItem(@Nonnull ItemStack is, @Nonnull Random r) {
        if (is.func_77984_f() && is.func_96631_a(1, r, null)) {
            is.func_190918_g(1);
        }
    }

    @Nonnull
    public static ItemStack makeStack(Item item) {
        return ModUtil.makeStack(item, 1);
    }

    @Nonnull
    public static ItemStack makeStack(Item item, int stackSize) {
        return ModUtil.makeStack(item, 1, 0);
    }

    @Nonnull
    public static ItemStack makeStack(Item item, int stackSize, int damage) {
        if (item == null || stackSize < 1) {
            return ModUtil.getEmptyStack();
        }
        return new ItemStack(item, stackSize, damage);
    }

    public static boolean isEmpty(Item item) {
        return item == Item.field_150901_e.func_148754_a(0);
    }

    public static class ItemStackSlot {
        private final IInventory inv;
        private final int slot;
        @Nonnull
        private ItemStack stack;
        @Nonnull
        private final ItemStack originalStack;
        private final boolean isCreative;
        private final boolean isEditable;
        private final int toolSlot;

        ItemStackSlot(IInventory i, int s, @Nonnull ItemStack st, ActingPlayer player, boolean canEdit) {
            this.inv = i;
            this.slot = s;
            this.stack = st;
            this.originalStack = ModUtil.copy(st);
            this.toolSlot = player.getCurrentItem();
            this.isCreative = player.isCreative();
            this.isEditable = canEdit;
        }

        public boolean isValid() {
            return this.isEditable && (this.isCreative || !ModUtil.isEmpty(this.stack) && ModUtil.getStackSize(this.stack) > 0);
        }

        public void damage(ActingPlayer who) {
            if (this.isCreative) {
                return;
            }
            who.damageItem(this.stack, 1);
            if (ModUtil.getStackSize(this.stack) <= 0) {
                who.playerDestroyItem(this.stack, who.getHand());
                this.inv.func_70299_a(this.slot, ModUtil.getEmptyStack());
            }
        }

        public void consume() {
            if (this.isCreative) {
                return;
            }
            ModUtil.adjustStackSize(this.stack, -1);
            if (ModUtil.getStackSize(this.stack) <= 0) {
                this.inv.func_70299_a(this.slot, ModUtil.getEmptyStack());
            }
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void swapWithWeapon() {
            ItemStack it = this.inv.func_70301_a(this.toolSlot);
            this.inv.func_70299_a(this.toolSlot, this.inv.func_70301_a(this.slot));
            this.inv.func_70299_a(this.slot, it);
        }

        public ItemStack getStackType() {
            return this.originalStack;
        }

        public void replaceStack(@Nonnull ItemStack restockItem) {
            this.stack = restockItem;
            this.inv.func_70299_a(this.slot, restockItem);
        }
    }
}

