/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.soundfilters;

import com.tmtravlr.soundfilters.CommonProxy;
import com.tmtravlr.soundfilters.ModifiedLWJGLOpenALLibrary;
import com.tmtravlr.soundfilters.filters.FilterLowPass;
import com.tmtravlr.soundfilters.filters.FilterReverb;
import java.util.Comparator;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;

@Mod(modid="soundfilters", name="Sound Filters", version="0.10_for_1.12", clientSideOnly=true, acceptedMinecraftVersions="[1.12]")
public class SoundFiltersMod {
    public static final String MOD_ID = "soundfilters";
    public static final String MOD_NAME = "Sound Filters";
    public static final String MOD_VERSION = "0.10_for_1.12";
    @Mod.Instance(value="soundfilters")
    public static SoundFiltersMod soundFilters;
    @SidedProxy(clientSide="com.tmtravlr.soundfilters.ClientProxy", serverSide="com.tmtravlr.soundfilters.CommonProxy")
    public static CommonProxy proxy;
    private static Random rand;
    public static int profileSize;
    public static boolean doSkyChecks;
    public static boolean doReverb;
    public static float reverbPercent;
    public static boolean doLowPass;
    public static boolean doOcclusion;
    public static FilterLowPass lowPassFilter;
    public static FilterReverb reverbFilter;
    public static Comparator<BlockMeta> BlockComparator;
    public static TreeMap<BlockMeta, Double> customOcclusion;
    public static TreeMap<BlockMeta, Double> customReverb;
    public static boolean DEBUG;
    public static boolean SUPER_DUPER_DEBUG;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        int firstDashIndex;
        double strength;
        int meta;
        String blockName;
        Block block;
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        DEBUG = config.getBoolean("Debug", "debug", false, "Set to true to write simple debug info to the console.");
        SUPER_DUPER_DEBUG = config.getBoolean("High Output Debug", "debug", false, "You probably don't want to set this to true\nunless you actually want to debug the mod.\nIt writes quite a lot in the console.");
        doReverb = config.getBoolean("Use Reverb?", "filters", true, "Set to false to disable reverb.");
        doLowPass = config.getBoolean("Use Low Pass?", "filters", true, "Set to false to disable low pass filter in water and lava.");
        doOcclusion = config.getBoolean("Use Occluded Sounds (muting sounds behind solid walls)?", "filters", true, "Set to false to disable low pass filter for sounds behind solid walls.\nIf you are getting lag, disabling this might help.");
        profileSize = config.getInt("Number of blocks reverb will check through:", "reverb", 1024, 0, Integer.MAX_VALUE, "If you are getting lag, set this number lower. The higher it is,\nthe more realistic the reverb will be.");
        reverbPercent = config.getFloat("Max Reverb", "reverb", 1.0f, 0.0f, 2.0f, "The maximum reverb you can get. You can lower this if you find\nthe reverb to be too much (or raise it if you really want an\necho).");
        doSkyChecks = config.getBoolean("Do sky checks:", "reverb", true, "If this is true, when you're in an area that can see the sky, the\nthere will be less reverb. This is for aboveground areas with\nlots of stone and such like extreme hills biomes.");
        String[] reverbBlocksList = config.getStringList("Specific block reverb:", "reverb", new String[]{"soul_sand-16-2.0"}, "Add values to this list (each on a new line) in the format \n<block id>-<metadata>-<reverb double>, to change how the block\nwith that metadata absorbs or creates reverb. If the\nmetadata is 16, that means it will apply to any metadata value.\nBy default things like wool, snow, carpets, and plants absorb reverb\n(value 0.0), things like wood and dirt are neutral (value 1.0),\nand things like stone, metal, ice, and glass create reverb (value 2.0).\nSo if, say, you wanted to add pumpkins of any metadata to the blocks\nthat create reverb, you would put pumpkin-16-2.0 on a new line.");
        String[] occlusionBlocksList = config.getStringList("Specific block occlusion:", "occlusion", new String[]{"wool-16-2.0"}, "Add new entries (each on a new line) in the format\n<block id>-<metadata>-<occlusion double> to customize how much sound\nthey should absorb when they are between you and the sound source.\nFor the metadata, 16 means any metadata value. The amount is a\ndouble, with 0.0 absorbing no sound (like air), and 1.0 being the normal\namount, and 2.0 being twice the normal amount. By default, wool has\nentry wool-16-2.0 which is twice the normal sound absorbtion.");
        config.save();
        for (String occlusionInfo : occlusionBlocksList) {
            block = null;
            blockName = "";
            meta = -1;
            strength = -1.0;
            try {
                int lastDashIndex = occlusionInfo.lastIndexOf(45);
                firstDashIndex = occlusionInfo.substring(0, lastDashIndex).lastIndexOf(45);
                blockName = occlusionInfo.substring(0, firstDashIndex);
                meta = Integer.valueOf(occlusionInfo.substring(firstDashIndex + 1, lastDashIndex));
                strength = Double.valueOf(occlusionInfo.substring(lastDashIndex + 1));
                block = Block.func_149684_b((String)blockName);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("[Sound Filters] Error while loading in custom occlusion entry!" + (blockName == "" ? "" : " Block ID was " + blockName));
            }
            if (block == null || meta < 0 || !(strength >= 0.0)) continue;
            if (DEBUG) {
                System.out.println("[Sound Filters] Loaded custom occlusion: block " + blockName + ", with " + (meta == 16 ? "any meta" : "meta " + meta) + ", and amount " + strength);
            }
            customOcclusion.put(new BlockMeta(block, meta), strength);
        }
        for (String reverbInfo : reverbBlocksList) {
            block = null;
            blockName = "";
            meta = -1;
            strength = -1.0;
            try {
                int lastDashIndex = reverbInfo.lastIndexOf(45);
                firstDashIndex = reverbInfo.substring(0, lastDashIndex).lastIndexOf(45);
                blockName = reverbInfo.substring(0, firstDashIndex);
                meta = Integer.valueOf(reverbInfo.substring(firstDashIndex + 1, lastDashIndex));
                strength = Double.valueOf(reverbInfo.substring(lastDashIndex + 1));
                block = Block.func_149684_b((String)blockName);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("[Sound Filters] Error while loading in custom reverb entry!" + (blockName == "" ? "" : " Block ID was " + blockName));
            }
            if (block == null || meta < 0 || !(strength >= 0.0)) continue;
            if (DEBUG) {
                System.out.println("[Sound Filters] Loaded custom reverb: block " + blockName + ", with " + (meta == 16 ? "any meta" : "meta " + meta) + ", and amount " + strength);
            }
            customReverb.put(new BlockMeta(block, meta), strength);
        }
        proxy.registerTickHandlers();
        proxy.registerEventHandlers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        SoundFiltersMod.reverbFilter.density = 0.0f;
        SoundFiltersMod.reverbFilter.diffusion = 0.6f;
        SoundFiltersMod.reverbFilter.gain = 0.15f;
        SoundFiltersMod.reverbFilter.gainHF = 0.8f;
        SoundFiltersMod.reverbFilter.decayTime = 0.1f;
        SoundFiltersMod.reverbFilter.decayHFRatio = 0.7f;
        SoundFiltersMod.reverbFilter.reflectionsGain = 0.6f;
        SoundFiltersMod.reverbFilter.reflectionsDelay = 0.0f;
        SoundFiltersMod.reverbFilter.lateReverbGain = 0.9f;
        SoundFiltersMod.reverbFilter.lateReverbDelay = 0.0f;
        SoundFiltersMod.reverbFilter.airAbsorptionGainHF = 0.99f;
        SoundFiltersMod.reverbFilter.roomRolloffFactor = 0.0f;
    }

    static {
        rand = new Random();
        profileSize = 1024;
        doSkyChecks = true;
        doReverb = true;
        reverbPercent = 1.0f;
        doLowPass = true;
        doOcclusion = true;
        lowPassFilter = new FilterLowPass();
        reverbFilter = new FilterReverb();
        BlockComparator = new Comparator<BlockMeta>(){

            @Override
            public int compare(BlockMeta first, BlockMeta second) {
                if (Block.func_149682_b((Block)second.block) - Block.func_149682_b((Block)first.block) != 0) {
                    return Block.func_149682_b((Block)second.block) - Block.func_149682_b((Block)first.block);
                }
                if (second.meta - first.meta != 0) {
                    return second.meta - first.meta;
                }
                return 0;
            }
        };
        customOcclusion = new TreeMap(BlockComparator);
        customReverb = new TreeMap(BlockComparator);
        DEBUG = false;
        SUPER_DUPER_DEBUG = false;
        if (SoundSystemConfig.getLibraries() != null) {
            SoundSystemConfig.getLibraries().clear();
        }
        try {
            SoundSystemConfig.addLibrary(ModifiedLWJGLOpenALLibrary.class);
        }
        catch (SoundSystemException e) {
            e.printStackTrace();
            System.out.println("[Sound Filters] Problem while loading modified library!");
        }
        System.out.println("[Sound Filters] Loaded modified library.");
    }

    public static class BlockMeta {
        public Block block;
        public int meta;

        public BlockMeta(Block b, int m) {
            this.block = b;
            this.meta = m;
        }
    }
}

