/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib;

import elucent.elulib.EluLib;
import elucent.elulib.block.BlockSlabBase;
import elucent.elulib.block.IBlock;
import elucent.elulib.event.RegisterContentEvent;
import elucent.elulib.event.RegisterCustomModelsEvent;
import elucent.elulib.event.RegisterParticleEvent;
import elucent.elulib.model.CustomModelLoader;
import elucent.elulib.model.ICustomModeledObject;
import elucent.elulib.model.IModeledObject;
import elucent.elulib.particle.ParticleRegistry;
import elucent.elulib.particle.particles.ParticleGlitter;
import elucent.elulib.particle.particles.ParticleGlow;
import elucent.elulib.particle.particles.ParticleSmoke;
import elucent.elulib.particle.particles.ParticleSpark;
import elucent.elulib.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ELRegistry {
    public static ArrayList<Item> items = new ArrayList();
    public static ArrayList<Block> blocks = new ArrayList();
    static Map<Class<? extends Entity>, IRenderFactory> entityRenderMap = new HashMap<Class<? extends Entity>, IRenderFactory>();
    static Map<Class<? extends TileEntity>, TileEntitySpecialRenderer> tileEntityRenderMap = new HashMap<Class<? extends TileEntity>, TileEntitySpecialRenderer>();
    private static int entityId = 0;
    private static String activeModid = "";
    public static Block multiblock_slave_empty;
    public static Block test;
    public static Block test_stairs;
    public static Block test_slab;
    public static Block test_double_slab;
    public static Block test_slant;
    public static Block test_outer_corner;
    public static Block test_inner_corner;
    public static Block test_wall;
    public static String PARTICLE_GLOW;
    public static String PARTICLE_SMOKE;
    public static String PARTICLE_SPARK;
    public static String PARTICLE_GLITTER;

    public static String getActiveModid() {
        return activeModid;
    }

    public static void initAll() {
        ModContainer container = Loader.instance().activeModContainer();
        MinecraftForge.EVENT_BUS.post((Event)new RegisterContentEvent(items, blocks));
        ELRegistry.setActiveMod("elulib", container);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerEntityRenderer(Class<? extends Entity> entity, IRenderFactory render) {
        entityRenderMap.put(entity, render);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerTileRenderer(Class<? extends TileEntity> entity, TileEntitySpecialRenderer render) {
        tileEntityRenderMap.put(entity, render);
    }

    public static void addSlabPair(Material material, SoundType type, float hardness, String name, IBlockState parent, Block[] refs, boolean customModels) {
        BlockSlabBase double_slab = new BlockSlabBase(material, type, hardness, name + "_double_slab", parent, true, null).setModelCustom(customModels);
        BlockSlabBase slab = new BlockSlabBase(material, type, hardness, name + "_slab", parent, false, (Block)double_slab).setModelCustom(customModels);
        double_slab.slab = slab;
        refs[0] = slab;
        refs[1] = double_slab;
        blocks.add((Block)slab);
        blocks.add((Block)double_slab);
    }

    public static void registerEntity(Class<? extends Entity> entity, int eggColor1, int eggColor2) {
        String[] nameParts = entity.getTypeName().split("\\.");
        String className = nameParts[nameParts.length - 1];
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(activeModid + ":" + Util.lowercase(className)), entity, (String)Util.lowercase(className), (int)entityId++, (Object)EluLib.INSTANCE, (int)64, (int)1, (boolean)true, (int)eggColor1, (int)eggColor2);
    }

    public static void registerEntity(Class<? extends Entity> entity) {
        String[] nameParts = entity.getTypeName().split("\\.");
        String className = nameParts[nameParts.length - 1];
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(activeModid + ":" + Util.lowercase(className)), entity, (String)Util.lowercase(className), (int)entityId++, (Object)EluLib.INSTANCE, (int)64, (int)1, (boolean)true);
    }

    public static void setActiveMod(String modid, ModContainer container) {
        activeModid = modid;
        Loader.instance().setActiveModContainer(container);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (Item i : items) {
            event.getRegistry().register((IForgeRegistryEntry)i);
        }
        for (Block b : blocks) {
            Item i;
            if (!(b instanceof IBlock) || (i = ((IBlock)b).getItemBlock()) == null) continue;
            event.getRegistry().register((IForgeRegistryEntry)i);
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block b : blocks) {
            event.getRegistry().register((IForgeRegistryEntry)b);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerRendering(ModelRegistryEvent event) {
        for (Item item : items) {
            if (!(item instanceof IModeledObject)) continue;
            ((IModeledObject)item).initModel();
        }
        for (Block block : blocks) {
            if (!(block instanceof IModeledObject)) continue;
            ((IModeledObject)block).initModel();
        }
        for (Map.Entry entry : entityRenderMap.entrySet()) {
            RenderingRegistry.registerEntityRenderingHandler((Class)((Class)entry.getKey()), (IRenderFactory)((IRenderFactory)entry.getValue()));
        }
        for (Map.Entry entry : tileEntityRenderMap.entrySet()) {
            ClientRegistry.bindTileEntitySpecialRenderer((Class)((Class)entry.getKey()), (TileEntitySpecialRenderer)((TileEntitySpecialRenderer)entry.getValue()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRegisterCustomModels(RegisterCustomModelsEvent event) {
        for (Block b : blocks) {
            if (!(b instanceof ICustomModeledObject)) continue;
            ((ICustomModeledObject)b).initCustomModel();
        }
        for (Item i : items) {
            if (!(i instanceof ICustomModeledObject)) continue;
            ((ICustomModeledObject)i).initCustomModel();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent event) {
        for (Map.Entry<String, ResourceLocation> entry : ParticleRegistry.particleTextures.entrySet()) {
            event.getMap().func_174942_a(entry.getValue());
        }
        for (Map.Entry<String, ResourceLocation> entry : CustomModelLoader.itemmodels.entrySet()) {
            for (ResourceLocation r : ((IModel)entry.getValue()).getTextures()) {
                event.getMap().func_174942_a(r);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        Function<ResourceLocation, TextureAtlasSprite> getter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        for (ResourceLocation r : CustomModelLoader.itemmodels.keySet()) {
            ModelResourceLocation mrl = new ModelResourceLocation(r.toString().replace("#inventory", ""), "inventory");
            Object object = event.getModelRegistry().func_82594_a((Object)mrl);
            if (!(object instanceof IBakedModel)) continue;
            IModel m = CustomModelLoader.itemmodels.get(r);
            event.getModelRegistry().func_82595_a((Object)mrl, (Object)m.bake(m.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRegisterCustomModels(RegisterParticleEvent event) {
        PARTICLE_GLOW = ParticleRegistry.registerParticle("elulib", ParticleGlow.class, new ResourceLocation("elulib:particle/particle_glow"));
        PARTICLE_SMOKE = ParticleRegistry.registerParticle("elulib", ParticleSmoke.class, new ResourceLocation("elulib:particle/particle_smoke"));
        PARTICLE_SPARK = ParticleRegistry.registerParticle("elulib", ParticleSpark.class, new ResourceLocation("elulib:particle/particle_sparkle"));
        PARTICLE_GLITTER = ParticleRegistry.registerParticle("elulib", ParticleGlitter.class, new ResourceLocation("elulib:particle/particle_sparkle"));
    }
}

