/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.tile;

import elucent.elulib.tile.CableNetwork;
import elucent.elulib.tile.CableWorldData;
import elucent.elulib.tile.TileCable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CableManager {
    public static Map<String, Class<? extends CableNetwork>> networkRegistry = new HashMap<String, Class<? extends CableNetwork>>();
    private static int ID = 0;
    private boolean inited = false;

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload event) {
        this.inited = false;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !this.inited && !event.world.field_72995_K) {
            this.inited = true;
            CableWorldData.get(event.world);
            CableWorldData.get(event.world);
            for (CableNetwork n : CableWorldData.networks.values()) {
                for (BlockPos p : n.cables) {
                    TileEntity t = event.world.func_175625_s(p);
                    if (!(t instanceof TileCable) || !((TileCable)t).type.equalsIgnoreCase(n.type)) continue;
                    ((TileCable)t).network = n;
                    t.func_70296_d();
                }
                n.dirty = true;
            }
        } else if (event.phase == TickEvent.Phase.END && !event.world.field_72995_K) {
            CableWorldData d = CableWorldData.get(event.world);
            int i = 0;
            while (true) {
                if (i >= CableWorldData.networks.size()) break;
                Map.Entry e = (Map.Entry)CableWorldData.networks.entrySet().toArray()[i];
                if (!((CableNetwork)e.getValue()).valid) {
                    CableWorldData.networks.remove(e.getKey());
                    i = Math.max(0, i - 1);
                    d.func_76185_a();
                } else {
                    if (((CableNetwork)e.getValue()).dirty) {
                        ((CableNetwork)e.getValue()).updateConnections(event.world);
                    }
                    if (((CableNetwork)e.getValue()).needsDistributionTick()) {
                        ((CableNetwork)e.getValue()).distribute();
                    }
                }
                ++i;
            }
        }
    }

    public static int getNextID(CableWorldData d) {
        int id = ID++;
        while (true) {
            if (!CableWorldData.networks.containsKey(id)) break;
            ++ID;
        }
        return id;
    }
}

